/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.common.util;

import com.chinamcloud.common.util.StringUtil;
import com.chinamcloud.common.util.UUIDUtil;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.regex.Pattern;
import org.apache.commons.lang.ArrayUtils;

public class FileUtil {
    public static boolean writeText(String fileName, String content) {
        return FileUtil.writeText(fileName, content, "UTF-8");
    }

    public static boolean writeText(String fileName, String content, String encoding) {
        return FileUtil.writeText(fileName, content, encoding, false);
    }

    public static boolean writeText(String fileName, String content, String encoding, boolean bomFlag) {
        try {
            byte[] bs = content.getBytes(encoding);
            if (encoding.equalsIgnoreCase("UTF-8") && bomFlag) {
                bs = ArrayUtils.addAll((byte[])StringUtil.BOM, (byte[])bs);
            }
            FileUtil.writeByte(fileName, bs);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] readByte(String fileName) {
        try (FileInputStream fileInputStream = new FileInputStream(fileName);){
            byte[] r = new byte[fileInputStream.available()];
            fileInputStream.read(r);
            byte[] byArray = r;
            return byArray;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] readByte(File f) {
        try (FileInputStream fileInputStream = new FileInputStream(f);){
            byte[] r;
            byte[] byArray = r = FileUtil.readByte(fileInputStream);
            return byArray;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] readByte(InputStream is) {
        try {
            byte[] r = new byte[is.available()];
            is.read(r);
            return r;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean writeByte(String fileName, byte[] b) {
        try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(fileName));){
            bufferedOutputStream.write(b);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean writeByte(File f, byte[] b) {
        try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(f));){
            bufferedOutputStream.write(b);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static String readText(File f) {
        return FileUtil.readText(f, "UTF-8");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readText(File f, String encoding) {
        try (FileInputStream inputStream = new FileInputStream(f);){
            String str;
            String string = str = FileUtil.readText(inputStream, encoding);
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String readText(InputStream is, String encoding) {
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(is, encoding));
            StringBuffer sb = new StringBuffer();
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
            br.close();
            return sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String readText(String fileName) {
        return FileUtil.readText(fileName, "UTF-8");
    }

    /*
     * Exception decompiling
     */
    public static String readText(String fileName, String encoding) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String readURLText(String urlPath) {
        return FileUtil.readURLText(urlPath, "UTF-8");
    }

    public static String readURLText(String urlPath, String encoding) {
        try {
            String line;
            URL url = new URL(urlPath);
            BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream(), encoding));
            StringBuffer sb = new StringBuffer();
            while ((line = in.readLine()) != null) {
                sb.append(line + "\n");
            }
            in.close();
            return sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean delete(String path) {
        File file = new File(path);
        return FileUtil.delete(file);
    }

    public static boolean delete(File file) {
        if (!file.exists()) {
            return false;
        }
        if (file.isFile()) {
            return file.delete();
        }
        return FileUtil.deleteDir(file);
    }

    private static boolean deleteDir(File dir) {
        try {
            return FileUtil.deleteFromDir(dir) && dir.delete();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean mkdir(String path) {
        File dir = new File(path);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return true;
    }

    public static boolean deleteEx(String fileName) {
        int index2;
        int index1 = fileName.lastIndexOf("\\");
        index1 = index1 > (index2 = fileName.lastIndexOf("/")) ? index1 : index2;
        String path = fileName.substring(0, index1);
        String name = fileName.substring(index1 + 1);
        File f = new File(path);
        if (f.exists() && f.isDirectory()) {
            File[] files = f.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (!Pattern.matches(name, files[i].getName())) continue;
                files[i].delete();
            }
            return true;
        }
        return false;
    }

    public static boolean deleteFromDir(String dirPath) {
        File file = new File(dirPath);
        return FileUtil.deleteFromDir(file);
    }

    public static boolean deleteFromDir(File file) {
        if (!file.exists()) {
            return false;
        }
        if (!file.isDirectory()) {
            return false;
        }
        File[] tempList = file.listFiles();
        for (int i = 0; i < tempList.length; ++i) {
            if (FileUtil.delete(tempList[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean copy(String oldPath, String newPath, FileFilter filter) {
        File oldFile = new File(oldPath);
        File[] oldFiles = oldFile.listFiles(filter);
        boolean flag = true;
        if (oldFiles != null) {
            for (int i = 0; i < oldFiles.length; ++i) {
                if (FileUtil.copy(oldFiles[i], newPath + "/" + oldFiles[i].getName())) continue;
                flag = false;
            }
        }
        return flag;
    }

    public static boolean copy(String oldPath, String newPath) {
        File oldFile = new File(oldPath);
        return FileUtil.copy(oldFile, newPath);
    }

    public static boolean copy(File oldFile, String newPath) {
        if (!oldFile.exists()) {
            return false;
        }
        if (oldFile.isFile()) {
            return FileUtil.copyFile(oldFile, newPath);
        }
        return FileUtil.copyDir(oldFile, newPath);
    }

    private static boolean copyFile(File oldFile, String newPath) {
        if (!oldFile.exists()) {
            return false;
        }
        if (!oldFile.isFile()) {
            return false;
        }
        try (FileInputStream inputStream = new FileInputStream(oldFile);
             FileOutputStream fileOutputStream = new FileOutputStream(newPath);){
            int byteread = 0;
            byte[] buffer = new byte[1024];
            while ((byteread = ((InputStream)inputStream).read(buffer)) != -1) {
                fileOutputStream.write(buffer, 0, byteread);
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private static boolean copyDir(File oldDir, String newPath) {
        if (!oldDir.exists()) {
            return false;
        }
        if (!oldDir.isDirectory()) {
            return false;
        }
        try {
            new File(newPath).mkdirs();
            File[] files = oldDir.listFiles();
            File temp = null;
            for (int i = 0; i < files.length; ++i) {
                temp = files[i];
                if (!(temp.isFile() ? !FileUtil.copyFile(temp, newPath + "/" + temp.getName()) : temp.isDirectory() && !FileUtil.copyDir(temp, newPath + "/" + temp.getName()))) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean move(String oldPath, String newPath) {
        return FileUtil.copy(oldPath, newPath) && FileUtil.delete(oldPath);
    }

    public static boolean move(File oldFile, String newPath) {
        return FileUtil.copy(oldFile, newPath) && FileUtil.delete(oldFile);
    }

    public static void serialize(Serializable obj, String fileName) {
        try (FileOutputStream fileOutputStream = new FileOutputStream(fileName);
             ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);){
            objectOutputStream.writeObject(obj);
            objectOutputStream.flush();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Exception decompiling
     */
    public static byte[] serialize(Serializable obj) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static Object unserialize(String fileName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static Object unserialize(byte[] bs) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void uploadFile(File sourceFile, File targetFile) {
        File parentFile = new File(targetFile.getParent());
        parentFile.mkdirs();
        try (FileInputStream inputStream = new FileInputStream(sourceFile);
             FileOutputStream outputStream = new FileOutputStream(targetFile);){
            int len = 0;
            byte[] buffer = new byte[500];
            while (-1 != (len = ((InputStream)inputStream).read(buffer))) {
                ((OutputStream)outputStream).write(buffer, 0, len);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String getFileDataByBR(String path) {
        String xml = "";
        try (FileInputStream fileInputStream = new FileInputStream(path);
             InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "UTF-8");
             BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
            String str = "";
            xml = "";
            while ((str = bufferedReader.readLine()) != null) {
                xml = xml + str + "\n";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return xml;
    }

    public static String getUUIDFileName(String fileName) {
        return UUIDUtil.getUUID() + fileName.substring(fileName.lastIndexOf("."));
    }
}

