/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.common.util;

import com.squareup.okhttp.FormEncodingBuilder;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkHttpUtil {
    private static final Logger log = LoggerFactory.getLogger(OkHttpUtil.class);

    public static String get(String url, Map<String, String> headerMap, Map<String, String> parameterMap) {
        log.info("url:{},headerMap:{},parameter:{}", new Object[]{url, headerMap, parameterMap});
        OkHttpClient okHttpClient = new OkHttpClient();
        Request request = OkHttpUtil.getRequest(url, headerMap, parameterMap);
        try {
            Response response = okHttpClient.newCall(request).execute();
            if (response.isSuccessful()) {
                String jsonString = response.body().string();
                log.info("\u8bf7\u6c42url:{},\u8fd4\u56de:{}", (Object)url, (Object)jsonString);
                return jsonString;
            }
            log.error("\u670d\u52a1\u5668\u7aef\u9519\u8bef", (Object)response.message());
        }
        catch (IOException e) {
            log.error("\u8bf7\u6c42\u9047\u5230\u5f02\u5e38", (Throwable)e);
        }
        return null;
    }

    private static Request getRequest(String url, Map<String, String> headerMap, Map<String, String> parameterMap) {
        String completeUrl = OkHttpUtil.getCompleteUrl(url, parameterMap);
        Request.Builder builder = new Request.Builder();
        if (MapUtils.isNotEmpty(headerMap)) {
            for (String key : headerMap.keySet()) {
                builder.addHeader(key, headerMap.get(key));
            }
        }
        return builder.url(completeUrl).build();
    }

    private static String getCompleteUrl(String url, Map<String, String> parameterMap) {
        if (MapUtils.isEmpty(parameterMap)) {
            return url;
        }
        StringBuilder stringBuilder = new StringBuilder(url).append("?");
        int index = 0;
        for (String key : parameterMap.keySet()) {
            if (index > 0) {
                stringBuilder.append("&");
            }
            stringBuilder.append(key).append("=").append(parameterMap.get(key));
            ++index;
        }
        return stringBuilder.toString();
    }

    public static String postByJson(String url, Map<String, String> headerMap, String parameter) {
        log.info("url:{},headerMap:{},parameter:{}", new Object[]{url, headerMap, parameter});
        MediaType MEDIA_TYPE_TEXT = MediaType.parse((String)"application/json");
        RequestBody requestBody = RequestBody.create((MediaType)MEDIA_TYPE_TEXT, (String)parameter);
        return OkHttpUtil.post(url, headerMap, requestBody);
    }

    private static String post(String url, Map<String, String> headerMap, RequestBody requestBody) {
        OkHttpClient okHttpClient = new OkHttpClient();
        Request.Builder builder = new Request.Builder();
        if (MapUtils.isNotEmpty(headerMap)) {
            for (String key : headerMap.keySet()) {
                builder.addHeader(key, headerMap.get(key));
            }
        }
        Request request = builder.url(url).post(requestBody).build();
        try {
            Response response = okHttpClient.newCall(request).execute();
            if (response.isSuccessful()) {
                String jsonString = response.body().string();
                log.info("\u8bf7\u6c42url:{},\u8fd4\u56de:{}", (Object)url, (Object)jsonString);
                return jsonString;
            }
            log.error("\u670d\u52a1\u5668\u7aef\u9519\u8bef", (Object)response.message());
        }
        catch (IOException e) {
            log.error("\u8bf7\u6c42\u9047\u5230\u5f02\u5e38", (Throwable)e);
        }
        return null;
    }

    public static String postByForm(String url, Map<String, String> headerMap, Map<String, String> parameterMap) {
        log.info("url:{},headerMap:{},parameter:{}", new Object[]{url, headerMap, parameterMap});
        FormEncodingBuilder formEncodingBuilder = new FormEncodingBuilder();
        if (MapUtils.isNotEmpty(parameterMap)) {
            for (String key : parameterMap.keySet()) {
                formEncodingBuilder.add(key, parameterMap.get(key));
            }
        }
        RequestBody requestBody = formEncodingBuilder.build();
        return OkHttpUtil.post(url, headerMap, requestBody);
    }
}

