/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.common.cache.autoconfigure;

import com.chinamcloud.common.cache.properties.MemcacheProperties;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import net.rubyeye.xmemcached.CommandFactory;
import net.rubyeye.xmemcached.MemcachedClient;
import net.rubyeye.xmemcached.MemcachedSessionLocator;
import net.rubyeye.xmemcached.XMemcachedClientBuilder;
import net.rubyeye.xmemcached.command.BinaryCommandFactory;
import net.rubyeye.xmemcached.impl.KetamaMemcachedSessionLocator;
import net.rubyeye.xmemcached.transcoders.SerializingTranscoder;
import net.rubyeye.xmemcached.transcoders.Transcoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableCaching
@ComponentScan(basePackages={"com.chinamcloud.common.cache"})
public class MemcacheClientAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(MemcacheClientAutoConfiguration.class);
    @Autowired
    private MemcacheProperties memcacheProperties;

    @Bean
    public XMemcachedClientBuilder xmemcachedClientBuilderBean() {
        String cache_url = this.memcacheProperties.getMemcached_url();
        HashMap<InetSocketAddress, InetSocketAddress> addressMap = new HashMap<InetSocketAddress, InetSocketAddress>();
        for (String address : cache_url.split(",")) {
            String[] addressSplit = address.split(":");
            InetSocketAddress inetSocketAddress = new InetSocketAddress(addressSplit[0], Integer.parseInt(addressSplit[1]));
            addressMap.put(inetSocketAddress, inetSocketAddress);
        }
        XMemcachedClientBuilder xmemcachedClientBuilder = new XMemcachedClientBuilder(addressMap);
        xmemcachedClientBuilder.setConnectionPoolSize(this.memcacheProperties.getMemcached_pool_size().intValue());
        xmemcachedClientBuilder.setCommandFactory((CommandFactory)new BinaryCommandFactory());
        KetamaMemcachedSessionLocator ketamaMemcachedSessionLocator = new KetamaMemcachedSessionLocator();
        xmemcachedClientBuilder.setSessionLocator((MemcachedSessionLocator)ketamaMemcachedSessionLocator);
        SerializingTranscoder serializingTranscoder = new SerializingTranscoder();
        xmemcachedClientBuilder.setTranscoder((Transcoder)serializingTranscoder);
        return xmemcachedClientBuilder;
    }

    @Bean
    public MemcachedClient memcachedClientBean() {
        MemcachedClient memcachedClient = null;
        try {
            memcachedClient = this.xmemcachedClientBuilderBean().build();
            return memcachedClient;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

