/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.common.cache.client;

import com.chinamcloud.common.cache.constant.CacheConstant;
import java.util.concurrent.TimeoutException;
import net.rubyeye.xmemcached.MemcachedClient;
import net.rubyeye.xmemcached.exception.MemcachedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="memcachedCommonClient")
public class MemcachedCommonClient {
    private static final Logger log = LoggerFactory.getLogger(MemcachedCommonClient.class);
    @Autowired
    private MemcachedClient memcachedClient;

    public boolean set(String key, Object value, Integer expireTime) {
        try {
            return this.memcachedClient.set(key, expireTime.intValue(), value);
        }
        catch (InterruptedException e) {
            log.error("\u7f13\u5b58\u6570\u636e\u9047\u5230\u5f02\u5e38,key:" + key, (Throwable)e);
        }
        catch (MemcachedException e) {
            log.error("\u7f13\u5b58\u6570\u636e\u9047\u5230\u5f02\u5e38,key:" + key, (Throwable)e);
        }
        catch (TimeoutException e) {
            log.error("\u7f13\u5b58\u6570\u636e\u9047\u5230\u5f02\u5e38,key:" + key, (Throwable)e);
        }
        return false;
    }

    public boolean set(String key, Object value) {
        try {
            return this.memcachedClient.set(key, CacheConstant.ONE_WEEK_EXPIRED_TIME.intValue(), value);
        }
        catch (InterruptedException e) {
            log.error("\u7f13\u5b58\u6570\u636e\u9047\u5230\u5f02\u5e38,key:" + key, (Throwable)e);
        }
        catch (MemcachedException e) {
            log.error("\u7f13\u5b58\u6570\u636e\u9047\u5230\u5f02\u5e38,key:" + key, (Throwable)e);
        }
        catch (TimeoutException e) {
            log.error("\u7f13\u5b58\u6570\u636e\u9047\u5230\u5f02\u5e38,key:" + key, (Throwable)e);
        }
        return false;
    }

    public Object get(String key) {
        try {
            return this.memcachedClient.get(key);
        }
        catch (TimeoutException e) {
            log.error("\u83b7\u53d6\u7f13\u5b58\u6570\u636e\u9047\u5230\u5f02\u5e38,key:" + key, (Throwable)e);
        }
        catch (InterruptedException e) {
            log.error("\u83b7\u53d6\u7f13\u5b58\u6570\u636e\u9047\u5230\u5f02\u5e38,key:" + key, (Throwable)e);
        }
        catch (MemcachedException e) {
            log.error("\u83b7\u53d6\u7f13\u5b58\u6570\u636e\u9047\u5230\u5f02\u5e38,key:" + key, (Throwable)e);
        }
        return null;
    }

    public boolean delete(String key) {
        try {
            return this.memcachedClient.delete(key);
        }
        catch (TimeoutException e) {
            log.error("\u5220\u9664\u7f13\u5b58\u6570\u636e\u9047\u5230\u5f02\u5e38,key:" + key, (Throwable)e);
        }
        catch (InterruptedException e) {
            log.error("\u5220\u9664\u7f13\u5b58\u6570\u636e\u9047\u5230\u5f02\u5e38,key:" + key, (Throwable)e);
        }
        catch (MemcachedException e) {
            log.error("\u5220\u9664\u7f13\u5b58\u6570\u636e\u9047\u5230\u5f02\u5e38,key:" + key, (Throwable)e);
        }
        return false;
    }

    public boolean isExist(String key) {
        return null != this.get(key);
    }

    public boolean flushAll() {
        try {
            this.memcachedClient.flushAll();
            return true;
        }
        catch (TimeoutException e) {
            log.error("\u6240\u6709\u7f13\u5b58\u6570\u636e\u7f6e\u4e3a\u65e0\u6548\u9047\u5230\u5f02\u5e38:", (Throwable)e);
        }
        catch (InterruptedException e) {
            log.error("\u6240\u6709\u7f13\u5b58\u6570\u636e\u7f6e\u4e3a\u65e0\u6548\u9047\u5230\u5f02\u5e38:", (Throwable)e);
        }
        catch (MemcachedException e) {
            log.error("\u6240\u6709\u7f13\u5b58\u6570\u636e\u7f6e\u4e3a\u65e0\u6548\u9047\u5230\u5f02\u5e38:", (Throwable)e);
        }
        return false;
    }

    public Long incr(String key, Long delta, Long initValue) {
        return this.incr(key, delta, initValue, CacheConstant.DEFAULT_TIMEOUT, CacheConstant.ONE_WEEK_EXPIRED_TIME);
    }

    public Long incr(String key, Long delta, Long initValue, Long timeout, Integer expireTime) {
        try {
            return this.memcachedClient.incr(key, delta.longValue(), initValue.longValue(), timeout.longValue(), expireTime.intValue());
        }
        catch (TimeoutException e) {
            log.error("\u7f13\u5b58\u6570\u636e\u81ea\u589e\u9047\u5230\u5f02\u5e38:", (Throwable)e);
        }
        catch (InterruptedException e) {
            log.error("\u7f13\u5b58\u6570\u636e\u81ea\u589e\u9047\u5230\u5f02\u5e38:", (Throwable)e);
        }
        catch (MemcachedException e) {
            log.error("\u7f13\u5b58\u6570\u636e\u81ea\u589e\u9047\u5230\u5f02\u5e38:", (Throwable)e);
        }
        throw new RuntimeException("\u7f13\u5b58\u6570\u636e\u81ea\u589e\u9047\u5230\u5f02\u5e38");
    }

    public Long decr(String key, Long delta, Long initValue) {
        return this.decr(key, delta, initValue, CacheConstant.DEFAULT_TIMEOUT, CacheConstant.ONE_WEEK_EXPIRED_TIME);
    }

    public Long decr(String key, Long delta, Long initValue, Long timeout, Integer expireTime) {
        try {
            return this.memcachedClient.incr(key, delta.longValue(), initValue.longValue(), timeout.longValue(), expireTime.intValue());
        }
        catch (TimeoutException e) {
            log.error("\u7f13\u5b58\u6570\u636e\u81ea\u589e\u9047\u5230\u5f02\u5e38:", (Throwable)e);
        }
        catch (InterruptedException e) {
            log.error("\u7f13\u5b58\u6570\u636e\u81ea\u589e\u9047\u5230\u5f02\u5e38:", (Throwable)e);
        }
        catch (MemcachedException e) {
            log.error("\u7f13\u5b58\u6570\u636e\u81ea\u589e\u9047\u5230\u5f02\u5e38:", (Throwable)e);
        }
        throw new RuntimeException("\u7f13\u5b58\u6570\u636e\u81ea\u589e\u9047\u5230\u5f02\u5e38");
    }
}

