/*
 * Decompiled with CFR 0.152.
 */
package com.chinamclound.common.cache.client;

import com.chinamcloud.common.cache.constant.CacheConstant;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.BoundSetOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.stereotype.Component;

@Component(value="redisCommonClient")
public class RedisCommonClient<K, V> {
    @Autowired
    private RedisTemplate<K, V> redisTemplate;
    @Resource(name="redisTemplate")
    private ValueOperations<K, V> valueOperations;

    public boolean set(K key, V value, Integer expireTime) {
        this.valueOperations.set(key, value, expireTime.longValue(), TimeUnit.SECONDS);
        return true;
    }

    public boolean set(K key, V value) {
        return this.set(key, value, CacheConstant.ONE_WEEK_EXPIRED_TIME);
    }

    public V get(K key) {
        return (V)this.valueOperations.get(key);
    }

    public boolean delete(K key) {
        this.redisTemplate.delete(key);
        return true;
    }

    public boolean isExist(K key) {
        return this.redisTemplate.hasKey(key);
    }

    public Long incr(K key, Long delta, Integer expireTime) {
        Long incrementSum = this.valueOperations.increment(key, delta.longValue());
        this.redisTemplate.expire(key, (long)expireTime.intValue(), TimeUnit.SECONDS);
        return incrementSum;
    }

    public Long resetZero(K key) {
        Long cacheValue = this.valueOperations.increment(key, 0L);
        this.valueOperations.increment(key, -cacheValue.longValue());
        return cacheValue;
    }

    public void setCacheSet(K key, V value, Integer expireTime) {
        BoundSetOperations setOperations = this.redisTemplate.boundSetOps(key);
        setOperations.add(new Object[]{value});
        setOperations.expire(expireTime.longValue(), TimeUnit.SECONDS);
    }

    public V cacheSetPop(K key) {
        BoundSetOperations setOperations = this.redisTemplate.boundSetOps(key);
        return (V)setOperations.pop();
    }

    public Long cacheSetSize(K key) {
        BoundSetOperations setOperations = this.redisTemplate.boundSetOps(key);
        return setOperations.size();
    }

    public Set<V> getCacheSet(K key) {
        BoundSetOperations setOperations = this.redisTemplate.boundSetOps(key);
        return setOperations.members();
    }
}

