/*
 * Decompiled with CFR 0.152.
 */
package com.chinamclound.common.cache.autoconfigure;

import java.net.UnknownHostException;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.GenericToStringSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

@Configuration
@EnableCaching
@ComponentScan(basePackages={"com.chinamclound.common.cache"})
public class RedisClientAutoConfiguration {
    @Bean(value={"redisTemplate"})
    public RedisTemplate<Object, Object> redisTemplate(RedisConnectionFactory redisConnectionFactory) throws UnknownHostException {
        RedisTemplate template = new RedisTemplate();
        template.setConnectionFactory(redisConnectionFactory);
        return template;
    }

    @Bean(name={"longRedisTemplate"})
    public RedisTemplate<Object, Object> longRedisTemplate(RedisConnectionFactory redisConnectionFactory) throws UnknownHostException {
        RedisTemplate redisTemplate = new RedisTemplate();
        redisTemplate.setConnectionFactory(redisConnectionFactory);
        redisTemplate.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        redisTemplate.setValueSerializer((RedisSerializer)new GenericToStringSerializer(Long.class));
        redisTemplate.setHashKeySerializer((RedisSerializer)new GenericToStringSerializer(Long.class));
        redisTemplate.setHashValueSerializer((RedisSerializer)new GenericToStringSerializer(Long.class));
        return redisTemplate;
    }
}

