/*
 * Decompiled with CFR 0.152.
 */
package com.chinamclound.common.cache.client;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component(value="redisMapCommonClient")
public class RedisMapCommonClient<K, HK, HV> {
    @Autowired
    @Resource(name="redisTemplate")
    private RedisTemplate<K, Object> redisTemplate;
    @Autowired
    @Resource(name="longRedisTemplate")
    private RedisTemplate<K, Object> longRedisTemplate;

    public boolean putCacheMap(K cacheKey, Map<HK, HV> cacheMap, Integer expireTime) {
        BoundHashOperations hashOperations = this.redisTemplate.boundHashOps(cacheKey);
        hashOperations.putAll(cacheMap);
        hashOperations.expire((long)expireTime.intValue(), TimeUnit.SECONDS);
        return true;
    }

    public Map<HK, HV> getCacheMapByObject(K cacheKey, List<HK> mapKeyList) {
        BoundHashOperations hashOperations = this.redisTemplate.boundHashOps(cacheKey);
        List mapValueList = hashOperations.multiGet(mapKeyList);
        HashMap resultMap = Maps.newHashMap();
        for (int i = 0; i < mapValueList.size(); ++i) {
            Object mapValue = mapValueList.get(i);
            if (mapValue == null) continue;
            resultMap.put(mapKeyList.get(i), mapValue);
        }
        return resultMap;
    }

    public Map<HK, HV> getCacheMapByLong(K cacheKey, List<HK> mapKeyList) {
        BoundHashOperations hashOperations = this.longRedisTemplate.boundHashOps(cacheKey);
        List mapValueList = hashOperations.multiGet(mapKeyList);
        HashMap resultMap = Maps.newHashMap();
        for (int i = 0; i < mapValueList.size(); ++i) {
            Object mapValue = mapValueList.get(i);
            if (mapValue == null) continue;
            resultMap.put(mapKeyList.get(i), mapValue);
        }
        return resultMap;
    }

    public Long delete(K cacheKey, List<HK> mapKeyList) {
        BoundHashOperations hashOperations = this.redisTemplate.boundHashOps(cacheKey);
        return hashOperations.delete(mapKeyList.toArray());
    }

    public Long increment(K cacheKey, HK mapKey, Long delta, Integer expireTime) {
        BoundHashOperations hashOperations = this.longRedisTemplate.boundHashOps(cacheKey);
        hashOperations.expire((long)expireTime.intValue(), TimeUnit.SECONDS);
        return hashOperations.increment(mapKey, delta.longValue());
    }

    public HV deleteAndReturnValueByObject(K cacheKey, HK mapKey) {
        BoundHashOperations hashOperations = this.redisTemplate.boundHashOps(cacheKey);
        Object mapValue = hashOperations.get(mapKey);
        hashOperations.delete(new Object[]{mapKey});
        return (HV)mapValue;
    }

    public HV deleteAndReturnValueByLong(K cacheKey, HK mapKey) {
        BoundHashOperations hashOperations = this.longRedisTemplate.boundHashOps(cacheKey);
        Object mapValue = hashOperations.get(mapKey);
        hashOperations.delete(new Object[]{mapKey});
        return (HV)mapValue;
    }
}

