package com.chinamclound.common.cache.client;

import com.chinamcloud.common.cache.constant.CacheConstant;
import com.chinamclound.common.cache.properties.RedisCustomizeProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.concurrent.TimeUnit;

/**
 * Created with IntelliJ IDEA.
 * User: chenzhiwei
 * Date: 17/5/11
 * Time: 下午1:44
 * 参考：http://www.cnblogs.com/0201zcr/p/4987561.html
 */
@Component("redisCommonClient")
public class RedisCommonClient<K, V> {

    //Spring Boot已为我们配置RedisTemplate，在此处可以直接注入
    @Autowired
    @Resource(name = "redisTemplate")
    private RedisTemplate<K, V> redisTemplate;
    //可以使用@Resource注解指定redisTmplate，可以注入基于对象的简单属性操作
    @Resource(name = "redisTemplate")
    private ValueOperations<K, V> valueOperations;
    @Autowired
    private RedisCustomizeProperties redisCustomizeProperties;


    /**
     * 保存到缓存
     *
     * @param key：缓存的键
     * @param value：缓存的值
     * @param expireTime：过期时间,单位秒
     * @return
     * @see CacheConstant
     */
    public boolean set(K key, V value, Integer expireTime) {
        valueOperations.set(key, value, expireTime.longValue(), TimeUnit.SECONDS);
        return true;
    }

    /**
     * 保存到缓存,默认1天
     *
     * @param key：缓存的键
     * @param value：缓存的值
     * @return
     */
    public boolean set(K key, V value) {
        return set(key, value, redisCustomizeProperties.getDefaultExpiration());
    }

    /**
     * 获得缓存key相关的值
     *
     * @param key
     * @return
     */
    public V get(K key) {
        return valueOperations.get(key);
    }


    /**
     * 删除缓存数据
     *
     * @param key
     * @return
     */
    public void delete(K key) {
        redisTemplate.delete(key);
    }

    /**
     * 指定key是否存在
     *
     * @param key
     * @return
     */
    public boolean isExist(K key) {
        return redisTemplate.hasKey(key);
    }


}
