/*
 * Decompiled with CFR 0.152.
 */
package com.chinamclound.common.datasource.transformer;

import com.alibaba.druid.pool.DruidDataSource;
import com.chinamcloud.common.guava2.SafeFunction;
import com.chinamclound.common.datasource.DatabaseProperties;
import java.sql.SQLException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public final class DatabaseProperties2DruidDataSource
extends SafeFunction<DatabaseProperties, DruidDataSource> {
    private static final Logger log = LoggerFactory.getLogger(DatabaseProperties2DruidDataSource.class);
    public static final DatabaseProperties2DruidDataSource INSTANCE = new DatabaseProperties2DruidDataSource();

    protected DruidDataSource safeApply(DatabaseProperties databaseProperties) {
        DruidDataSource druidDataSource = new DruidDataSource();
        druidDataSource.setDriverClassName(databaseProperties.getDriverClassName());
        druidDataSource.setUrl(databaseProperties.getUrl());
        druidDataSource.setUsername(databaseProperties.getUsername());
        druidDataSource.setPassword(databaseProperties.getPassword());
        druidDataSource.setInitialSize(databaseProperties.getInitialSize());
        druidDataSource.setMinIdle(databaseProperties.getMinIdle());
        druidDataSource.setMaxActive(databaseProperties.getMaxActive());
        druidDataSource.setMaxWait((long)databaseProperties.getMaxWait());
        druidDataSource.setTimeBetweenEvictionRunsMillis(databaseProperties.getTimeBetweenEvictionRunsMillis());
        druidDataSource.setMinEvictableIdleTimeMillis(databaseProperties.getMinEvictableIdleTimeMillis().longValue());
        druidDataSource.setValidationQuery(databaseProperties.getValidationQuery());
        druidDataSource.setTestWhileIdle(databaseProperties.isTestWhileIdle());
        druidDataSource.setTestOnBorrow(databaseProperties.isTestOnBorrow());
        druidDataSource.setTestOnReturn(databaseProperties.isTestOnReturn());
        try {
            if (!StringUtils.isEmpty((Object)databaseProperties.getFilters())) {
                log.info("druidDataSource.setFilters:{}", (Object)databaseProperties.getFilters());
                druidDataSource.setFilters(databaseProperties.getFilters());
                if (!StringUtils.isEmpty((Object)databaseProperties.getConnectionProperties())) {
                    String connectionProperties = databaseProperties.getConnectionProperties();
                    Properties properties = this.getProperties(connectionProperties);
                    druidDataSource.setConnectProperties(properties);
                }
            }
        }
        catch (SQLException e) {
            log.error("DatabaseProperties2DruidDataSource error", (Throwable)e);
        }
        return druidDataSource;
    }

    private Properties getProperties(String connectionProperties) {
        String[] split = connectionProperties.split(";");
        Properties properties = new Properties();
        for (String kvString : split) {
            String[] kv = kvString.split("=");
            properties.put(kv[0], kv[1]);
        }
        return properties;
    }

    private DatabaseProperties2DruidDataSource() {
    }
}

