package com.chinamclound.common.datasource.autoconfigure;

import com.alibaba.druid.pool.DruidDataSource;
import com.chinamclound.common.datasource.constant.DataSourceConstant;
import com.chinamclound.common.datasource.multiple.DynamicDataSource;
import com.chinamclound.common.datasource.properties.DatabaseProperties;
import com.chinamclound.common.datasource.transformer.DatabaseProperties2DruidDataSource;
import com.github.pagehelper.PageHelper;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.map.HashedMap;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.util.StringUtils;

import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;

/**
 * Created with IntelliJ IDEA.
 * User: chenzhiwei
 * Date: 16/12/19
 * Time: 下午2:39
 * druid配置：
 * 参：http://www.jianshu.com/p/cef49ad91ba9
 * gitHub:git@github.com:liangAhh/spring-boot-druid.git
 *
 * @ConditionalOnClass :当类路径下有指定类的条件下。
 */
@Slf4j
@Configuration
@EnableTransactionManagement
@ComponentScan(basePackages={"com.chinamclound.common.datasource"})
public class MultipleDatabaseAutoConfiguration {

    @Autowired
    private DatabaseProperties databaseProperties;


    /**
     * 提供SqlSeesion
     * bean的名字不要改：MapperScannerConfigurer中使用到了
     * @ConditionalOnMissingBean :当容器里没有指定Bean的情况下
     * @return
     * @throws Exception
     */
    @Bean("sqlSessionFactory")
    public SqlSessionFactory sqlSessionFactoryBean() throws Exception {
        log.info("*** sqlSessionFactoryBean init begin ***");
        SqlSessionFactoryBean sqlSessionFactoryBean = new SqlSessionFactoryBean();
        sqlSessionFactoryBean.setDataSource(dynamicDataSourceBean());
        //mybatis分页
        PageHelper pageHelper = new PageHelper();
        Properties properties = new Properties();
        properties.setProperty("dialect", "mysql");
        properties.setProperty("reasonable", "true");
        properties.setProperty("supportMethodsArguments", "true");
        properties.setProperty("returnPageInfo", "check");
        properties.setProperty("params", "count=countSql");
        pageHelper.setProperties(properties); //添加插件
        sqlSessionFactoryBean.setPlugins(new Interceptor[]{pageHelper});
        if(!StringUtils.isEmpty(databaseProperties.getMybatisXml())){
            log.info("mybatis XmlLocationPattern :{}",databaseProperties.getMybatisXml());
            PathMatchingResourcePatternResolver pathMatchingResourcePatternResolver = new PathMatchingResourcePatternResolver();
            sqlSessionFactoryBean.setMapperLocations(pathMatchingResourcePatternResolver.getResources(databaseProperties.getMybatisXml()));
        }
        log.info("*** sqlSessionFactoryBean init end ***");
        return sqlSessionFactoryBean.getObject();
    }

    @Bean
    public PlatformTransactionManager transactionManager() throws SQLException {
        log.info("*** dataSourceTransactionManager init begin ***");
        DataSourceTransactionManager dataSourceTransactionManager = new DataSourceTransactionManager(dynamicDataSourceBean());
        log.info("*** dataSourceTransactionManager init end ***");
        return dataSourceTransactionManager;
    }

    @Bean
    @Primary
    public DynamicDataSource dynamicDataSourceBean() throws SQLException {
        log.info("*** dynamicDataSource init begin ***");
        DynamicDataSource dynamicDataSource = new DynamicDataSource();
        DruidDataSource druidDataSource = DatabaseProperties2DruidDataSource.INSTANCE.apply(databaseProperties);
        dynamicDataSource.setDefaultTargetDataSource(druidDataSource);
        dynamicDataSource.setRecordDefaultTargetDataSource(druidDataSource);
        Map<Object,Object> targetDataSourceMap = new HashedMap();
        targetDataSourceMap.put(DataSourceConstant.DEFAULT_TENANTID,druidDataSource);
        dynamicDataSource.setTargetDataSources(targetDataSourceMap);
        dynamicDataSource.setRecordTargetDataSources(targetDataSourceMap);
        log.info("*** dynamicDataSource init end ***");
        return dynamicDataSource;
    }

}
