package com.chinamclound.common.datasource.interceptor;

import com.chinamcloud.common.constants.ResultConstants;
import com.chinamcloud.common.result.ResultDTO;
import com.chinamclound.common.datasource.multiple.DynamicDataSource;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.PrintWriter;

/**
 * Created with IntelliJ IDEA.
 * User: chenzhiwei
 * Date: 16/12/23
 * Time: 下午7:14
 */
@Slf4j
@Component
public class SwitchDataSourceInterceptor extends HandlerInterceptorAdapter {

    @Autowired
    private DynamicDataSource dynamicDataSource;

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler)
            throws Exception {
        String tenantId = request.getParameter("tenantid");
        log.info("准备切换数据源，tenantId：{}：",tenantId);
        String errorMeg = null;
        if (StringUtils.isNotBlank(tenantId)) {
            ResultDTO<Boolean> booleanResultDTO = dynamicDataSource.switchDataSourceByTenantId(tenantId);
            if(booleanResultDTO.isSuccess()){
                log.info("成功切换数据源，tenantId：{}：",tenantId);
                return true;
            }
            errorMeg = booleanResultDTO.getDescription();
        }else {
            errorMeg = "tenantid不能为空";
        }
        log.error("切数据源失败失败,tenantid:{},error:{},",tenantId,errorMeg);
        ResultDTO<String> resultDTO = new ResultDTO<String>();
        resultDTO.setCode(ResultConstants.SWITCH_DATABASE_FAIL);
        resultDTO.setDescription("切库失败");
        resultDTO.setData(errorMeg);
        PrintWriter printWriter = response.getWriter();
        printWriter.write(resultDTO.toJson().toString());
        printWriter.close();
        return false;
    }

    @Override
    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler,
                           ModelAndView modelAndView) throws Exception {
        super.postHandle(request, response, handler, modelAndView);
    }
}
