/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.common.storage.transformer;

import com.aliyun.oss.model.Bucket;
import com.aliyun.oss.model.StorageClass;
import com.chinamcloud.common.guava2.SafeFunction;
import com.chinamcloud.common.storage.constant.StorageType;
import com.chinamcloud.common.storage.dto.BucketDTO;
import com.chinamcloud.common.storage.dto.OwnerDTO;

public final class Bucket2DTOTransformer
extends SafeFunction<Bucket, BucketDTO> {
    public static final Bucket2DTOTransformer INSTANCE = new Bucket2DTOTransformer();

    protected BucketDTO safeApply(Bucket input) {
        BucketDTO output = new BucketDTO();
        output.setName(input.getName());
        if (input.getOwner() != null) {
            OwnerDTO ownerDTO = new OwnerDTO();
            ownerDTO.setId(input.getOwner().getId());
            ownerDTO.setDisplayName(input.getOwner().getDisplayName());
            output.setOwnerDTO(ownerDTO);
        }
        output.setLocation(input.getLocation());
        output.setCreationDate(input.getCreationDate());
        StorageClass storageClass = input.getStorageClass();
        if (storageClass != null) {
            StorageType storageType = StorageType.parse(storageClass.name());
            output.setStorageType(storageType);
        }
        output.setExtranetEndpoint(input.getExtranetEndpoint());
        output.setIntranetEndpoint(input.getIntranetEndpoint());
        return output;
    }

    private Bucket2DTOTransformer() {
    }
}

