/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.common.storage.util;

import com.chinamcloud.common.result.ResultDTO;
import com.chinamcloud.common.storage.dto.FileStorageDTO;
import com.chinamcloud.common.storage.dto.ThirdStorageFileBaseDTO;
import com.chinamcloud.common.storage.dto.ThirdStorageFileDeleteDTO;
import com.chinamcloud.common.storage.dto.ThirdStorageFileUploadDTO;
import com.chinamcloud.common.storage.dto.ThirdStorageSimpleUploadResultDTO;
import com.chinamcloud.common.storage.util.ThirdStorageFileUtil;
import com.chinamcloud.common.util.FileUtil;
import com.google.common.collect.Lists;
import com.google.common.math.IntMath;
import java.io.File;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.fileupload.FileItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileStorageUtil {
    private static final Logger log = LoggerFactory.getLogger(FileStorageUtil.class);

    public static void saveFile(FileStorageDTO fileStorageDTO, String textContent) {
        File file;
        log.info("\u4fdd\u5b58\u6587\u4ef6:fileStorageDTO:{}", (Object)fileStorageDTO);
        if (fileStorageDTO.isSupportOSSStorage()) {
            file = FileStorageUtil.writeStringToLocalFile(System.getProperty("java.io.tmpdir"), fileStorageDTO.getSaveFileName(), textContent);
            ThirdStorageFileUploadDTO thirdStorageFileUploadDTO = FileStorageUtil.builderSimpleThirdStorageFileUploadDTO(fileStorageDTO.getOssBucketName(), fileStorageDTO.getStorageParentPath(), fileStorageDTO.getSaveFileName());
            ResultDTO<ThirdStorageSimpleUploadResultDTO> thirdStorageSimpleUploadResultDTOResultDTO = ThirdStorageFileUtil.simpleUploadByFilePath(thirdStorageFileUploadDTO, file.getAbsolutePath());
            if (!thirdStorageSimpleUploadResultDTOResultDTO.isSuccess()) {
                FileStorageUtil.deleteFileByCondition(file, true);
                throw new RuntimeException("\u4e0a\u4f20\u5230\u4e91\u5b58\u50a8\u5931\u8d25:" + thirdStorageSimpleUploadResultDTOResultDTO.getDescription());
            }
        } else {
            file = FileStorageUtil.writeStringToLocalFile(fileStorageDTO.getStorageParentPath(), fileStorageDTO.getSaveFileName(), textContent);
        }
        FileStorageUtil.deleteFileByCondition(file, fileStorageDTO.isSupportOSSStorage());
    }

    public static File writeFileItemToLocalFile(String storageParentPath, String saveFileName, FileItem fileItem) throws Exception {
        log.info("\u5199\u6587\u4ef6\u5230\u672c\u5730\u5b58\u50a8:storageParentPath:{},saveFileName:{}", (Object)storageParentPath, (Object)saveFileName);
        File parentFile = new File(storageParentPath);
        if (!parentFile.exists()) {
            parentFile.mkdirs();
        }
        String filePath = null;
        filePath = storageParentPath.endsWith("/") ? storageParentPath + saveFileName : storageParentPath + "/" + saveFileName;
        File file = new File(filePath);
        fileItem.write(file);
        return file;
    }

    private static File writeStringToLocalFile(String storageParentPath, String saveFileName, String textContent) {
        File parentFile = new File(storageParentPath);
        if (!parentFile.exists()) {
            parentFile.mkdirs();
        }
        String filePath = null;
        filePath = storageParentPath.endsWith("/") ? storageParentPath + saveFileName : storageParentPath + "/" + saveFileName;
        FileUtil.writeText((String)filePath, (String)textContent);
        return new File(filePath);
    }

    public static ThirdStorageFileUploadDTO builderSimpleThirdStorageFileUploadDTO(String ossBucketName, String urlPartPath, String saveFileName) {
        ThirdStorageFileUploadDTO thirdStorageFileUploadDTO = new ThirdStorageFileUploadDTO();
        ThirdStorageFileBaseDTO thirdStorageFileBaseDTO = new ThirdStorageFileBaseDTO();
        thirdStorageFileBaseDTO.setBucketName(ossBucketName);
        String ossFileName = null;
        ossFileName = urlPartPath.endsWith("/") ? urlPartPath + saveFileName : urlPartPath + "/" + saveFileName;
        if (ossFileName.startsWith("/")) {
            ossFileName = ossFileName.substring(1);
        }
        thirdStorageFileBaseDTO.setFileName(ossFileName);
        thirdStorageFileUploadDTO.setThirdStorageFileBaseDTO(thirdStorageFileBaseDTO);
        return thirdStorageFileUploadDTO;
    }

    public static void deleteFileByCondition(File file, boolean isDelete) {
        log.info("\u5220\u9664:\u6587\u4ef6\u8def\u5f84:{},isDelete:{}", (Object)file.getAbsoluteFile(), (Object)isDelete);
        if (isDelete && file.exists()) {
            file.delete();
        }
    }

    public static void deleteFile(String ossBucketName, List<String> deleteFilePathList) {
        log.info("\u5220\u9664:ossBucketName:{},deleteFilePathList:{}", (Object)ossBucketName, deleteFilePathList);
        if (CollectionUtils.isEmpty(deleteFilePathList)) {
            return;
        }
        int pageSize = 1000;
        int totalSize = deleteFilePathList.size();
        int pageNum = IntMath.divide((int)totalSize, (int)pageSize, (RoundingMode)RoundingMode.CEILING);
        for (int m = 0; m < pageNum; ++m) {
            ThirdStorageFileDeleteDTO thirdStorageFileDeleteDTO = new ThirdStorageFileDeleteDTO();
            thirdStorageFileDeleteDTO.setBucketName(ossBucketName);
            int fromIndex = m * pageSize;
            int toIndex = pageSize;
            if (m == pageNum - 1) {
                fromIndex = m * pageSize;
                toIndex = totalSize;
            }
            List<String> subDeleteFilePathList = deleteFilePathList.subList(fromIndex, toIndex);
            thirdStorageFileDeleteDTO.setFileNameList(FileStorageUtil.builderDeleteFileNameList(subDeleteFilePathList));
            ThirdStorageFileUtil.deleteFiles(thirdStorageFileDeleteDTO);
        }
        for (int i = 0; i < deleteFilePathList.size(); ++i) {
            boolean delete = FileUtil.delete((String)deleteFilePathList.get(i));
            if (delete) {
                log.info("\u5220\u9664\u9759\u6001\u6587\u4ef6:{}", (Object)deleteFilePathList.get(i));
                continue;
            }
            log.info("\u9759\u6001\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u65e0\u9700\u5220\u9664:{}", (Object)deleteFilePathList.get(i));
        }
    }

    private static List<String> builderDeleteFileNameList(List<String> deleteFilePathList) {
        ArrayList fileNameList = Lists.newArrayList();
        for (int i = 0; i < deleteFilePathList.size(); ++i) {
            String deleteFilePath = deleteFilePathList.get(i);
            if (deleteFilePath.startsWith("/")) {
                fileNameList.add(deleteFilePath.substring(1));
                continue;
            }
            fileNameList.add(deleteFilePath);
        }
        return fileNameList;
    }
}

