/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.common.storage.util;

import com.alibaba.fastjson.JSON;
import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.model.CompleteMultipartUploadResult;
import com.aliyun.oss.model.DeleteObjectsRequest;
import com.aliyun.oss.model.DeleteObjectsResult;
import com.aliyun.oss.model.DownloadFileRequest;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PutObjectRequest;
import com.aliyun.oss.model.PutObjectResult;
import com.aliyun.oss.model.UploadFileRequest;
import com.aliyun.oss.model.UploadFileResult;
import com.chinamcloud.common.result.ResultDTO;
import com.chinamcloud.common.storage.dto.CompleteMultipartUploadResultDTO;
import com.chinamcloud.common.storage.dto.MetadataDTO;
import com.chinamcloud.common.storage.dto.ThirdStorageDownloadFileResultDTO;
import com.chinamcloud.common.storage.dto.ThirdStorageFileBaseDTO;
import com.chinamcloud.common.storage.dto.ThirdStorageFileDeleteDTO;
import com.chinamcloud.common.storage.dto.ThirdStorageFileUploadDTO;
import com.chinamcloud.common.storage.dto.ThirdStorageSimpleUploadResultDTO;
import com.chinamcloud.common.storage.properties.StorageProperties;
import com.chinamcloud.common.storage.transformer.CompleteMultipartUploadResult2DTOTransformer;
import com.chinamcloud.common.storage.transformer.DownloadFileResult2DTOTransformer;
import com.chinamcloud.common.storage.transformer.ObjectMetadata2MetadataDTOTransformer;
import com.chinamcloud.common.storage.transformer.PutObjectResult2SimpleUploadResultDTOTransformer;
import com.chinamcloud.common.storage.util.OSSClientUtil;
import com.google.common.base.MoreObjects;
import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThirdStorageFileUtil {
    private static final Logger log = LoggerFactory.getLogger(ThirdStorageFileUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResultDTO<ThirdStorageSimpleUploadResultDTO> simpleUploadByInputStream(ThirdStorageFileUploadDTO thirdStorageFileUploadDTO, InputStream inputStream) {
        ResultDTO<Boolean> booleanResultDTO = ThirdStorageFileUtil.checkFileUploadDTO(thirdStorageFileUploadDTO);
        if (!booleanResultDTO.isSuccess()) {
            return ResultDTO.fail((String)booleanResultDTO.getDescription());
        }
        if (inputStream == null) {
            return ResultDTO.fail((String)"input inputStream is not null");
        }
        ThirdStorageFileBaseDTO fileBaseDTO = thirdStorageFileUploadDTO.getThirdStorageFileBaseDTO();
        OSSClient ossClient = OSSClientUtil.createOssClient(fileBaseDTO.getEndpoint());
        ObjectMetadata objectMetadata = ThirdStorageFileUtil.getObjectMetadata(thirdStorageFileUploadDTO);
        PutObjectRequest putObjectRequest = new PutObjectRequest(fileBaseDTO.getBucketName(), fileBaseDTO.getFileName(), inputStream, objectMetadata);
        try {
            PutObjectResult putObjectResult = ossClient.putObject(putObjectRequest);
            log.info("putObjectResult:{}", (Object)JSON.toJSONString((Object)putObjectResult, (boolean)true));
            ThirdStorageSimpleUploadResultDTO thirdStorageSimpleUploadResultDTO = ThirdStorageFileUtil.builderSimpleUploadResultDTO(fileBaseDTO, putObjectResult);
            log.info("thirdStorageSimpleUploadResultDTO:{}", (Object)JSON.toJSONString((Object)thirdStorageSimpleUploadResultDTO, (boolean)true));
            ResultDTO resultDTO = ResultDTO.successfy((Object)thirdStorageSimpleUploadResultDTO);
            return resultDTO;
        }
        catch (OSSException ossException) {
            log.error("\u4e0a\u4f20\u6587\u4ef6\u9047\u5230OSSException\u5f02\u5e38", (Throwable)ossException);
            ResultDTO resultDTO = ResultDTO.fail((String)("\u4e0a\u4f20\u6587\u4ef6\u9047\u5230\u5f02\u5e38:" + ossException.getMessage()));
            return resultDTO;
        }
        catch (ClientException e) {
            log.error("\u4e0a\u4f20\u6587\u4ef6\u9047\u5230ClientException\u5f02\u5e38", (Throwable)e);
            ResultDTO resultDTO = ResultDTO.fail((String)"\u4e0a\u4f20\u6587\u4ef6\u9047\u5230\u5ba2\u6237\u7aef\u5f02\u5e38");
            return resultDTO;
        }
        finally {
            ossClient.shutdown();
        }
    }

    private static ThirdStorageSimpleUploadResultDTO builderSimpleUploadResultDTO(ThirdStorageFileBaseDTO thirdStorageFileBaseDTO, PutObjectResult putObjectResult) {
        ThirdStorageSimpleUploadResultDTO thirdStorageSimpleUploadResultDTO = (ThirdStorageSimpleUploadResultDTO)PutObjectResult2SimpleUploadResultDTOTransformer.INSTANCE.apply(putObjectResult);
        String location = ThirdStorageFileUtil.builderLocation(thirdStorageFileBaseDTO);
        thirdStorageSimpleUploadResultDTO.setLocation(location);
        return thirdStorageSimpleUploadResultDTO;
    }

    private static String builderLocation(ThirdStorageFileBaseDTO thirdStorageFileBaseDTO) {
        StringBuilder stringBuilder = new StringBuilder();
        String endPoint = (String)MoreObjects.firstNonNull((Object)thirdStorageFileBaseDTO.getEndpoint(), (Object)StorageProperties.getInstance().getOss_default_endpoint());
        endPoint = endPoint.replace("://", "://" + thirdStorageFileBaseDTO.getBucketName() + ".");
        stringBuilder.append(endPoint);
        stringBuilder.append("/");
        stringBuilder.append(thirdStorageFileBaseDTO.getFileName());
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResultDTO<ThirdStorageSimpleUploadResultDTO> simpleUploadByFilePath(ThirdStorageFileUploadDTO thirdStorageFileUploadDTO, String uploadFilePath) {
        ResultDTO<Boolean> booleanResultDTO = ThirdStorageFileUtil.checkFileUploadDTO(thirdStorageFileUploadDTO);
        if (!booleanResultDTO.isSuccess()) {
            return ResultDTO.fail((String)booleanResultDTO.getDescription());
        }
        if (StringUtils.isBlank((String)uploadFilePath)) {
            return ResultDTO.fail((String)"input filePath is not null");
        }
        ThirdStorageFileBaseDTO fileBaseDTO = thirdStorageFileUploadDTO.getThirdStorageFileBaseDTO();
        OSSClient ossClient = OSSClientUtil.createOssClient(fileBaseDTO.getEndpoint());
        ObjectMetadata objectMetadata = ThirdStorageFileUtil.getObjectMetadata(thirdStorageFileUploadDTO);
        PutObjectRequest putObjectRequest = new PutObjectRequest(fileBaseDTO.getBucketName(), fileBaseDTO.getFileName(), new File(uploadFilePath), objectMetadata);
        try {
            PutObjectResult putObjectResult = ossClient.putObject(putObjectRequest);
            log.info("putObjectResult:{}", (Object)JSON.toJSONString((Object)putObjectResult, (boolean)true));
            ThirdStorageSimpleUploadResultDTO thirdStorageSimpleUploadResultDTO = ThirdStorageFileUtil.builderSimpleUploadResultDTO(fileBaseDTO, putObjectResult);
            log.info("thirdStorageSimpleUploadResultDTO:{}", (Object)JSON.toJSONString((Object)thirdStorageSimpleUploadResultDTO, (boolean)true));
            ResultDTO resultDTO = ResultDTO.successfy((Object)thirdStorageSimpleUploadResultDTO);
            return resultDTO;
        }
        catch (OSSException ossException) {
            log.error("\u4e0a\u4f20\u6587\u4ef6\u9047\u5230OSSException\u5f02\u5e38", (Throwable)ossException);
            ResultDTO resultDTO = ResultDTO.fail((String)("\u4e0a\u4f20\u6587\u4ef6\u9047\u5230\u5f02\u5e38:" + ossException.getMessage()));
            return resultDTO;
        }
        catch (ClientException e) {
            log.error("\u4e0a\u4f20\u6587\u4ef6\u9047\u5230ClientException\u5f02\u5e38", (Throwable)e);
            ResultDTO resultDTO = ResultDTO.fail((String)"\u4e0a\u4f20\u6587\u4ef6\u9047\u5230\u5ba2\u6237\u7aef\u5f02\u5e38");
            return resultDTO;
        }
        finally {
            ossClient.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResultDTO<CompleteMultipartUploadResultDTO> uploadByBreakpointsContinuedTransmission(ThirdStorageFileUploadDTO thirdStorageFileUploadDTO, String uploadFilePath) {
        ResultDTO<Boolean> booleanResultDTO = ThirdStorageFileUtil.checkFileUploadDTO(thirdStorageFileUploadDTO);
        if (!booleanResultDTO.isSuccess()) {
            return ResultDTO.fail((String)booleanResultDTO.getDescription());
        }
        if (StringUtils.isBlank((String)uploadFilePath)) {
            return ResultDTO.fail((String)"uploadFilePath is not null");
        }
        ThirdStorageFileBaseDTO fileBaseDTO = thirdStorageFileUploadDTO.getThirdStorageFileBaseDTO();
        OSSClient ossClient = OSSClientUtil.createOssClient(fileBaseDTO.getEndpoint());
        UploadFileRequest uploadFileRequest = new UploadFileRequest(fileBaseDTO.getBucketName(), fileBaseDTO.getFileName());
        uploadFileRequest.setUploadFile(uploadFilePath);
        uploadFileRequest.setTaskNum(StorageProperties.getInstance().getOss_taskNum());
        uploadFileRequest.setPartSize(StorageProperties.getInstance().getOss_partSize());
        uploadFileRequest.setEnableCheckpoint(true);
        ObjectMetadata objectMetadata = ThirdStorageFileUtil.getObjectMetadata(thirdStorageFileUploadDTO);
        uploadFileRequest.setObjectMetadata(objectMetadata);
        try {
            UploadFileResult uploadFileResult = ossClient.uploadFile(uploadFileRequest);
            CompleteMultipartUploadResult completeMultipartUploadResult = uploadFileResult.getMultipartUploadResult();
            log.info("completeMultipartUploadResult\uff1a{}", (Object)JSON.toJSONString((Object)completeMultipartUploadResult, (boolean)true));
            CompleteMultipartUploadResultDTO completeMultipartUploadResultDTO = (CompleteMultipartUploadResultDTO)CompleteMultipartUploadResult2DTOTransformer.INSTANCE.apply(completeMultipartUploadResult);
            log.info("completeMultipartUploadResultDTO:{}", (Object)JSON.toJSONString((Object)completeMultipartUploadResultDTO, (boolean)true));
            ResultDTO resultDTO = ResultDTO.successfy((Object)completeMultipartUploadResultDTO);
            return resultDTO;
        }
        catch (Throwable throwable) {
            log.error("\u65ad\u70b9\u7eed\u4f20-\u4e0a\u4f20-\u9047\u5230\u5f02\u5e38", throwable);
            ResultDTO resultDTO = ResultDTO.fail((String)"\u65ad\u70b9\u7eed\u4f20-\u4e0a\u4f20-\u9047\u5230\u5f02\u5e38");
            return resultDTO;
        }
        finally {
            ossClient.shutdown();
        }
    }

    private static ObjectMetadata getObjectMetadata(ThirdStorageFileUploadDTO thirdStorageFileUploadDTO) {
        Map<String, String> userMetadataMap;
        if (thirdStorageFileUploadDTO.getMetadataDTO() == null) {
            return null;
        }
        Map<String, Object> metadataMap = thirdStorageFileUploadDTO.getMetadataDTO().getMetadataMap();
        ObjectMetadata objectMetadata = new ObjectMetadata();
        if (MapUtils.isNotEmpty(metadataMap)) {
            for (String key : metadataMap.keySet()) {
                objectMetadata.setHeader(key, metadataMap.get(key));
            }
        }
        if (MapUtils.isNotEmpty(userMetadataMap = thirdStorageFileUploadDTO.getMetadataDTO().getUserMetadataMap())) {
            objectMetadata.setUserMetadata(userMetadataMap);
        }
        return objectMetadata;
    }

    private static ResultDTO<Boolean> checkFileUploadDTO(ThirdStorageFileUploadDTO thirdStorageFileUploadDTO) {
        if (thirdStorageFileUploadDTO == null) {
            return ResultDTO.fail((String)"fileUploadBaseInfoDTO is not null");
        }
        ResultDTO<Boolean> booleanResultDTO = ThirdStorageFileUtil.checkFileBaseDTO(thirdStorageFileUploadDTO.getThirdStorageFileBaseDTO());
        if (!booleanResultDTO.isSuccess()) {
            return booleanResultDTO;
        }
        return ResultDTO.successfy((Object)true);
    }

    private static ResultDTO<Boolean> checkFileBaseDTO(ThirdStorageFileBaseDTO thirdStorageFileBaseDTO) {
        if (thirdStorageFileBaseDTO == null) {
            return ResultDTO.fail((String)"thirdStorageFileBaseDTO is not null");
        }
        if (StringUtils.isBlank((String)thirdStorageFileBaseDTO.getBucketName())) {
            return ResultDTO.fail((String)"bucketName is not null");
        }
        if (StringUtils.isBlank((String)thirdStorageFileBaseDTO.getFileName())) {
            return ResultDTO.fail((String)"fileName is not null");
        }
        String fileName = thirdStorageFileBaseDTO.getFileName();
        String firstString = fileName.substring(0, 1);
        if ("/".equals(firstString) || "\\".equals(firstString)) {
            return ResultDTO.fail((String)"\u4e0d\u80fd\u4ee5'/'\u6216\u8005''\u5b57\u7b26\u5f00\u5934");
        }
        if (fileName.length() >= 1023) {
            return ResultDTO.fail((String)"1 <= fileName.length < 1023");
        }
        return ResultDTO.successfy((Object)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResultDTO<MetadataDTO> simpleDownloadToFile(ThirdStorageFileBaseDTO thirdStorageFileBaseDTO, String downloadSaveFilePath) {
        ResultDTO<Boolean> booleanResultDTO = ThirdStorageFileUtil.checkFileBaseDTO(thirdStorageFileBaseDTO);
        if (!booleanResultDTO.isSuccess()) {
            return ResultDTO.fail((String)booleanResultDTO.getDescription());
        }
        if (StringUtils.isBlank((String)downloadSaveFilePath)) {
            return ResultDTO.fail((String)"input filePath is null");
        }
        OSSClient ossClient = OSSClientUtil.createOssClient(thirdStorageFileBaseDTO.getEndpoint());
        try {
            ObjectMetadata objectMetadata = ossClient.getObject(new GetObjectRequest(thirdStorageFileBaseDTO.getBucketName(), thirdStorageFileBaseDTO.getFileName()), new File(downloadSaveFilePath));
            MetadataDTO metadataDTO = (MetadataDTO)ObjectMetadata2MetadataDTOTransformer.INSTANCE.apply(objectMetadata);
            log.info("metadataDTO:{}", (Object)JSON.toJSONString((Object)metadataDTO, (boolean)true));
            ResultDTO resultDTO = ResultDTO.successfy((Object)metadataDTO);
            return resultDTO;
        }
        catch (OSSException ossException) {
            log.error("\u4e0a\u4f20\u6587\u4ef6\u9047\u5230OSSException\u5f02\u5e38", (Throwable)ossException);
            ResultDTO resultDTO = ResultDTO.fail((String)("\u4e0a\u4f20\u6587\u4ef6\u9047\u5230\u5f02\u5e38:" + ossException.getMessage()));
            return resultDTO;
        }
        catch (ClientException e) {
            log.error("\u4e0a\u4f20\u6587\u4ef6\u9047\u5230ClientException\u5f02\u5e38", (Throwable)e);
            ResultDTO resultDTO = ResultDTO.fail((String)"\u4e0a\u4f20\u6587\u4ef6\u9047\u5230\u5ba2\u6237\u7aef\u5f02\u5e38");
            return resultDTO;
        }
        finally {
            ossClient.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResultDTO<ThirdStorageDownloadFileResultDTO> downloadByBreakpointsContinuedTransmission(ThirdStorageFileBaseDTO thirdStorageFileBaseDTO, String downloadSaveFilePath) {
        ResultDTO<Boolean> booleanResultDTO = ThirdStorageFileUtil.checkFileBaseDTO(thirdStorageFileBaseDTO);
        if (!booleanResultDTO.isSuccess()) {
            return ResultDTO.fail((String)booleanResultDTO.getDescription());
        }
        if (StringUtils.isBlank((String)downloadSaveFilePath)) {
            return ResultDTO.fail((String)"downloadFilePath is not null");
        }
        OSSClient ossClient = OSSClientUtil.createOssClient(thirdStorageFileBaseDTO.getEndpoint());
        DownloadFileRequest downloadFileRequest = new DownloadFileRequest(thirdStorageFileBaseDTO.getBucketName(), thirdStorageFileBaseDTO.getFileName());
        downloadFileRequest.setDownloadFile(downloadSaveFilePath);
        downloadFileRequest.setTaskNum(StorageProperties.getInstance().getOss_taskNum());
        downloadFileRequest.setPartSize(StorageProperties.getInstance().getOss_partSize());
        downloadFileRequest.setEnableCheckpoint(true);
        try {
            ThirdStorageDownloadFileResultDTO thirdStorageDownloadFileResultDTO = (ThirdStorageDownloadFileResultDTO)DownloadFileResult2DTOTransformer.INSTANCE.apply(ossClient.downloadFile(downloadFileRequest));
            log.info("thirdStorageDownloadFileResultDTO:{}", (Object)JSON.toJSONString((Object)thirdStorageDownloadFileResultDTO, (boolean)true));
            ResultDTO resultDTO = ResultDTO.successfy((Object)thirdStorageDownloadFileResultDTO);
            return resultDTO;
        }
        catch (Throwable throwable) {
            log.error("\u65ad\u70b9\u7eed\u4f20-\u4e0b\u8f7d-\u9047\u5230\u5f02\u5e38", throwable);
            ResultDTO resultDTO = ResultDTO.fail((String)"\u65ad\u70b9\u7eed\u4f20-\u4e0b\u8f7d-\u9047\u5230\u5f02\u5e38");
            return resultDTO;
        }
        finally {
            ossClient.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResultDTO<List<String>> deleteFiles(ThirdStorageFileDeleteDTO thirdStorageFileDeleteDTO) {
        ResultDTO resultDTO;
        ResultDTO<Boolean> booleanResultDTO = ThirdStorageFileUtil.checkFileDeleteDTO(thirdStorageFileDeleteDTO);
        if (!booleanResultDTO.isSuccess()) {
            return ResultDTO.fail((String)booleanResultDTO.getDescription());
        }
        OSSClient ossClient = OSSClientUtil.createOssClient(thirdStorageFileDeleteDTO.getEndpoint());
        DeleteObjectsRequest deleteObjectsRequest = new DeleteObjectsRequest(thirdStorageFileDeleteDTO.getBucketName()).withKeys(thirdStorageFileDeleteDTO.getFileNameList());
        deleteObjectsRequest.setQuiet(false);
        try {
            log.info("\u5f85\u5220\u9664\u7684\u4e91\u5b58\u50a8\u6587\u4ef6:{}", (Object)deleteObjectsRequest.getKeys());
            DeleteObjectsResult deleteObjectsResult = ossClient.deleteObjects(deleteObjectsRequest);
            List deletedObjects = deleteObjectsResult.getDeletedObjects();
            log.info("\u6210\u529f\u5220\u9664\u4e91\u5b58\u50a8\u6587\u4ef6:{}", (Object)deletedObjects);
            if (CollectionUtils.isEmpty((Collection)deletedObjects)) {
                ResultDTO resultDTO2 = ResultDTO.fail((String)"\u5168\u90e8\u6587\u4ef6\u5220\u9664\u5931\u8d25");
                return resultDTO2;
            }
            ResultDTO resultDTO3 = ResultDTO.successfy((Object)deletedObjects);
            return resultDTO3;
        }
        catch (OSSException ossException) {
            log.error("\u5220\u9664\u6587\u4ef6\u9047\u5230OSSException\u5f02\u5e38", (Throwable)ossException);
            resultDTO = ResultDTO.fail((String)("\u5220\u9664\u6587\u4ef6\u9047\u5230\u5f02\u5e38:" + ossException.getMessage()));
            return resultDTO;
        }
        catch (ClientException e) {
            log.error("\u5220\u9664\u6587\u4ef6\u9047\u5230ClientException\u5f02\u5e38", (Throwable)e);
            resultDTO = ResultDTO.fail((String)"\u5220\u9664\u6587\u4ef6\u9047\u5230\u5ba2\u6237\u7aef\u5f02\u5e38");
            return resultDTO;
        }
        finally {
            ossClient.shutdown();
        }
    }

    private static ResultDTO<Boolean> checkFileDeleteDTO(ThirdStorageFileDeleteDTO thirdStorageFileDeleteDTO) {
        if (thirdStorageFileDeleteDTO == null) {
            return ResultDTO.fail((String)"fileDeleteDTO is not null");
        }
        if (StringUtils.isBlank((String)thirdStorageFileDeleteDTO.getBucketName())) {
            return ResultDTO.fail((String)"bucketName is not null");
        }
        if (CollectionUtils.isEmpty(thirdStorageFileDeleteDTO.getFileNameList())) {
            return ResultDTO.fail((String)"fileNameList is not empty");
        }
        if (thirdStorageFileDeleteDTO.getFileNameList().size() > 1000) {
            return ResultDTO.fail((String)"fileNameLise size <=1000 ");
        }
        return ResultDTO.successfy((Object)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResultDTO<Boolean> isExistFile(ThirdStorageFileBaseDTO thirdStorageFileBaseDTO) {
        ResultDTO<Boolean> booleanResultDTO = ThirdStorageFileUtil.checkFileBaseDTO(thirdStorageFileBaseDTO);
        if (!booleanResultDTO.isSuccess()) {
            return booleanResultDTO;
        }
        OSSClient ossClient = OSSClientUtil.createOssClient(thirdStorageFileBaseDTO.getEndpoint());
        try {
            boolean isExist = ossClient.doesObjectExist(thirdStorageFileBaseDTO.getBucketName(), thirdStorageFileBaseDTO.getFileName());
            ResultDTO resultDTO = ResultDTO.successfy((Object)isExist);
            return resultDTO;
        }
        catch (OSSException ossException) {
            log.error("\u786e\u5b9a\u6587\u4ef6\u662f\u5426\u5b58\u5728\u9047\u5230OSSException\u5f02\u5e38", (Throwable)ossException);
            ResultDTO resultDTO = ResultDTO.fail((String)("\u786e\u5b9a\u6587\u4ef6\u662f\u5426\u5b58\u5728\u9047\u5230\u5f02\u5e38:" + ossException.getMessage()));
            return resultDTO;
        }
        catch (ClientException e) {
            log.error("\u786e\u5b9a\u6587\u4ef6\u662f\u5426\u5b58\u5728\u9047\u5230ClientException\u5f02\u5e38", (Throwable)e);
            ResultDTO resultDTO = ResultDTO.fail((String)"\u786e\u5b9a\u6587\u4ef6\u662f\u5426\u5b58\u5728\u9047\u5230\u5ba2\u6237\u7aef\u5f02\u5e38");
            return resultDTO;
        }
        finally {
            ossClient.shutdown();
        }
    }
}

