package com.chinamcloud.common.storage.transformer;

import com.aliyun.oss.model.ObjectMetadata;
import com.chinamcloud.common.guava2.SafeFunction;
import com.chinamcloud.common.storage.dto.MetadataDTO;

/**
 * Created with IntelliJ IDEA.
 * User: chenzhiwei
 * Date: 17/1/11
 * Time: 上午10:34
 */
public final class ObjectMetadata2MetadataDTOTransformer extends SafeFunction<ObjectMetadata, MetadataDTO> {

    public static final ObjectMetadata2MetadataDTOTransformer INSTANCE = new ObjectMetadata2MetadataDTOTransformer();

    @Override
    protected MetadataDTO safeApply(ObjectMetadata input) {
        MetadataDTO output = new MetadataDTO();
        output.setMetadataMap(input.getRawMetadata());
        output.setUserMetadataMap(input.getUserMetadata());
        return output;
    }

    private ObjectMetadata2MetadataDTOTransformer() {
    }
}