package com.chinamcloud.common.storage.util;

/**
 * Created with IntelliJ IDEA.
 * User: chenzhiwei
 * Date: 17/2/16
 * Time: 下午1:31
 */
public class PathUtil {

    public static String builderPath(String... args) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < args.length; i++) {
            String backPart = args[i];
            if (i == 0) {
                stringBuilder.append(backPart);
                continue;
            }
            String frontPart = stringBuilder.toString();
            if (frontPart.endsWith("/") && !backPart.startsWith("/")) {
                stringBuilder.append(backPart);
            } else if (frontPart.endsWith("/") && backPart.startsWith("/")) {
                stringBuilder.append(backPart.substring(1));
            }
            if (!frontPart.endsWith("/") && !backPart.startsWith("/")) {
                stringBuilder.append("/").append(backPart);
            } else if (!frontPart.endsWith("/") && backPart.startsWith("/")) {
                stringBuilder.append(backPart);
            }
        }
        return stringBuilder.toString();
    }

    /**
     * 拼接路径：以/为结尾,无参返回/
     * @param args
     * @return
     */
    public static String builderPathEndSlash(String... args) {
        StringBuilder stringBuilder = new StringBuilder(builderPath(args));
        if(!stringBuilder.toString().endsWith("/")){
            stringBuilder.append("/");
        }
        return stringBuilder.toString();
    }

}
