/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.common.storage.util;

import com.alibaba.fastjson.JSON;
import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.model.CompleteMultipartUploadResult;
import com.aliyun.oss.model.DeleteObjectsRequest;
import com.aliyun.oss.model.DeleteObjectsResult;
import com.aliyun.oss.model.DownloadFileRequest;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.ListObjectsRequest;
import com.aliyun.oss.model.OSSObjectSummary;
import com.aliyun.oss.model.ObjectListing;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PutObjectRequest;
import com.aliyun.oss.model.PutObjectResult;
import com.aliyun.oss.model.UploadFileRequest;
import com.aliyun.oss.model.UploadFileResult;
import com.chinamcloud.common.result.ResultDTO;
import com.chinamcloud.common.storage.dto.CompleteMultipartUploadResultDTO;
import com.chinamcloud.common.storage.dto.MetadataDTO;
import com.chinamcloud.common.storage.dto.ThirdDirectoryDTO;
import com.chinamcloud.common.storage.dto.ThirdStorageDownloadFileResultDTO;
import com.chinamcloud.common.storage.dto.ThirdStorageFileBaseDTO;
import com.chinamcloud.common.storage.dto.ThirdStorageFileDeleteDTO;
import com.chinamcloud.common.storage.dto.ThirdStorageFileUploadDTO;
import com.chinamcloud.common.storage.dto.ThirdStorageRecursionFileUploadDTO;
import com.chinamcloud.common.storage.dto.ThirdStorageSimpleUploadResultDTO;
import com.chinamcloud.common.storage.dto.ThirdStorageUploadFilePathDTO;
import com.chinamcloud.common.storage.exception.FileStorageException;
import com.chinamcloud.common.storage.exception.ThirdStorageClientException;
import com.chinamcloud.common.storage.properties.StorageProperties;
import com.chinamcloud.common.storage.transformer.CompleteMultipartUploadResult2DTOTransformer;
import com.chinamcloud.common.storage.transformer.DownloadFileResult2DTOTransformer;
import com.chinamcloud.common.storage.transformer.ObjectMetadata2MetadataDTOTransformer;
import com.chinamcloud.common.storage.transformer.PutObjectResult2SimpleUploadResultDTOTransformer;
import com.chinamcloud.common.storage.util.OSSClientUtil;
import com.chinamcloud.common.storage.util.PathUtil;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThirdStorageFileUtil {
    private static final Logger log = LoggerFactory.getLogger(ThirdStorageFileUtil.class);
    private static final String DELIMITER = "/";

    public static ResultDTO<ThirdStorageSimpleUploadResultDTO> simpleUploadByInputStream(ThirdStorageFileUploadDTO thirdStorageFileUploadDTO, InputStream inputStream) throws FileStorageException, ThirdStorageClientException {
        ResultDTO<Boolean> booleanResultDTO = ThirdStorageFileUtil.checkFileUploadDTO(thirdStorageFileUploadDTO);
        if (!booleanResultDTO.isSuccess()) {
            return ResultDTO.fail((String)booleanResultDTO.getDescription());
        }
        if (inputStream == null) {
            return ResultDTO.fail((String)"input inputStream is not null");
        }
        ThirdStorageFileBaseDTO fileBaseDTO = thirdStorageFileUploadDTO.getThirdStorageFileBaseDTO();
        OSSClient ossClient = OSSClientUtil.createOssClient(fileBaseDTO.getEndpoint());
        ObjectMetadata objectMetadata = ThirdStorageFileUtil.getObjectMetadata(thirdStorageFileUploadDTO);
        PutObjectRequest putObjectRequest = new PutObjectRequest(fileBaseDTO.getBucketName(), fileBaseDTO.getFileName(), inputStream, objectMetadata);
        try {
            PutObjectResult putObjectResult = ossClient.putObject(putObjectRequest);
            log.info("putObjectResult:{}", (Object)JSON.toJSONString((Object)putObjectResult, (boolean)true));
            ThirdStorageSimpleUploadResultDTO thirdStorageSimpleUploadResultDTO = ThirdStorageFileUtil.builderSimpleUploadResultDTO(fileBaseDTO, putObjectResult);
            log.info("thirdStorageSimpleUploadResultDTO:{}", (Object)JSON.toJSONString((Object)thirdStorageSimpleUploadResultDTO, (boolean)true));
            ResultDTO resultDTO = ResultDTO.successfy((Object)thirdStorageSimpleUploadResultDTO);
            return resultDTO;
        }
        catch (OSSException ossException) {
            log.error("\u4e0a\u4f20\u6587\u4ef6\u9047\u5230OSSException\u5f02\u5e38", (Throwable)ossException);
            throw new FileStorageException("\u4e0a\u4f20oss\u9047\u5230\u5f02\u5e38");
        }
        catch (ClientException e) {
            log.error("\u4e0a\u4f20\u6587\u4ef6\u9047\u5230ClientException\u5f02\u5e38", (Throwable)e);
            throw new ThirdStorageClientException("\u4e0a\u4f20oss\u9047\u5230\u5f02\u5e38");
        }
        finally {
            ossClient.shutdown();
        }
    }

    private static ThirdStorageSimpleUploadResultDTO builderSimpleUploadResultDTO(ThirdStorageFileBaseDTO thirdStorageFileBaseDTO, PutObjectResult putObjectResult) {
        ThirdStorageSimpleUploadResultDTO thirdStorageSimpleUploadResultDTO = (ThirdStorageSimpleUploadResultDTO)PutObjectResult2SimpleUploadResultDTOTransformer.INSTANCE.apply(putObjectResult);
        String location = ThirdStorageFileUtil.builderLocation(thirdStorageFileBaseDTO);
        thirdStorageSimpleUploadResultDTO.setLocation(location);
        return thirdStorageSimpleUploadResultDTO;
    }

    private static String builderLocation(ThirdStorageFileBaseDTO thirdStorageFileBaseDTO) {
        StringBuilder stringBuilder = new StringBuilder();
        String endPoint = (String)MoreObjects.firstNonNull((Object)thirdStorageFileBaseDTO.getEndpoint(), (Object)StorageProperties.getInstance().getOss_default_endpoint());
        endPoint = endPoint.replace("://", "://" + thirdStorageFileBaseDTO.getBucketName() + ".");
        stringBuilder.append(endPoint);
        stringBuilder.append(DELIMITER);
        stringBuilder.append(thirdStorageFileBaseDTO.getFileName());
        return stringBuilder.toString();
    }

    public static ResultDTO<ThirdStorageSimpleUploadResultDTO> simpleUploadByFilePath(ThirdStorageFileUploadDTO thirdStorageFileUploadDTO, String uploadFilePath) throws FileStorageException, ThirdStorageClientException {
        ResultDTO<Boolean> booleanResultDTO = ThirdStorageFileUtil.checkFileUploadDTO(thirdStorageFileUploadDTO);
        if (!booleanResultDTO.isSuccess()) {
            return ResultDTO.fail((String)booleanResultDTO.getDescription());
        }
        if (StringUtils.isBlank((String)uploadFilePath)) {
            return ResultDTO.fail((String)"input filePath is not null");
        }
        File file = new File(uploadFilePath);
        if (!file.exists()) {
            log.error("\u4e0a\u4f20oss\u7684\u6587\u4ef6\u4e0d\u5b58\u5728:{},{}", (Object)thirdStorageFileUploadDTO, (Object)uploadFilePath);
            return ResultDTO.fail((String)"\u4e0a\u4f20oss\u7684\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        ThirdStorageFileBaseDTO fileBaseDTO = thirdStorageFileUploadDTO.getThirdStorageFileBaseDTO();
        OSSClient ossClient = OSSClientUtil.createOssClient(fileBaseDTO.getEndpoint());
        ObjectMetadata objectMetadata = ThirdStorageFileUtil.getObjectMetadata(thirdStorageFileUploadDTO);
        PutObjectRequest putObjectRequest = new PutObjectRequest(fileBaseDTO.getBucketName(), fileBaseDTO.getFileName(), file, objectMetadata);
        try {
            PutObjectResult putObjectResult = ossClient.putObject(putObjectRequest);
            log.info("putObjectResult:{}", (Object)JSON.toJSONString((Object)putObjectResult, (boolean)true));
            ThirdStorageSimpleUploadResultDTO thirdStorageSimpleUploadResultDTO = ThirdStorageFileUtil.builderSimpleUploadResultDTO(fileBaseDTO, putObjectResult);
            log.info("thirdStorageSimpleUploadResultDTO:{}", (Object)JSON.toJSONString((Object)thirdStorageSimpleUploadResultDTO, (boolean)true));
            ResultDTO resultDTO = ResultDTO.successfy((Object)thirdStorageSimpleUploadResultDTO);
            return resultDTO;
        }
        catch (OSSException ossException) {
            log.error("\u4e0a\u4f20\u6587\u4ef6\u9047\u5230OSSException\u5f02\u5e38", (Throwable)ossException);
            throw new FileStorageException("\u4e0a\u4f20oss\u9047\u5230\u5f02\u5e38");
        }
        catch (ClientException e) {
            log.error("\u4e0a\u4f20\u6587\u4ef6\u9047\u5230ClientException\u5f02\u5e38", (Throwable)e);
            throw new ThirdStorageClientException("\u4e0a\u4f20oss\u9047\u5230\u5f02\u5e38");
        }
        finally {
            ossClient.shutdown();
        }
    }

    public static ResultDTO<List<ThirdStorageSimpleUploadResultDTO>> recursionSimpleUploadByFilePath(ThirdStorageRecursionFileUploadDTO thirdStorageRecursionFileUploadDTO) throws FileStorageException {
        log.info("thirdStorageRecursionFileUploadDTO:{}", (Object)thirdStorageRecursionFileUploadDTO);
        ResultDTO<Boolean> booleanResultDTO = ThirdStorageFileUtil.checkThirdStorageRecursiveFileUploadDTO(thirdStorageRecursionFileUploadDTO);
        if (!booleanResultDTO.isSuccess()) {
            return ResultDTO.fail((String)booleanResultDTO.getDescription());
        }
        ArrayList thirdStorageSimpleUploadResultDTOList = Lists.newArrayList();
        for (ThirdStorageUploadFilePathDTO thirdStorageUploadFilePathDTO : thirdStorageRecursionFileUploadDTO.getThirdStorageUploadFilePathDTOList()) {
            File file = new File(thirdStorageUploadFilePathDTO.getUploadFilePath());
            ThirdStorageFileUtil.recursionUploadFile(thirdStorageRecursionFileUploadDTO, thirdStorageSimpleUploadResultDTOList, thirdStorageUploadFilePathDTO, file);
        }
        return ResultDTO.successfy((Object)thirdStorageSimpleUploadResultDTOList);
    }

    private static void recursionUploadFile(ThirdStorageRecursionFileUploadDTO thirdStorageRecursionFileUploadDTO, List<ThirdStorageSimpleUploadResultDTO> thirdStorageSimpleUploadResultDTOList, ThirdStorageUploadFilePathDTO thirdStorageUploadFilePathDTO, File parentFile) {
        if (parentFile.isDirectory()) {
            File[] files;
            for (File file : files = parentFile.listFiles()) {
                if (file.isDirectory()) {
                    ThirdStorageFileUtil.recursionUploadFile(thirdStorageRecursionFileUploadDTO, thirdStorageSimpleUploadResultDTOList, thirdStorageUploadFilePathDTO, file);
                    continue;
                }
                ThirdStorageFileUtil.uploadFile(thirdStorageRecursionFileUploadDTO, thirdStorageSimpleUploadResultDTOList, thirdStorageUploadFilePathDTO, file);
            }
        } else {
            ThirdStorageFileUtil.uploadFile(thirdStorageRecursionFileUploadDTO, thirdStorageSimpleUploadResultDTOList, thirdStorageUploadFilePathDTO, parentFile);
        }
    }

    private static void uploadFile(ThirdStorageRecursionFileUploadDTO thirdStorageRecursionFileUploadDTO, List<ThirdStorageSimpleUploadResultDTO> thirdStorageSimpleUploadResultDTOList, ThirdStorageUploadFilePathDTO thirdStorageUploadFilePathDTO, File file) {
        ThirdStorageFileUploadDTO thirdStorageFileUploadDTO = new ThirdStorageFileUploadDTO();
        ThirdStorageFileBaseDTO thirdStorageFileBaseDTO = new ThirdStorageFileBaseDTO();
        thirdStorageFileBaseDTO.setEndpoint(thirdStorageRecursionFileUploadDTO.getEndpoint());
        thirdStorageFileBaseDTO.setBucketName(thirdStorageRecursionFileUploadDTO.getBucketName());
        String ossFileName = ThirdStorageFileUtil.getOssFileName(thirdStorageUploadFilePathDTO, file);
        thirdStorageFileBaseDTO.setFileName(ossFileName);
        thirdStorageFileUploadDTO.setThirdStorageFileBaseDTO(thirdStorageFileBaseDTO);
        ResultDTO<ThirdStorageSimpleUploadResultDTO> thirdStorageSimpleUploadResultDTOResultDTO = ThirdStorageFileUtil.simpleUploadByFilePath(thirdStorageFileUploadDTO, file.getAbsolutePath());
        if (thirdStorageSimpleUploadResultDTOResultDTO.isSuccess()) {
            thirdStorageSimpleUploadResultDTOList.add((ThirdStorageSimpleUploadResultDTO)thirdStorageSimpleUploadResultDTOResultDTO.getData());
        }
    }

    private static String getOssFileName(ThirdStorageUploadFilePathDTO thirdStorageUploadFilePathDTO, File file) {
        String ossFileName = file.getAbsolutePath().replace(thirdStorageUploadFilePathDTO.getUploadFilePath(), "");
        String reservedUploadPath = thirdStorageUploadFilePathDTO.getReservedUploadPath();
        if (StringUtils.isNotBlank((String)reservedUploadPath)) {
            ossFileName = PathUtil.builderPath(reservedUploadPath, ossFileName);
        }
        if (ossFileName.startsWith(DELIMITER)) {
            ossFileName = ossFileName.substring(1);
        }
        return ossFileName;
    }

    private static ResultDTO<Boolean> checkThirdStorageRecursiveFileUploadDTO(ThirdStorageRecursionFileUploadDTO thirdStorageRecursionFileUploadDTO) {
        if (thirdStorageRecursionFileUploadDTO == null) {
            return ResultDTO.fail((String)"thirdStorageRecursionFileUploadDTO is not null");
        }
        if (StringUtils.isBlank((String)thirdStorageRecursionFileUploadDTO.getBucketName())) {
            return ResultDTO.fail((String)"bucketName is not null");
        }
        if (CollectionUtils.isEmpty(thirdStorageRecursionFileUploadDTO.getThirdStorageUploadFilePathDTOList())) {
            return ResultDTO.fail((String)"thirdStorageUploadFilePathDTOList is not null");
        }
        return ResultDTO.successfy((Object)true);
    }

    public static ResultDTO<CompleteMultipartUploadResultDTO> uploadByBreakpointsContinuedTransmission(ThirdStorageFileUploadDTO thirdStorageFileUploadDTO, String uploadFilePath) throws FileStorageException {
        ResultDTO<Boolean> booleanResultDTO = ThirdStorageFileUtil.checkFileUploadDTO(thirdStorageFileUploadDTO);
        if (!booleanResultDTO.isSuccess()) {
            return ResultDTO.fail((String)booleanResultDTO.getDescription());
        }
        if (StringUtils.isBlank((String)uploadFilePath)) {
            return ResultDTO.fail((String)"uploadFilePath is not null");
        }
        ThirdStorageFileBaseDTO fileBaseDTO = thirdStorageFileUploadDTO.getThirdStorageFileBaseDTO();
        OSSClient ossClient = OSSClientUtil.createOssClient(fileBaseDTO.getEndpoint());
        UploadFileRequest uploadFileRequest = new UploadFileRequest(fileBaseDTO.getBucketName(), fileBaseDTO.getFileName());
        uploadFileRequest.setUploadFile(uploadFilePath);
        uploadFileRequest.setTaskNum(StorageProperties.getInstance().getOss_taskNum());
        uploadFileRequest.setPartSize(StorageProperties.getInstance().getOss_partSize());
        uploadFileRequest.setEnableCheckpoint(true);
        ObjectMetadata objectMetadata = ThirdStorageFileUtil.getObjectMetadata(thirdStorageFileUploadDTO);
        uploadFileRequest.setObjectMetadata(objectMetadata);
        try {
            UploadFileResult uploadFileResult = ossClient.uploadFile(uploadFileRequest);
            CompleteMultipartUploadResult completeMultipartUploadResult = uploadFileResult.getMultipartUploadResult();
            log.info("completeMultipartUploadResult\uff1a{}", (Object)JSON.toJSONString((Object)completeMultipartUploadResult, (boolean)true));
            CompleteMultipartUploadResultDTO completeMultipartUploadResultDTO = (CompleteMultipartUploadResultDTO)CompleteMultipartUploadResult2DTOTransformer.INSTANCE.apply(completeMultipartUploadResult);
            log.info("completeMultipartUploadResultDTO:{}", (Object)JSON.toJSONString((Object)completeMultipartUploadResultDTO, (boolean)true));
            ResultDTO resultDTO = ResultDTO.successfy((Object)completeMultipartUploadResultDTO);
            return resultDTO;
        }
        catch (Throwable throwable) {
            log.error("\u65ad\u70b9\u7eed\u4f20-\u4e0a\u4f20-\u9047\u5230\u5f02\u5e38", throwable);
            throw new FileStorageException("\u4e0a\u4f20oss\u9047\u5230\u5f02\u5e38");
        }
        finally {
            ossClient.shutdown();
        }
    }

    private static ObjectMetadata getObjectMetadata(ThirdStorageFileUploadDTO thirdStorageFileUploadDTO) {
        Map<String, String> userMetadataMap;
        if (thirdStorageFileUploadDTO.getMetadataDTO() == null) {
            return null;
        }
        Map<String, Object> metadataMap = thirdStorageFileUploadDTO.getMetadataDTO().getMetadataMap();
        ObjectMetadata objectMetadata = new ObjectMetadata();
        if (MapUtils.isNotEmpty(metadataMap)) {
            for (String key : metadataMap.keySet()) {
                objectMetadata.setHeader(key, metadataMap.get(key));
            }
        }
        if (MapUtils.isNotEmpty(userMetadataMap = thirdStorageFileUploadDTO.getMetadataDTO().getUserMetadataMap())) {
            objectMetadata.setUserMetadata(userMetadataMap);
        }
        return objectMetadata;
    }

    private static ResultDTO<Boolean> checkFileUploadDTO(ThirdStorageFileUploadDTO thirdStorageFileUploadDTO) {
        if (thirdStorageFileUploadDTO == null) {
            return ResultDTO.fail((String)"fileUploadBaseInfoDTO is not null");
        }
        ResultDTO<Boolean> booleanResultDTO = ThirdStorageFileUtil.checkFileBaseDTO(thirdStorageFileUploadDTO.getThirdStorageFileBaseDTO());
        if (!booleanResultDTO.isSuccess()) {
            return booleanResultDTO;
        }
        return ResultDTO.successfy((Object)true);
    }

    private static ResultDTO<Boolean> checkFileBaseDTO(ThirdStorageFileBaseDTO thirdStorageFileBaseDTO) {
        if (thirdStorageFileBaseDTO == null) {
            return ResultDTO.fail((String)"thirdStorageFileBaseDTO is not null");
        }
        if (StringUtils.isBlank((String)thirdStorageFileBaseDTO.getBucketName())) {
            return ResultDTO.fail((String)"bucketName is not null");
        }
        if (StringUtils.isBlank((String)thirdStorageFileBaseDTO.getFileName())) {
            return ResultDTO.fail((String)"fileName is not null");
        }
        String fileName = thirdStorageFileBaseDTO.getFileName();
        String firstString = fileName.substring(0, 1);
        if (DELIMITER.equals(firstString) || "\\".equals(firstString)) {
            return ResultDTO.fail((String)"\u4e0d\u80fd\u4ee5'/'\u6216\u8005''\u5b57\u7b26\u5f00\u5934");
        }
        if (fileName.length() >= 1023) {
            return ResultDTO.fail((String)"1 <= fileName.length < 1023");
        }
        return ResultDTO.successfy((Object)true);
    }

    public static ResultDTO<MetadataDTO> simpleDownloadToFile(ThirdStorageFileBaseDTO thirdStorageFileBaseDTO, String downloadSaveFilePath) throws FileStorageException, ThirdStorageClientException {
        ResultDTO<Boolean> booleanResultDTO = ThirdStorageFileUtil.checkFileBaseDTO(thirdStorageFileBaseDTO);
        if (!booleanResultDTO.isSuccess()) {
            return ResultDTO.fail((String)booleanResultDTO.getDescription());
        }
        if (StringUtils.isBlank((String)downloadSaveFilePath)) {
            return ResultDTO.fail((String)"input filePath is null");
        }
        OSSClient ossClient = OSSClientUtil.createOssClient(thirdStorageFileBaseDTO.getEndpoint());
        try {
            ObjectMetadata objectMetadata = ossClient.getObject(new GetObjectRequest(thirdStorageFileBaseDTO.getBucketName(), thirdStorageFileBaseDTO.getFileName()), new File(downloadSaveFilePath));
            MetadataDTO metadataDTO = (MetadataDTO)ObjectMetadata2MetadataDTOTransformer.INSTANCE.apply(objectMetadata);
            log.info("metadataDTO:{}", (Object)JSON.toJSONString((Object)metadataDTO, (boolean)true));
            ResultDTO resultDTO = ResultDTO.successfy((Object)metadataDTO);
            return resultDTO;
        }
        catch (OSSException ossException) {
            log.error("\u4e0b\u8f7d\u6587\u4ef6\u9047\u5230OSSException\u5f02\u5e38", (Throwable)ossException);
            throw new FileStorageException("oss\u4e0b\u8f7d\u9047\u5230\u5f02\u5e38");
        }
        catch (ClientException e) {
            log.error("\u4e0b\u8f7d\u6587\u4ef6\u9047\u5230ClientException\u5f02\u5e38", (Throwable)e);
            throw new ThirdStorageClientException("oss\u4e0b\u8f7d\u9047\u5230\u5f02\u5e38");
        }
        finally {
            ossClient.shutdown();
        }
    }

    public static ResultDTO<ThirdStorageDownloadFileResultDTO> downloadByBreakpointsContinuedTransmission(ThirdStorageFileBaseDTO thirdStorageFileBaseDTO, String downloadSaveFilePath) throws FileStorageException {
        ResultDTO<Boolean> booleanResultDTO = ThirdStorageFileUtil.checkFileBaseDTO(thirdStorageFileBaseDTO);
        if (!booleanResultDTO.isSuccess()) {
            return ResultDTO.fail((String)booleanResultDTO.getDescription());
        }
        if (StringUtils.isBlank((String)downloadSaveFilePath)) {
            return ResultDTO.fail((String)"downloadFilePath is not null");
        }
        OSSClient ossClient = OSSClientUtil.createOssClient(thirdStorageFileBaseDTO.getEndpoint());
        DownloadFileRequest downloadFileRequest = new DownloadFileRequest(thirdStorageFileBaseDTO.getBucketName(), thirdStorageFileBaseDTO.getFileName());
        downloadFileRequest.setDownloadFile(downloadSaveFilePath);
        downloadFileRequest.setTaskNum(StorageProperties.getInstance().getOss_taskNum());
        downloadFileRequest.setPartSize(StorageProperties.getInstance().getOss_partSize());
        downloadFileRequest.setEnableCheckpoint(true);
        try {
            ThirdStorageDownloadFileResultDTO thirdStorageDownloadFileResultDTO = (ThirdStorageDownloadFileResultDTO)DownloadFileResult2DTOTransformer.INSTANCE.apply(ossClient.downloadFile(downloadFileRequest));
            log.info("thirdStorageDownloadFileResultDTO:{}", (Object)JSON.toJSONString((Object)thirdStorageDownloadFileResultDTO, (boolean)true));
            ResultDTO resultDTO = ResultDTO.successfy((Object)thirdStorageDownloadFileResultDTO);
            return resultDTO;
        }
        catch (Throwable throwable) {
            log.error("\u65ad\u70b9\u7eed\u4f20-\u4e0b\u8f7d-\u9047\u5230\u5f02\u5e38", throwable);
            throw new FileStorageException("oss\u4e0b\u8f7d\u9047\u5230\u5f02\u5e38");
        }
        finally {
            ossClient.shutdown();
        }
    }

    public static ResultDTO<List<String>> deleteFiles(ThirdStorageFileDeleteDTO thirdStorageFileDeleteDTO) throws FileStorageException, ThirdStorageClientException {
        ResultDTO<Boolean> booleanResultDTO = ThirdStorageFileUtil.checkFileDeleteDTO(thirdStorageFileDeleteDTO);
        if (!booleanResultDTO.isSuccess()) {
            return ResultDTO.fail((String)booleanResultDTO.getDescription());
        }
        OSSClient ossClient = OSSClientUtil.createOssClient(thirdStorageFileDeleteDTO.getEndpoint());
        DeleteObjectsRequest deleteObjectsRequest = new DeleteObjectsRequest(thirdStorageFileDeleteDTO.getBucketName()).withKeys(thirdStorageFileDeleteDTO.getFileNameList());
        deleteObjectsRequest.setQuiet(false);
        try {
            log.info("\u5f85\u5220\u9664\u7684\u4e91\u5b58\u50a8\u6587\u4ef6:{}", (Object)deleteObjectsRequest.getKeys());
            DeleteObjectsResult deleteObjectsResult = ossClient.deleteObjects(deleteObjectsRequest);
            List deletedObjects = deleteObjectsResult.getDeletedObjects();
            log.info("\u6210\u529f\u5220\u9664\u4e91\u5b58\u50a8\u6587\u4ef6:{}", (Object)deletedObjects);
            if (CollectionUtils.isEmpty((Collection)deletedObjects)) {
                ResultDTO resultDTO = ResultDTO.fail((String)"\u5168\u90e8\u6587\u4ef6\u5220\u9664\u5931\u8d25");
                return resultDTO;
            }
            ResultDTO resultDTO = ResultDTO.successfy((Object)deletedObjects);
            return resultDTO;
        }
        catch (OSSException ossException) {
            log.error("\u5220\u9664\u6587\u4ef6\u9047\u5230OSSException\u5f02\u5e38", (Throwable)ossException);
            throw new FileStorageException("oss\u5220\u9664\u6587\u4ef6\u9047\u5230\u5f02\u5e38");
        }
        catch (ClientException e) {
            log.error("\u5220\u9664\u6587\u4ef6\u9047\u5230ClientException\u5f02\u5e38", (Throwable)e);
            throw new ThirdStorageClientException("oss\u5220\u9664\u6587\u4ef6\u9047\u5230\u5f02\u5e38");
        }
        finally {
            ossClient.shutdown();
        }
    }

    private static ResultDTO<Boolean> checkFileDeleteDTO(ThirdStorageFileDeleteDTO thirdStorageFileDeleteDTO) {
        if (thirdStorageFileDeleteDTO == null) {
            return ResultDTO.fail((String)"fileDeleteDTO is not null");
        }
        if (StringUtils.isBlank((String)thirdStorageFileDeleteDTO.getBucketName())) {
            return ResultDTO.fail((String)"bucketName is not null");
        }
        if (CollectionUtils.isEmpty(thirdStorageFileDeleteDTO.getFileNameList())) {
            return ResultDTO.fail((String)"fileNameList is not empty");
        }
        if (thirdStorageFileDeleteDTO.getFileNameList().size() > 1000) {
            return ResultDTO.fail((String)"fileNameLise size <=1000 ");
        }
        return ResultDTO.successfy((Object)true);
    }

    public static ResultDTO<Boolean> isExistFile(ThirdStorageFileBaseDTO thirdStorageFileBaseDTO) throws FileStorageException, ThirdStorageClientException {
        ResultDTO<Boolean> booleanResultDTO = ThirdStorageFileUtil.checkFileBaseDTO(thirdStorageFileBaseDTO);
        if (!booleanResultDTO.isSuccess()) {
            return booleanResultDTO;
        }
        OSSClient ossClient = OSSClientUtil.createOssClient(thirdStorageFileBaseDTO.getEndpoint());
        try {
            boolean isExist = ossClient.doesObjectExist(thirdStorageFileBaseDTO.getBucketName(), thirdStorageFileBaseDTO.getFileName());
            ResultDTO resultDTO = ResultDTO.successfy((Object)isExist);
            return resultDTO;
        }
        catch (OSSException ossException) {
            log.error("\u786e\u5b9a\u6587\u4ef6\u662f\u5426\u5b58\u5728\u9047\u5230OSSException\u5f02\u5e38", (Throwable)ossException);
            throw new FileStorageException("oss\u786e\u5b9a\u6587\u4ef6\u662f\u5426\u5b58\u5728\u9047\u5230\u5f02\u5e38");
        }
        catch (ClientException e) {
            log.error("\u786e\u5b9a\u6587\u4ef6\u662f\u5426\u5b58\u5728\u9047\u5230ClientException\u5f02\u5e38", (Throwable)e);
            throw new ThirdStorageClientException("oss\u786e\u5b9a\u6587\u4ef6\u662f\u5426\u5b58\u5728\u9047\u5230\u5f02\u5e38");
        }
        finally {
            ossClient.shutdown();
        }
    }

    public static ResultDTO<ThirdDirectoryDTO> queryDirectory(ThirdStorageFileBaseDTO thirdStorageFileBaseDTO) throws FileStorageException, ThirdStorageClientException {
        ResultDTO<Boolean> booleanResultDTO = ThirdStorageFileUtil.checkFileBaseDTO(thirdStorageFileBaseDTO);
        if (!booleanResultDTO.isSuccess()) {
            return ResultDTO.fail((String)booleanResultDTO.getDescription());
        }
        OSSClient ossClient = OSSClientUtil.createOssClient(thirdStorageFileBaseDTO.getEndpoint());
        ThirdDirectoryDTO thirdDirectoryDTO = new ThirdDirectoryDTO();
        ArrayList filePathList = Lists.newArrayList();
        ArrayList directoryList = Lists.newArrayList();
        try {
            ListObjectsRequest listObjectsRequest = new ListObjectsRequest(thirdStorageFileBaseDTO.getBucketName());
            listObjectsRequest.setDelimiter(DELIMITER);
            listObjectsRequest.setPrefix(PathUtil.builderPathEndSlash(thirdStorageFileBaseDTO.getFileName()));
            ObjectListing objectListing = ossClient.listObjects(listObjectsRequest);
            for (OSSObjectSummary ossObjectSummary : objectListing.getObjectSummaries()) {
                filePathList.add(ossObjectSummary.getKey());
            }
            for (String commonPrefix : objectListing.getCommonPrefixes()) {
                directoryList.add(commonPrefix);
            }
        }
        catch (OSSException ossException) {
            log.error("\u67e5\u8be2\u76ee\u5f55\u9047\u5230OSSException\u5f02\u5e38", (Throwable)ossException);
            throw new FileStorageException("oss\u786e\u5b9a\u6587\u4ef6\u662f\u5426\u5b58\u5728\u9047\u5230\u5f02\u5e38");
        }
        catch (ClientException e) {
            log.error("\u67e5\u8be2\u76ee\u5f55\u9047\u5230ClientException\u5f02\u5e38", (Throwable)e);
            throw new ThirdStorageClientException("oss\u786e\u5b9a\u6587\u4ef6\u662f\u5426\u5b58\u5728\u9047\u5230\u5f02\u5e38");
        }
        finally {
            ossClient.shutdown();
        }
        thirdDirectoryDTO.setFilePathList(filePathList);
        thirdDirectoryDTO.setDirectoryList(directoryList);
        return ResultDTO.successfy((Object)thirdDirectoryDTO);
    }
}

