/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.common.storage.util;

import com.chinamcloud.common.result.ResultDTO;
import com.chinamcloud.common.storage.dto.FileDeleteDTO;
import com.chinamcloud.common.storage.dto.FileDeleteResultDTO;
import com.chinamcloud.common.storage.dto.FileStorageDTO;
import com.chinamcloud.common.storage.dto.ThirdStorageFileBaseDTO;
import com.chinamcloud.common.storage.dto.ThirdStorageFileDeleteDTO;
import com.chinamcloud.common.storage.dto.ThirdStorageFileUploadDTO;
import com.chinamcloud.common.storage.dto.ThirdStorageSimpleUploadResultDTO;
import com.chinamcloud.common.storage.exception.FileStorageException;
import com.chinamcloud.common.storage.util.PathUtil;
import com.chinamcloud.common.storage.util.ThirdStorageFileUtil;
import com.chinamcloud.common.util.FileUtil;
import com.google.common.collect.Lists;
import com.google.common.math.IntMath;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.fileupload.FileItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileStorageUtil {
    private static final Logger log = LoggerFactory.getLogger(FileStorageUtil.class);

    public static void saveFile(FileStorageDTO fileStorageDTO, String textContent) throws FileStorageException {
        log.info("\u4fdd\u5b58\u6587\u4ef6:fileStorageDTO:{}", (Object)fileStorageDTO);
        if (fileStorageDTO.isSupportOSSStorage()) {
            File file = FileStorageUtil.writeStringToLocalFile(System.getProperty("java.io.tmpdir"), fileStorageDTO.getSaveFileName(), textContent);
            FileStorageUtil.uploadThirdStorage(fileStorageDTO, file);
            FileStorageUtil.deleteFileByCondition(file, true);
        } else {
            FileStorageUtil.writeStringToLocalFile(fileStorageDTO.getLocalStorageParentPath(), fileStorageDTO.getSaveFileName(), textContent);
        }
    }

    private static void uploadThirdStorage(FileStorageDTO fileStorageDTO, File file) throws FileStorageException {
        ThirdStorageFileUploadDTO thirdStorageFileUploadDTO = FileStorageUtil.builderSimpleThirdStorageFileUploadDTO(fileStorageDTO.getOssBucketName(), fileStorageDTO.getThirdStorageParentPath(), fileStorageDTO.getSaveFileName());
        ResultDTO<ThirdStorageSimpleUploadResultDTO> thirdStorageSimpleUploadResultDTOResultDTO = ThirdStorageFileUtil.simpleUploadByFilePath(thirdStorageFileUploadDTO, file.getAbsolutePath());
        if (!thirdStorageSimpleUploadResultDTOResultDTO.isSuccess()) {
            FileStorageUtil.deleteFileByCondition(file, true);
            throw new FileStorageException("\u4e0a\u4f20\u5230\u4e91\u5b58\u50a8\u5931\u8d25:" + thirdStorageSimpleUploadResultDTOResultDTO.getDescription());
        }
    }

    public static void saveFile(FileStorageDTO fileStorageDTO, byte[] bytes) {
        log.info("\u4fdd\u5b58\u6587\u4ef6:fileStorageDTO:{}", (Object)fileStorageDTO);
        if (fileStorageDTO.isSupportOSSStorage()) {
            File file = FileStorageUtil.writeStringToLocalFile(System.getProperty("java.io.tmpdir"), fileStorageDTO.getSaveFileName(), bytes);
            FileStorageUtil.uploadThirdStorage(fileStorageDTO, file);
            FileStorageUtil.deleteFileByCondition(file, true);
        } else {
            FileStorageUtil.writeStringToLocalFile(fileStorageDTO.getLocalStorageParentPath(), fileStorageDTO.getSaveFileName(), bytes);
        }
    }

    public static File writeFileItemToLocalFile(String localStorageParentPath, String saveFileName, FileItem fileItem) throws Exception {
        log.info("\u5199\u6587\u4ef6\u5230\u672c\u5730\u5b58\u50a8:storageParentPath:{},saveFileName:{}", (Object)localStorageParentPath, (Object)saveFileName);
        File parentFile = new File(localStorageParentPath);
        if (!parentFile.exists()) {
            parentFile.mkdirs();
        }
        String filePath = PathUtil.builderPath(localStorageParentPath, saveFileName);
        File file = new File(filePath);
        fileItem.write(file);
        return file;
    }

    public static void copyFile(String sourceFilePath, String targetFilePath) throws IOException {
        File parentFile;
        log.info("\u62f7\u8d1d\u6587\u4ef6:sourcePath:{},targetParentPath:{}", (Object)sourceFilePath, (Object)targetFilePath);
        if (targetFilePath.lastIndexOf("/") >= 0 && !(parentFile = new File(targetFilePath.substring(0, targetFilePath.lastIndexOf("/")))).exists()) {
            parentFile.mkdirs();
        }
        try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(sourceFilePath));
             BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(targetFilePath));){
            int length = 0;
            byte[] buffer = new byte[1024];
            while (-1 != (length = inputStream.read(buffer))) {
                outputStream.write(buffer, 0, length);
            }
        }
    }

    public static File writeStringToLocalFile(String localStorageParentPath, String saveFileName, String textContent) throws FileStorageException {
        log.info("\u4fdd\u5b58\u6587\u4ef6\u5230\u672c\u5730\uff1astorageParentPath:{},saveFileName:{}", (Object)localStorageParentPath, (Object)saveFileName);
        File parentFile = new File(localStorageParentPath);
        if (!parentFile.exists()) {
            parentFile.mkdirs();
        }
        String filePath = PathUtil.builderPath(localStorageParentPath, saveFileName);
        try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(filePath));){
            byte[] bytes = textContent.getBytes("UTF-8");
            bufferedOutputStream.write(bytes);
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58\u6587\u4ef6\u5230\u672c\u5730\u9047\u5230\u5f02\u5e38:", (Throwable)e);
            throw new FileStorageException("\u4fdd\u5b58\u6587\u4ef6\u5230\u672c\u5730\u9047\u5230\u5f02\u5e38", e);
        }
        return new File(filePath);
    }

    private static File writeStringToLocalFile(String localStorageParentPath, String saveFileName, byte[] bytes) throws FileStorageException {
        log.info("\u4fdd\u5b58\u6587\u4ef6\u5230\u672c\u5730\uff1astorageParentPath:{},saveFileName:{}", (Object)localStorageParentPath, (Object)saveFileName);
        File parentFile = new File(localStorageParentPath);
        if (!parentFile.exists()) {
            parentFile.mkdirs();
        }
        String filePath = PathUtil.builderPath(localStorageParentPath, saveFileName);
        try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(filePath));){
            bufferedOutputStream.write(bytes);
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58\u6587\u4ef6\u5230\u672c\u5730\u9047\u5230\u5f02\u5e38:", (Throwable)e);
            throw new FileStorageException("\u4fdd\u5b58\u6587\u4ef6\u5230\u672c\u5730\u9047\u5230\u5f02\u5e38", e);
        }
        return new File(filePath);
    }

    public static ThirdStorageFileUploadDTO builderSimpleThirdStorageFileUploadDTO(String ossBucketName, String thirdStorageFileParentPath, String saveFileName) {
        ThirdStorageFileUploadDTO thirdStorageFileUploadDTO = new ThirdStorageFileUploadDTO();
        ThirdStorageFileBaseDTO thirdStorageFileBaseDTO = new ThirdStorageFileBaseDTO();
        thirdStorageFileBaseDTO.setBucketName(ossBucketName);
        String ossFileName = PathUtil.builderPath(thirdStorageFileParentPath, saveFileName);
        if (ossFileName.startsWith("/")) {
            ossFileName = ossFileName.substring(1);
        }
        thirdStorageFileBaseDTO.setFileName(ossFileName);
        thirdStorageFileUploadDTO.setThirdStorageFileBaseDTO(thirdStorageFileBaseDTO);
        return thirdStorageFileUploadDTO;
    }

    public static void deleteFileByCondition(File file, boolean isDelete) {
        if (isDelete && file.exists()) {
            log.info("\u5220\u9664:\u6587\u4ef6\u8def\u5f84:{}", (Object)file.getAbsoluteFile());
            file.delete();
        }
    }

    public static FileDeleteResultDTO deleteFile(FileDeleteDTO fileDeleteDTO) {
        log.info("\u5220\u9664:fileDeleteDTO:{}", (Object)fileDeleteDTO);
        List<String> deleteThirdFileSuccessList = FileStorageUtil.deleteThirdFile(fileDeleteDTO);
        List<String> deleteLocalFileSuccessList = FileStorageUtil.deleteLocalFile(fileDeleteDTO.getDeleteLocalFilePathList());
        return FileDeleteResultDTO.builder().deleteThirdFileSuccessList(deleteThirdFileSuccessList).deleteLocalFileSuccessList(deleteLocalFileSuccessList).build();
    }

    public static List<String> deleteLocalFile(List<String> deleteLocalFilePathList) {
        if (CollectionUtils.isEmpty(deleteLocalFilePathList)) {
            return Collections.emptyList();
        }
        ArrayList deleteLocalFileSuccessList = Lists.newArrayList();
        for (int i = 0; i < deleteLocalFilePathList.size(); ++i) {
            boolean delete = FileUtil.delete((String)deleteLocalFilePathList.get(i));
            if (delete) {
                deleteLocalFileSuccessList.add(deleteLocalFilePathList.get(i));
                log.info("\u5220\u9664\u9759\u6001\u6587\u4ef6:{}", (Object)deleteLocalFilePathList.get(i));
                continue;
            }
            log.info("\u9759\u6001\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u65e0\u9700\u5220\u9664:{}", (Object)deleteLocalFilePathList.get(i));
        }
        return deleteLocalFileSuccessList;
    }

    private static List<String> deleteThirdFile(FileDeleteDTO fileDeleteDTO) throws FileStorageException {
        List<String> deleteThirdFilePathList = fileDeleteDTO.getDeleteThirdFilePathList();
        if (CollectionUtils.isEmpty(deleteThirdFilePathList) || !fileDeleteDTO.isSupportOSSStorage()) {
            return Collections.emptyList();
        }
        int pageSize = 1000;
        int totalSize = deleteThirdFilePathList.size();
        int pageNum = IntMath.divide((int)totalSize, (int)pageSize, (RoundingMode)RoundingMode.CEILING);
        ArrayList successDeleteFilePath = Lists.newArrayList();
        for (int m = 0; m < pageNum; ++m) {
            ThirdStorageFileDeleteDTO thirdStorageFileDeleteDTO = new ThirdStorageFileDeleteDTO();
            thirdStorageFileDeleteDTO.setBucketName(fileDeleteDTO.getOssBucketName());
            int fromIndex = m * pageSize;
            int toIndex = pageSize;
            if (m == pageNum - 1) {
                fromIndex = m * pageSize;
                toIndex = totalSize;
            }
            List<String> subDeleteFilePathList = deleteThirdFilePathList.subList(fromIndex, toIndex);
            thirdStorageFileDeleteDTO.setFileNameList(FileStorageUtil.builderDeleteFileNameList(subDeleteFilePathList));
            ResultDTO<List<String>> listResultDTO = ThirdStorageFileUtil.deleteFiles(thirdStorageFileDeleteDTO);
            if (!listResultDTO.isSuccess()) continue;
            successDeleteFilePath.addAll((Collection)listResultDTO.getData());
        }
        return successDeleteFilePath;
    }

    private static List<String> builderDeleteFileNameList(List<String> deleteFilePathList) {
        ArrayList fileNameList = Lists.newArrayList();
        for (int i = 0; i < deleteFilePathList.size(); ++i) {
            String deleteFilePath = deleteFilePathList.get(i);
            if (deleteFilePath.startsWith("/")) {
                fileNameList.add(deleteFilePath.substring(1));
                continue;
            }
            fileNameList.add(deleteFilePath);
        }
        return fileNameList;
    }

    public static long getFileSize(File file) throws Exception {
        long size = 0L;
        if (!file.exists()) {
            log.warn("\u6587\u4ef6\u8def\u5f84\u4e0d\u5b58\u5728:{}", (Object)file.getAbsoluteFile());
            return size;
        }
        File[] files = file.listFiles();
        for (int i = 0; null != files && i < files.length; ++i) {
            if (files[i].isDirectory()) {
                size += FileStorageUtil.getFileSize(files[i]);
                continue;
            }
            size += files[i].length();
        }
        return size;
    }

    public static long getAllTotalFileSize(List<String> storagePathCollection) throws Exception {
        long totalFileSize = 0L;
        for (String storagePath : storagePathCollection) {
            totalFileSize += FileStorageUtil.getFileSize(new File(storagePath));
        }
        return totalFileSize;
    }
}

