/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.spider.base;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class PageResult<T>
implements Serializable {
    public static int DEFAULT_PAGE_SIZE = 10;
    private int currentPage;
    private int pageSize;
    private int totalRecords;
    private int pageCount;
    private int startRecord;
    private boolean hasPreviousPage;
    private boolean hasNextPage;
    private boolean onlyOnePage;
    private List<T> pageRecords;
    private String orderField = "create_time";
    private String orderDirection = "DESC";

    public int getCurrentPage() {
        return this.currentPage;
    }

    public PageResult() {
        this(0, 0, null, null);
    }

    public PageResult(int currentPage, int pageSize) {
        this(currentPage, pageSize, null, null);
    }

    public PageResult(int currentPage, int pageSize, String orderField, String orderDirection) {
        this(currentPage, 0, pageSize, new ArrayList(), orderField, orderDirection);
    }

    public PageResult(int currentPage, int totalSize, int pageSize, List<T> pageRecords, String orderField, String orderDirection) {
        this.pageSize = pageSize;
        this.currentPage = currentPage;
        this.totalRecords = totalSize;
        this.pageRecords = pageRecords;
        if (orderField != null) {
            this.orderField = orderField;
        }
        if (orderDirection != null) {
            this.orderDirection = orderDirection;
        }
        if (this.pageSize == 0) {
            this.pageSize = DEFAULT_PAGE_SIZE;
        }
    }

    public void setCurrentPage(int currentPage) {
        if (currentPage < 1) {
            this.currentPage = 1;
            return;
        }
        if (currentPage > this.getPageCount()) {
            this.currentPage = this.getPageCount();
            return;
        }
        this.currentPage = currentPage;
    }

    public String getOrderField() {
        return this.orderField;
    }

    public void setOrderField(String orderField) {
        this.orderField = orderField;
    }

    public String getOrderDirection() {
        return this.orderDirection;
    }

    public void setOrderDirection(String orderDirection) {
        this.orderDirection = orderDirection;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize <= 0 ? 1 : pageSize;
    }

    public int getTotalRecords() {
        return this.totalRecords;
    }

    public void setTotalRecords(int totalRecords) {
        this.totalRecords = totalRecords;
    }

    public int getPageCount() {
        if (this.totalRecords == 0) {
            this.pageCount = 1;
            return this.pageCount;
        }
        boolean isZero = this.totalRecords % this.pageSize == 0;
        this.pageCount = this.totalRecords / this.pageSize;
        this.pageCount = isZero ? this.pageCount : this.pageCount + 1;
        return this.pageCount;
    }

    public int getStartRecord() {
        if (this.currentPage < 1) {
            this.currentPage = 1;
        }
        this.startRecord = (this.currentPage - 1) * this.pageSize;
        return this.startRecord;
    }

    public boolean isHasPreviousPage() {
        this.hasPreviousPage = this.currentPage != 1;
        return this.hasPreviousPage;
    }

    public boolean isHasNextPage() {
        this.hasNextPage = this.currentPage != this.getPageCount();
        return this.hasNextPage;
    }

    public boolean isOnlyOnePage() {
        this.onlyOnePage = this.getPageCount() == 1;
        return this.onlyOnePage;
    }

    public List<T> getPageRecords() {
        return this.pageRecords;
    }

    public void setPageRecords(List<T> pageRecords) {
        this.pageRecords = pageRecords;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{pageSize=").append(this.pageSize).append(", currentPage=").append(this.currentPage).append(", totalSize=").append(this.totalRecords);
        if (this.totalRecords > 0) {
            sb.append(",pageRecords size =").append(this.pageRecords.size());
        }
        sb.append("}");
        return sb.toString();
    }
}

