/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.spider.utils;

import com.chinamcloud.spider.dto.MultipartBodyPartDto;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkHttpUtil2 {
    private static final Logger log = LoggerFactory.getLogger(OkHttpUtil2.class);

    public static String get(String url, Map<String, String> headerMap, Map<String, Object> parameterMap) {
        log.info("url:{},headerMap:{},parameter:{}", new Object[]{url, headerMap, parameterMap});
        OkHttpClient okHttpClient = new OkHttpClient();
        Request request = OkHttpUtil2.getRequest(url, headerMap, parameterMap);
        try {
            Response response = okHttpClient.newCall(request).execute();
            if (response.isSuccessful()) {
                String jsonString = response.body().string();
                log.info("\u8bf7\u6c42url:{},\u8fd4\u56de:{}", (Object)url, (Object)jsonString);
                return jsonString;
            }
            log.error("\u670d\u52a1\u5668\u7aef\u9519\u8bef", (Object)response.message());
        }
        catch (IOException e) {
            log.error("\u8bf7\u6c42\u9047\u5230\u5f02\u5e38", (Throwable)e);
            throw new RuntimeException(e);
        }
        return null;
    }

    private static Request getRequest(String url, Map<String, String> headerMap, Map<String, Object> parameterMap) {
        String completeUrl = OkHttpUtil2.getCompleteUrl(url, parameterMap);
        Request.Builder builder = new Request.Builder();
        if (MapUtils.isNotEmpty(headerMap)) {
            for (String key : headerMap.keySet()) {
                builder.addHeader(key, headerMap.get(key));
            }
        }
        return builder.url(completeUrl).build();
    }

    private static String getCompleteUrl(String url, Map<String, Object> parameterMap) {
        if (MapUtils.isEmpty(parameterMap)) {
            return url;
        }
        StringBuilder stringBuilder = new StringBuilder(url).append("?");
        int index = 0;
        for (String key : parameterMap.keySet()) {
            Object o = parameterMap.get(key);
            if (o == null) continue;
            if (index > 0) {
                stringBuilder.append("&");
            }
            stringBuilder.append(key).append("=").append(o.toString());
            ++index;
        }
        return stringBuilder.toString();
    }

    public static String postByJson(String url, Map<String, String> headerMap, String parameter) {
        log.info("url:{},headerMap:{},parameter:{}", new Object[]{url, headerMap, parameter});
        MediaType MEDIA_TYPE_TEXT = MediaType.parse((String)"application/json");
        RequestBody requestBody = RequestBody.create((MediaType)MEDIA_TYPE_TEXT, (String)parameter);
        return OkHttpUtil2.post(url, headerMap, requestBody);
    }

    private static String post(String url, Map<String, String> headerMap, RequestBody requestBody) {
        OkHttpClient okHttpClient = new OkHttpClient();
        Request.Builder builder = new Request.Builder();
        if (MapUtils.isNotEmpty(headerMap)) {
            for (String key : headerMap.keySet()) {
                builder.addHeader(key, headerMap.get(key));
            }
        }
        Request request = builder.url(url).post(requestBody).build();
        try {
            Response response = okHttpClient.newCall(request).execute();
            if (response.isSuccessful()) {
                String jsonString = response.body().string();
                log.info("\u8bf7\u6c42url:{},\u8fd4\u56de:{}", (Object)url, (Object)jsonString);
                return jsonString;
            }
            log.error("\u670d\u52a1\u5668\u7aef\u9519\u8bef", (Object)response.message());
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u9047\u5230\u5f02\u5e38", (Throwable)e);
            throw new RuntimeException(e);
        }
        return null;
    }

    public static String postByForm(String url, Map<String, String> headerMap, Map<String, Object> parameterMap) {
        log.info("url:{},headerMap:{},parameter:{}", new Object[]{url, headerMap, parameterMap});
        FormBody.Builder formBodyBuilder = new FormBody.Builder();
        if (MapUtils.isNotEmpty(parameterMap)) {
            for (String key : parameterMap.keySet()) {
                Object o = parameterMap.get(key);
                if (o == null) continue;
                formBodyBuilder.add(key, o.toString());
            }
        }
        FormBody requestBody = formBodyBuilder.build();
        return OkHttpUtil2.post(url, headerMap, (RequestBody)requestBody);
    }

    @Deprecated
    public static String uploadFile(String url, Map<String, String> headerMap, Map<String, Object> parameterMap, Map<String, InputStream> inputStreamMap) {
        try {
            Request request;
            MultipartBody.Builder multipartBodyBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM);
            if (MapUtils.isNotEmpty(parameterMap)) {
                for (Map.Entry<String, Object> entry : parameterMap.entrySet()) {
                    Object object = entry.getValue();
                    if (object == null) continue;
                    multipartBodyBuilder.addFormDataPart(entry.getKey(), object.toString());
                }
            }
            Request.Builder builder = new Request.Builder();
            if (MapUtils.isNotEmpty(headerMap)) {
                for (Map.Entry<String, String> entry : headerMap.entrySet()) {
                    builder.addHeader(entry.getKey(), entry.getValue());
                }
            }
            if (MapUtils.isNotEmpty(inputStreamMap)) {
                try {
                    for (Map.Entry<String, Object> entry : inputStreamMap.entrySet()) {
                        multipartBodyBuilder.addFormDataPart(entry.getKey(), entry.getKey(), RequestBody.create((MediaType)MediaType.parse((String)"text/plain"), (byte[])IOUtils.toByteArray((InputStream)((InputStream)entry.getValue()))));
                    }
                }
                catch (IOException exception) {
                    log.error("inputStream \u8f6c\u6362 byte[]\u5f02\u5e38", (Throwable)exception);
                    throw new RuntimeException(exception);
                }
            }
            MultipartBody requestBody = multipartBodyBuilder.build();
            OkHttpClient okHttpClient = new OkHttpClient.Builder().connectTimeout(500L, TimeUnit.SECONDS).writeTimeout(500L, TimeUnit.SECONDS).readTimeout(500L, TimeUnit.SECONDS).build();
            Response response = okHttpClient.newCall(request = builder.url(url).post((RequestBody)requestBody).build()).execute();
            if (response.isSuccessful()) {
                String result = response.body().string();
                log.info("\u8bf7\u6c42url:{},parameterMap:{},\u8fd4\u56de:{}", new Object[]{url, parameterMap, result});
                return result;
            }
            log.error("\u670d\u52a1\u5668\u7aef\u9519\u8bef", (Object)response.message());
        }
        catch (IOException e) {
            log.error("\u8bf7\u6c42\u9047\u5230\u5f02\u5e38", (Throwable)e);
            throw new RuntimeException(e);
        }
        return null;
    }

    public static String uploadFile(String url, Map<String, String> headerMap, Map<String, Object> parameterMap, List<MultipartBodyPartDto> multipartBodyPartDtoList) {
        try {
            Request request;
            MultipartBody.Builder multipartBodyBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM);
            if (MapUtils.isNotEmpty(parameterMap)) {
                for (Map.Entry<String, Object> entry : parameterMap.entrySet()) {
                    Object object = entry.getValue();
                    if (object == null) continue;
                    multipartBodyBuilder.addFormDataPart(entry.getKey(), object.toString());
                }
            }
            Request.Builder builder = new Request.Builder();
            if (MapUtils.isNotEmpty(headerMap)) {
                for (Map.Entry entry : headerMap.entrySet()) {
                    builder.addHeader((String)entry.getKey(), (String)entry.getValue());
                }
            }
            if (CollectionUtils.isNotEmpty(multipartBodyPartDtoList)) {
                for (MultipartBodyPartDto multipartBodyPartDto : multipartBodyPartDtoList) {
                    multipartBodyBuilder.addPart(MultipartBody.Part.createFormData((String)multipartBodyPartDto.getName(), (String)multipartBodyPartDto.getOriginalFilename(), (RequestBody)RequestBody.create((MediaType)MediaType.parse((String)"text/plain"), (byte[])IOUtils.toByteArray((InputStream)multipartBodyPartDto.getInputStream()))));
                }
            }
            MultipartBody requestBody = multipartBodyBuilder.build();
            OkHttpClient okHttpClient = new OkHttpClient.Builder().connectTimeout(500L, TimeUnit.SECONDS).writeTimeout(500L, TimeUnit.SECONDS).readTimeout(500L, TimeUnit.SECONDS).build();
            Response response = okHttpClient.newCall(request = builder.url(url).post((RequestBody)requestBody).build()).execute();
            if (response.isSuccessful()) {
                String result = response.body().string();
                log.info("\u8bf7\u6c42url:{},parameterMap:{},\u8fd4\u56de:{}", new Object[]{url, parameterMap, result});
                return result;
            }
            log.error("\u670d\u52a1\u5668\u7aef\u9519\u8bef", (Object)response.message());
        }
        catch (IOException e) {
            log.error("\u8bf7\u6c42\u9047\u5230\u5f02\u5e38", (Throwable)e);
            throw new RuntimeException(e);
        }
        return null;
    }
}

