package com.chinamcloud.spider.base;

import com.alibaba.fastjson.JSON;
import com.chinamcloud.spider.code.SystemContants;
import lombok.Getter;
import lombok.Setter;
import org.apache.commons.lang.StringUtils;

import java.io.Serializable;

/**
 * 结果集返回
 * Created by jyy on 17/6/8.
 */
@Getter
@Setter
public class ResultDTO<T> implements Serializable {
    /**
     * 返回对象
     */
    private T data;
    /**
     * 返回状态
     * @see SystemContants
     */
    private Integer state;
    /**
     * 返回信息
     */
    private String message;

    public ResultDTO() {
        super();
    }

    public ResultDTO(Integer state, String message) {
        this.state = state;
        this.message = message;
    }

    public ResultDTO(T data, Integer state, String message) {
        this.data = data;
        this.state = state;
        this.message = message;
    }

    /**
     * 操作正常
     *
     * @param
     * @return
     */
    public static <T> ResultDTO<T> success() {
        return success(null);
    }


    /**
     * 操作正常
     *
     * @param model
     * @param <T>
     * @return
     */
    public static <T> ResultDTO<T> success(T model) {
        return new ResultDTO<>(model, SystemContants.SUCCESS.getCode(), SystemContants.SUCCESS.getMessage());
    }

    public boolean isSuccess(){
        return SystemContants.SUCCESS.getCode().equals(this.state);
    }

    /**
     * 操作异常
     *
     * @param state
     * @param errorMsg
     * @param <T>
     * @return
     */
    public static <T> ResultDTO<T> fail(int state, String errorMsg) {
        return new ResultDTO<>(null, state, errorMsg);
    }

    public static <T> ResultDTO<T> fail(SystemContants systemContants) {
        return new ResultDTO<>(null, systemContants.getCode(), systemContants.getMessage());
    }

    /**
     * 操作异常
     *
     * @param <T>
     * @return
     */
    public static <T> ResultDTO<T> fail() {
        return new ResultDTO<>(SystemContants.FAILURE.getCode(), SystemContants.FAILURE.getMessage());
    }

    /**
     * 操作异常
     *
     * @param errorMessage
     * @param <T>
     * @return
     */
    public static <T> ResultDTO<T> fail(String errorMessage) {
        return new ResultDTO<>(SystemContants.FAILURE.getCode(), errorMessage);
    }

    public String toJSONString(String callback){
        if (StringUtils.isBlank(callback)){
            return JSON.toJSONString(this);
        }else {
            StringBuilder stringBuilder = new StringBuilder(callback);
            stringBuilder.append("(").append(JSON.toJSONString(this)).append(")");
            return stringBuilder.toString();
        }
    }


}
