/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.spider.guava2;

import com.chinamcloud.spider.guava2.Functions2;
import com.chinamcloud.spider.guava2.Identifiable;
import com.chinamcloud.spider.guava2.Pair;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public final class Maps2 {
    private Maps2() {
    }

    public static <F extends Identifiable<I>, I> Map<I, F> newIdToValueMap(Collection<? extends F> coll) {
        return Maps2.newMapWithValue(coll, Functions2.newIdFunction());
    }

    public static <K, V> Map<K, V> newMapWithValue(Collection<? extends V> coll, Function<V, K> valueToKeyFunction) {
        if (CollectionUtils.isEmpty(coll)) {
            return Collections.emptyMap();
        }
        HashMap results = Maps.newHashMapWithExpectedSize((int)coll.size());
        for (V value : coll) {
            Object key = valueToKeyFunction.apply(value);
            results.put(key, value);
        }
        return results;
    }

    public static <K, V> Map<K, V> newMapWithKey(Collection<? extends K> coll, Function<K, V> keyToValueFunction) {
        if (CollectionUtils.isEmpty(coll)) {
            return Collections.emptyMap();
        }
        HashMap results = Maps.newHashMapWithExpectedSize((int)coll.size());
        for (K key : coll) {
            Object value = keyToValueFunction.apply(key);
            results.put(key, value);
        }
        return results;
    }

    public static Map mGet(Collection keys, Map map) {
        HashMap mGetMap = Maps.newHashMap();
        for (Object key : keys) {
            if (!map.containsKey(key)) continue;
            mGetMap.put(key, map.get(key));
        }
        return mGetMap;
    }

    public static Map<String, String> getStringMap(Map<String, Object> objectMap) {
        if (MapUtils.isEmpty(objectMap)) {
            return Collections.emptyMap();
        }
        HashMap stringMap = Maps.newHashMap();
        for (Map.Entry<String, Object> entry : objectMap.entrySet()) {
            stringMap.put(entry.getKey(), String.valueOf(entry.getValue()));
        }
        return stringMap;
    }

    public static Map<String, Object> getObjectMap(Map<String, String> stringMap) {
        if (MapUtils.isEmpty(stringMap)) {
            return Collections.emptyMap();
        }
        HashMap objectMap = Maps.newHashMap();
        for (Map.Entry<String, String> entry : stringMap.entrySet()) {
            objectMap.put(entry.getKey(), entry.getValue());
        }
        return objectMap;
    }

    public static List<Pair<String, String>> transformMap2ListPair(Map<String, String> paramMap) {
        ArrayList params = Lists.newArrayList();
        for (String key : paramMap.keySet()) {
            params.add(Pair.of(key, paramMap.get(key)));
        }
        return params;
    }
}

