/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.spider.utils;

import com.alibaba.fastjson.JSONObject;
import com.chinamcloud.spider.dto.InterfaceDto;
import com.chinamcloud.spider.dto.MultipartBodyPartDto;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkHttpUtil2 {
    private static final Logger log = LoggerFactory.getLogger(OkHttpUtil2.class);

    public static Response get(String url, Map<String, String> headerMap, Map<String, Object> parameterMap) {
        OkHttpClient okHttpClient = new OkHttpClient();
        Request request = OkHttpUtil2.getRequest(url, headerMap, parameterMap);
        try {
            return okHttpClient.newCall(request).execute();
        }
        catch (IOException e) {
            log.error("\u8bf7\u6c42\u9047\u5230\u5f02\u5e38", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static Request getRequest(String url, Map<String, String> headerMap, Map<String, Object> parameterMap) {
        String completeUrl = OkHttpUtil2.getCompleteUrl(url, parameterMap);
        Request.Builder builder = new Request.Builder();
        if (MapUtils.isNotEmpty(headerMap)) {
            for (String key : headerMap.keySet()) {
                builder.addHeader(key, headerMap.get(key));
            }
        }
        return builder.url(completeUrl).build();
    }

    private static String getCompleteUrl(String url, Map<String, Object> parameterMap) {
        if (MapUtils.isEmpty(parameterMap)) {
            return url;
        }
        StringBuilder stringBuilder = new StringBuilder(url).append("?");
        int index = 0;
        for (String key : parameterMap.keySet()) {
            Object o = parameterMap.get(key);
            if (o == null) continue;
            if (index > 0) {
                stringBuilder.append("&");
            }
            stringBuilder.append(key).append("=").append(o.toString());
            ++index;
        }
        return stringBuilder.toString();
    }

    public static Response postByJson(String url, Map<String, String> headerMap, String parameter) {
        MediaType MEDIA_TYPE_TEXT = MediaType.parse((String)"application/json");
        RequestBody requestBody = RequestBody.create((MediaType)MEDIA_TYPE_TEXT, (String)parameter);
        return OkHttpUtil2.post(url, headerMap, requestBody);
    }

    private static Response post(String url, Map<String, String> headerMap, RequestBody requestBody) {
        OkHttpClient okHttpClient = new OkHttpClient();
        Request.Builder builder = new Request.Builder();
        if (MapUtils.isNotEmpty(headerMap)) {
            for (String key : headerMap.keySet()) {
                builder.addHeader(key, headerMap.get(key));
            }
        }
        Request request = builder.url(url).post(requestBody).build();
        try {
            return okHttpClient.newCall(request).execute();
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u9047\u5230\u5f02\u5e38", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static Response postByForm(String url, Map<String, String> headerMap, Map<String, Object> parameterMap) {
        FormBody.Builder formBodyBuilder = new FormBody.Builder();
        if (MapUtils.isNotEmpty(parameterMap)) {
            for (String key : parameterMap.keySet()) {
                Object o = parameterMap.get(key);
                if (o == null) continue;
                formBodyBuilder.add(key, o.toString());
            }
        }
        FormBody requestBody = formBodyBuilder.build();
        return OkHttpUtil2.post(url, headerMap, (RequestBody)requestBody);
    }

    public static Response uploadFile(String url, Map<String, String> headerMap, Map<String, Object> parameterMap, List<MultipartBodyPartDto> multipartBodyPartDtoList) {
        try {
            MultipartBody.Builder multipartBodyBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM);
            if (MapUtils.isNotEmpty(parameterMap)) {
                for (Map.Entry<String, Object> entry : parameterMap.entrySet()) {
                    Object object = entry.getValue();
                    if (object == null) continue;
                    multipartBodyBuilder.addFormDataPart(entry.getKey(), object.toString());
                }
            }
            Request.Builder builder = new Request.Builder();
            if (MapUtils.isNotEmpty(headerMap)) {
                for (Map.Entry entry : headerMap.entrySet()) {
                    builder.addHeader((String)entry.getKey(), (String)entry.getValue());
                }
            }
            if (CollectionUtils.isNotEmpty(multipartBodyPartDtoList)) {
                for (MultipartBodyPartDto multipartBodyPartDto : multipartBodyPartDtoList) {
                    multipartBodyBuilder.addPart(MultipartBody.Part.createFormData((String)multipartBodyPartDto.getName(), (String)multipartBodyPartDto.getOriginalFilename(), (RequestBody)RequestBody.create((MediaType)MediaType.parse((String)"text/plain"), (byte[])IOUtils.toByteArray((InputStream)multipartBodyPartDto.getInputStream()))));
                }
            }
            MultipartBody requestBody = multipartBodyBuilder.build();
            OkHttpClient okHttpClient = new OkHttpClient.Builder().connectTimeout(500L, TimeUnit.SECONDS).writeTimeout(500L, TimeUnit.SECONDS).readTimeout(500L, TimeUnit.SECONDS).build();
            Request request = builder.url(url).post((RequestBody)requestBody).build();
            return okHttpClient.newCall(request).execute();
        }
        catch (IOException e) {
            log.error("\u8bf7\u6c42\u9047\u5230\u5f02\u5e38", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static Response execute(InterfaceDto interfaceDto) {
        Map<String, String> headerMap = interfaceDto.getHeaderMap();
        String method = headerMap.get("method");
        Response response = null;
        if ("get".equalsIgnoreCase(method)) {
            response = OkHttpUtil2.get(interfaceDto.getUrl(), interfaceDto.getHeaderMap(), interfaceDto.getParameterMap());
        } else {
            String contentType = headerMap.get("contentType");
            if (contentType != null && contentType.toLowerCase().contains("application/json")) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.putAll(interfaceDto.getParameterMap());
                response = OkHttpUtil2.postByJson(interfaceDto.getUrl(), interfaceDto.getHeaderMap(), jsonObject.toJSONString());
            } else {
                response = CollectionUtils.isNotEmpty(interfaceDto.getMultipartBodyPartDtoList()) ? OkHttpUtil2.uploadFile(interfaceDto.getUrl(), interfaceDto.getHeaderMap(), interfaceDto.getParameterMap(), interfaceDto.getMultipartBodyPartDtoList()) : OkHttpUtil2.postByForm(interfaceDto.getUrl(), interfaceDto.getHeaderMap(), interfaceDto.getParameterMap());
            }
        }
        return response;
    }

    public static String request(InterfaceDto interfaceDto) {
        Response response = OkHttpUtil2.execute(interfaceDto);
        if (response == null) {
            return null;
        }
        try {
            String result = response.body().string();
            if (!response.isSuccessful()) {
                log.error("\u8bf7\u6c42interfaceDto:{},\u8fd4\u56de:{}", (Object)interfaceDto, (Object)result);
            } else {
                log.debug("\u8bf7\u6c42interfaceDto:{},\u8fd4\u56de:{}", (Object)interfaceDto, (Object)result);
            }
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

