/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.spider.utils;

import com.chinamcloud.spider.dto.MultipartBodyPartDto;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.MapUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

public class RequestUtil {
    public static String getValue(HttpServletRequest request, String key) {
        return request.getHeader(key) != null ? request.getHeader(key) : request.getParameter(key);
    }

    public static List<MultipartBodyPartDto> getMultipartBodyPartDtoList(HttpServletRequest request) throws IOException {
        MultiValueMap multiFileMap = ((MultipartHttpServletRequest)request).getMultiFileMap();
        if (MapUtils.isEmpty((Map)multiFileMap)) {
            return Lists.newArrayList();
        }
        ArrayList multipartBodyPartDtoList = Lists.newArrayList();
        for (Map.Entry entry : multiFileMap.entrySet()) {
            List multipartFileList = (List)entry.getValue();
            for (MultipartFile multipartFile : multipartFileList) {
                MultipartBodyPartDto multipartBodyPartDto = new MultipartBodyPartDto();
                multipartBodyPartDto.setName(multipartFile.getName());
                multipartBodyPartDto.setOriginalFilename(multipartFile.getOriginalFilename());
                multipartBodyPartDto.setInputStream(multipartFile.getInputStream());
                multipartBodyPartDtoList.add(multipartBodyPartDto);
            }
        }
        return multipartBodyPartDtoList;
    }
}

