package com.chinamcloud.spider.exception;

import java.io.PrintStream;
import java.io.PrintWriter;

/**
 * 异常总接口
 * Created by jyy on 17/6/5.
 */
public class SpiderException extends RuntimeException {

    private static final long serialVersionUID = -7866074123502673924L;

    private Integer errorCode;

    public SpiderException() {
    }
    public SpiderException(Integer errorCode) {
        super();
        this.errorCode = errorCode;
    }

    public SpiderException(Integer errorCode, String message) {
        super(message);
        this.errorCode = errorCode;
    }


    public SpiderException(String message) {
        super(message);
    }

    public SpiderException(Throwable cause) {
        super(cause);
    }

    public SpiderException(String message, Throwable cause) {
        super(message, cause);
    }

    public String toString() {

        String s = getClass().getName();
        String message = getLocalizedMessage();
        if (null!=getCause() && getCause() instanceof BussinessException) {
            String causeMessage = getCause().getLocalizedMessage();
            if (causeMessage == null) {
                causeMessage = "";
            }
            return (message != null) ? message : "" + causeMessage;
        }
        return (message != null) ? (s + ": " + message) : s;
    }

    public void printStackTrace(PrintStream s) {
        synchronized (s) {
            if (null!=getCause() && getCause() instanceof BussinessException) {
                s.println(this);
                return;
            }
        }
        super.printStackTrace(s);
    }

    public void printStackTrace(PrintWriter s) {
        synchronized (s) {
            if (null!=getCause() && getCause() instanceof BussinessException) {
                s.println(this);
                return;
            }
        }
        super.printStackTrace(s);
    }

    public String getMessage() {
        String causeMessage="";
        if(null!=getCause()){
            causeMessage = getCause().getLocalizedMessage();
        }
        String messge = super.getMessage();
        if (null == messge) {
            messge = causeMessage;
        } else {
            if(null!=causeMessage && !"".equals(causeMessage.trim())){
                messge = messge + "-" + causeMessage;
            }
        }
        return messge;
    }

    public Integer getErrorCode() {
        return errorCode;
    }
}
