/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.spider.cache.component.impl;

import com.chinamcloud.spider.cache.component.CacheEvent;
import com.chinamcloud.spider.cache.component.CacheEventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.CacheManager;
import org.springframework.data.redis.core.RedisTemplate;

public class DefaultCacheEventHandler
implements CacheEventHandler {
    private static final Logger log = LoggerFactory.getLogger(DefaultCacheEventHandler.class);
    private CacheManager localCacheManager;
    private RedisTemplate redisTemplate;
    private String channel;

    public DefaultCacheEventHandler() {
    }

    public DefaultCacheEventHandler(CacheManager localCacheManager, RedisTemplate redisTemplate) {
        this.localCacheManager = localCacheManager;
        this.redisTemplate = redisTemplate;
    }

    public DefaultCacheEventHandler(CacheManager localCacheManager, RedisTemplate redisTemplate, String channel) {
        this.localCacheManager = localCacheManager;
        this.redisTemplate = redisTemplate;
        this.channel = channel;
    }

    @Override
    public void publishEvent(CacheEvent cacheEvent) {
        this.redisTemplate.convertAndSend(this.channel, (Object)cacheEvent);
    }

    @Override
    public void handleMessage(CacheEvent message) {
        log.info("\u66f4\u65b0\u7f13\u5b58: {" + message.getName() + "},{" + message.getKey() + "{}" + message.getValue() + "}");
        switch (message.getType()) {
            case 1: {
                this.localCacheManager.getCache(message.getName()).put(message.getKey(), message.getValue());
                break;
            }
            case 2: {
                this.localCacheManager.getCache(message.getName()).evict(message.getKey());
                break;
            }
            case 3: {
                this.localCacheManager.getCache(message.getName()).clear();
            }
        }
    }

    public void setLocalCacheManager(CacheManager localCacheManager) {
        this.localCacheManager = localCacheManager;
    }

    public void setRedisTemplate(RedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public CacheManager getLocalCacheManager() {
        return this.localCacheManager;
    }

    public RedisTemplate getRedisTemplate() {
        return this.redisTemplate;
    }

    public String getChannel() {
        return this.channel;
    }
}

