/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.spider.cache.component.impl;

import com.chinamcloud.spider.cache.component.CacheEvent;
import com.chinamcloud.spider.cache.component.CacheEventHandler;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;

public class SpiderCache
implements Cache {
    private static final Logger log = LoggerFactory.getLogger(SpiderCache.class);
    private final String name;
    private final Cache localCache;
    private final Cache remoteCache;
    private final CacheEventHandler cacheEventHandler;

    public SpiderCache(String name, Cache localCache, Cache remoteCache, CacheEventHandler cacheEventHandler) {
        this.name = name;
        this.localCache = localCache;
        this.remoteCache = remoteCache;
        this.cacheEventHandler = cacheEventHandler;
    }

    public String getName() {
        return this.name;
    }

    public Object getNativeCache() {
        return null;
    }

    public Cache.ValueWrapper get(Object keyObject) {
        String key = keyObject.toString();
        Cache.ValueWrapper valueWrapper = this.localCache.get((Object)key);
        log.info("Cache L1 (ehcache) :{" + key + "}={" + valueWrapper + "}");
        if (valueWrapper == null && (valueWrapper = this.remoteCache.get((Object)key)) != null) {
            this.localCache.put((Object)key, valueWrapper.get());
            log.info("Cache L2 (ehcache) :{" + key + "}={" + valueWrapper + "}");
        }
        return valueWrapper;
    }

    public <T> T get(Object key, Class<T> type) {
        Object value;
        Cache.ValueWrapper valueWrapper = this.get(key);
        Object object = value = valueWrapper != null ? valueWrapper.get() : null;
        if (value != null && type != null && !type.isInstance(value)) {
            throw new IllegalStateException("Cached value is not of required type [" + type.getName() + "]: " + value);
        }
        return (T)value;
    }

    public <T> T get(Object key, Callable<T> callable) {
        Cache.ValueWrapper valueWrapper = this.get(key);
        return (T)valueWrapper.get();
    }

    public void put(Object keyObject, Object value) {
        String key = keyObject.toString();
        this.localCache.put((Object)key, value);
        this.remoteCache.put((Object)key, value);
        CacheEvent cacheEvent = new CacheEvent();
        cacheEvent.setType(1);
        cacheEvent.setName(this.getName());
        cacheEvent.setKey(key);
        cacheEvent.setValue(value);
        this.cacheEventHandler.publishEvent(cacheEvent);
    }

    public Cache.ValueWrapper putIfAbsent(Object key, Object value) {
        throw new UnsupportedOperationException("hybridCache is not thread safe");
    }

    public void evict(Object keyObject) {
        String key = keyObject.toString();
        this.localCache.evict((Object)key);
        this.remoteCache.evict((Object)key);
        CacheEvent cacheEvent = new CacheEvent();
        cacheEvent.setType(2);
        cacheEvent.setName(this.getName());
        cacheEvent.setKey(key);
        this.cacheEventHandler.publishEvent(cacheEvent);
    }

    public void clear() {
        this.localCache.clear();
        this.remoteCache.clear();
        CacheEvent cacheEvent = new CacheEvent();
        cacheEvent.setType(3);
        cacheEvent.setName(this.getName());
        this.cacheEventHandler.publishEvent(cacheEvent);
    }
}

