/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.spider.cache.component.impl;

import com.chinamcloud.spider.cache.component.CacheEventHandler;
import com.chinamcloud.spider.cache.component.impl.SpiderCache;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;

public class SpiderCacheManager
implements CacheManager {
    private final ConcurrentMap<String, Cache> cacheConcurrentHashMap = new ConcurrentHashMap<String, Cache>();
    private final Collection<String> names = Collections.unmodifiableSet(this.cacheConcurrentHashMap.keySet());
    private CacheManager localCacheManager;
    private CacheManager remoteCacheManager;
    private CacheEventHandler cacheEventHandler;

    public SpiderCacheManager() {
    }

    public SpiderCacheManager(CacheManager localCacheManager, CacheManager remoteCacheManager) {
        this.localCacheManager = localCacheManager;
        this.remoteCacheManager = remoteCacheManager;
    }

    public SpiderCacheManager(CacheManager localCacheManager, CacheManager remoteCacheManager, CacheEventHandler cacheEventHandler) {
        this.localCacheManager = localCacheManager;
        this.remoteCacheManager = remoteCacheManager;
        this.cacheEventHandler = cacheEventHandler;
    }

    public Cache getCache(String s) {
        Cache cache = (Cache)this.cacheConcurrentHashMap.get(s);
        if (cache == null) {
            cache = new SpiderCache(s, this.localCacheManager.getCache(s), this.remoteCacheManager.getCache(s), this.cacheEventHandler);
            this.cacheConcurrentHashMap.put(s, cache);
        }
        return cache;
    }

    public Collection<String> getCacheNames() {
        return this.names;
    }

    public void setLocalCacheManager(CacheManager localCacheManager) {
        this.localCacheManager = localCacheManager;
    }

    public void setRemoteCacheManager(CacheManager remoteCacheManager) {
        this.remoteCacheManager = remoteCacheManager;
    }

    public void setCacheEventHandler(CacheEventHandler cacheEventHandler) {
        this.cacheEventHandler = cacheEventHandler;
    }

    public ConcurrentMap<String, Cache> getCacheConcurrentHashMap() {
        return this.cacheConcurrentHashMap;
    }

    public Collection<String> getNames() {
        return this.names;
    }

    public CacheManager getLocalCacheManager() {
        return this.localCacheManager;
    }

    public CacheManager getRemoteCacheManager() {
        return this.remoteCacheManager;
    }

    public CacheEventHandler getCacheEventHandler() {
        return this.cacheEventHandler;
    }
}

