package com.chinamcloud.spider.base;

import com.chinamcloud.spider.exception.SpiderException;
import lombok.extern.slf4j.Slf4j;

import java.util.Properties;

/**
 * Created by jyy on 17/5/10.
 */
@Slf4j
public class DBDriverAdapter {

    protected String DATADriverType = null;//数据库方言
    static Properties properties = new Properties();

    /**
     *
     * @Title: getDATADriverType
     * @Description: 获取数据库类型
     * @return    设定文件
     * @return String    返回类型
     * @throws
     */
    public String getDATADriverType() {
        return DATADriverType;
    }

    /**
     *
     * @Title: getPageS
     * @Description: 获取分页SQL的前半部分
     * @param DATADriverType
     * @return
     * @throws Exception    设定文件
     * @return String    返回类型
     * @throws
     */
    public String getPageS(String DATADriverType) throws SpiderException{
        String pageS = "";
        if((Constants.DBTYPE_ORACLE).equals(DATADriverType)){
            pageS = "select * from ( select row_.*, rownum rownum_ from ( ";
        }else if((Constants.DBTYPE_MYSQL).equals(DATADriverType)){
            pageS = "";
        }else{
            throw new SpiderException("数据库底层错误：["+DATADriverType+"]暂不支持此数据库类型，请检查配置文件！");
        }
        return pageS;
    }

    /**
     *
     * @Title: getPageE
     * @Description: 获取分页SQL的后半部分
     * @param DATADriverType
     * @return
     * @throws Exception    设定文件
     * @return String    返回类型
     * @throws
     */
    public String getPageE(String DATADriverType) throws SpiderException{
        String pageE = "";
        if((Constants.DBTYPE_ORACLE).equals(DATADriverType)){
            pageE = " ) row_ ) where rownum_ <= #{lastRows} and rownum_ > #{offset} ";
        }else if((Constants.DBTYPE_MYSQL).equals(DATADriverType)){
            pageE = "limit #{offset},#{pageSize}";
        }else{
            throw new SpiderException("数据库底层错误：暂不支持数据库类型["+DATADriverType+"]，请检查配置文件！");
        }
        return pageE;
    }
}
