package com.chinamcloud.spider.base;

/**
 * Created by jyy on 17/6/5.
 * 数据库操作接口基类
 */

import com.chinamcloud.spider.exception.DataAccessException;

import java.io.Serializable;
import java.util.List;

/**
 * The interface Entity dao.
 *
 * @param <E>  the type parameter
 * @param <PK> the type parameter
 */
public interface EntityDao<E,PK extends Serializable>{

    /**
     *保存实体对象
     *
     * @param entity the entity
     * @throws DataAccessException the data access exception
     */
    int save(E entity) throws DataAccessException;


    /**
     * 批量保存对象
     *
     * @param entities the entity
     * @throws DataAccessException the data access exception
     */
    void batchSave(List<E> entities) throws DataAccessException;



    /**
     * 分页查询
     *
     * @param pageRequest the page request
     * @return the page result
     * @throws DataAccessException the data access exception
     */
    PageResult findPage(PageRequest pageRequest) throws DataAccessException;

    /**
     * 通过主键查询
     *
     * @param primaryKey the primary key
     * @return the by id
     * @throws DataAccessException the data access exception
     */
    E getById(PK primaryKey) throws DataAccessException;

    /**
     * 通过IDS 批量删除
     *
     * @param idList the check ids
     * @throws DataAccessException the data access exception
     */
    List<E> getByIdList(List<PK> idList) throws DataAccessException;

    /**
     * 通过主键更新
     *
     * @param entity the entity
     * @throws DataAccessException the data access exception
     */
    void updateById(E entity) throws DataAccessException;

    /**
     * 通过主键删除
     *
     * @param id the id
     * @throws DataAccessException the data access exception
     */
    int deleteById(PK id) throws DataAccessException;

    /**
     * 通过IDS 批量删除
     *
     * @param checkIds the check ids
     * @throws DataAccessException the data access exception
     */
    void deleteByIds(String checkIds) throws DataAccessException;

    /**
     * 全表查询
     *
     * @return the list
     * @throws DataAccessException the data access exception
     */
    List<E> findAll() throws DataAccessException;

    /**
     * 通过sql更新
     *
     * @param statementName the statement name
     * @param parameter     the parameter
     * @return the int
     * @throws DataAccessException the data access exception
     */
    int updateBySql(String statementName, final Object parameter) throws DataAccessException;

    /**
     * 通过sql 删除
     *
     * @param statementName the statement name
     * @param parameter     the parameter
     * @return the int
     * @throws DataAccessException the data access exception
     */
    int deleteBySql(String statementName, final Object parameter) throws DataAccessException;

    /**
     * 通过sql 插入数据
     *
     * @param statementName the statement name
     * @param parameter     the parameter
     * @return the int
     * @throws DataAccessException the data access exception
     */
    int insertBySql(String statementName, final Object parameter) throws DataAccessException;

    /**
     * 通过sql 自定义查询查
     *
     * @param statementName the statement name
     * @param parameter     the parameter
     * @return the object
     * @throws DataAccessException the data access exception
     */
    Object selectOne(String statementName, final Object parameter) throws DataAccessException;

    /**
     * 通过 自定义查询查
     *
     * @param statementName the statement name
     * @param parameter     the parameter
     * @return the list
     * @throws DataAccessException the data access exception
     */
    List selectList(String statementName, final Object parameter) throws DataAccessException;

    /**
     * 通过sql 自定义查询计数
     *
     * @param statementName the statement name
     * @param parameter     the parameter
     * @return the object
     * @throws DataAccessException the data access exception
     */
    Long selectCount(String statementName, final Object parameter) throws DataAccessException;


}