package com.chinamcloud.spider.system.config.interceptors.kingbase;

import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.plugin.*;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * 使用一定的数据迁移方法无需使用
 */
@Intercepts({
        @Signature(type = StatementHandler.class, method = "prepare", args = {Connection.class, Integer.class})
})
public class KingbaseBatchSaveInterceptor implements Interceptor {

    @Override
    public Object intercept(Invocation invocation) throws Throwable {
        System.out.println("KingbaseBatchSaveInterceptor拦截器intercept()方法执行了");
        StatementHandler statementHandler = (StatementHandler) invocation.getTarget();
        BoundSql boundSql = statementHandler.getBoundSql();
        MetaObject metaObject = SystemMetaObject.forObject(statementHandler);

        // 获取原始的 SQL 语句
        String originalSql = boundSql.getSql().trim();

        // 仅对批量插入语句进行处理
        if (originalSql.toLowerCase().startsWith("insert")) {

            String modifiedSql = null;
            if(isBatchInsert(originalSql)){
                List<ParameterMapping> parameterMappings = boundSql.getParameterMappings();

                replaceIdPlaceholdersWithSequence(originalSql, parameterMappings);

                modifiedSql = removeFirstColumnAndValue(originalSql, parameterMappings);
                System.out.println("modifiedSql="+modifiedSql);
            }else{
                //单条数据插入
                //由于原始mysql版本mapper里面没有带
                modifiedSql = originalSql;

            }


            // 设置修改后的 SQL 语句
            metaObject.setValue("delegate.boundSql.sql", modifiedSql);
        }

        return invocation.proceed();
    }

    private boolean isBatchInsert(String sql) {
        // 使用正则表达式来判断是否为批量插入
        Pattern pattern = Pattern.compile("(?i)\\)\\s*,\\s*\\(");
        Matcher matcher = pattern.matcher(sql);
        return matcher.find();
    }

    private void replaceIdPlaceholdersWithSequence(String sql, List<ParameterMapping> parameterMappings) {
        // 正则匹配 VALUES 部分的每个占位符
        Pattern pattern = Pattern.compile("\\(\\s*\\?\\s*(,\\s*\\?\\s*)*\\)");
        Matcher matcher = pattern.matcher(sql);

        StringBuffer buffer = new StringBuffer();
        List<Integer> indexesToRemove = new ArrayList<>();
        int parameterIndex = 0;

        // 遍历每一个匹配的 VALUES 组
        while (matcher.find()) {
            String group = matcher.group();
//            String replacement = matcher.group().replaceFirst("\\?", "nextval('"+sequenceName+"')");
//            matcher.appendReplacement(buffer, replacement);

            // 记录需要移除的参数索引：每个 VALUES 组的第一个占位符
            indexesToRemove.add(parameterIndex);
            parameterIndex += countQuestionMarks(group);
        }

//        matcher.appendTail(buffer);

        // 移除记录的参数映射
        for (int i = indexesToRemove.size() - 1; i >= 0; i--) {
            int index = indexesToRemove.get(i);
            if (index < parameterMappings.size()) {
                parameterMappings.remove(index);
            }
        }
    }

    private String removeFirstColumnAndValue(String sql, List<ParameterMapping> parameterMappings) {
        // 正则表达式匹配 INSERT INTO 语句的列部分和 VALUES 部分
        Pattern pattern = Pattern.compile("INSERT INTO\\s+\\w+\\s*\\(([^)]*)\\)\\s*VALUES\\s*(.*)", Pattern.CASE_INSENSITIVE | Pattern.DOTALL);
        Matcher matcher = pattern.matcher(sql);

        if (matcher.find()) {
            String columns = matcher.group(1).trim();
            String values = matcher.group(2).trim();

            // 分割列名和对应的值
            String[] columnArray = columns.split("\\s*,\\s*");
            String[] valueGroups = values.split("\\)\\s*,\\s*\\(");

            if (columnArray.length <= 1 || valueGroups.length == 0) {
                return sql;  // 如果列数或值数异常，返回原始 SQL
            }

            // 去掉第一列和每组值的第一个值
            String[] updatedColumns = new String[columnArray.length - 1];
            System.arraycopy(columnArray, 1, updatedColumns, 0, columnArray.length - 1);

            List<String> updatedValueGroups = new ArrayList<>();
            int index = 0;  // 索引变量用于跟踪参数映射
            for (String valueGroup : valueGroups) {
                // 去除多余的括号
                String cleanedValueGroup = valueGroup.replaceAll("[()]", "").trim();
                String[] valueArray = cleanedValueGroup.split("\\s*,\\s*");

                if (valueArray.length > 1) {
                    String[] updatedValues = new String[valueArray.length - 1];
                    System.arraycopy(valueArray, 1, updatedValues, 0, valueArray.length - 1);
                    updatedValueGroups.add("(" + String.join(", ", updatedValues) + ")");
                }

//                // 移除第一个参数映射
//                if (parameterMappings.size() > 0) {
//                    parameterMappings.remove(index); // 根据参数位置移除映射
//                }
            }

            // 构建新的 SQL
            String updatedSql = "INSERT INTO " + sql.substring(12, matcher.start(1)) +
                     String.join(", ", updatedColumns) + ") " +
                    "VALUES " + String.join(", ", updatedValueGroups);

            return updatedSql;
        }
        return sql; // 如果正则匹配不到，返回原始 SQL
    }

//    private String removeFirstColumnAndValue(String sql, List<ParameterMapping> parameterMappings) {
//        // 正则表达式匹配 INSERT INTO 语句的列部分和 VALUES 部分
//        Pattern pattern = Pattern.compile("INSERT INTO\\s+\\w+\\s*\\(([^)]*)\\)\\s*VALUES\\s*(.*)", Pattern.CASE_INSENSITIVE | Pattern.DOTALL);
//        Matcher matcher = pattern.matcher(sql);
//
//        if (matcher.find()) {
//            String columns = matcher.group(1).trim();
//            String values = matcher.group(2).trim();
//
//            // 分割列名和对应的值
//            String[] columnArray = columns.split("\\s*,\\s*");
//            String[] valueGroups = values.split("\\)\\s*,\\s*\\(");
//
//            if (columnArray.length <= 1 || valueGroups.length == 0) {
//                return sql;  // 如果列数或值数异常，返回原始 SQL
//            }
//
//            // 去掉第一列和每组值的第一个值
//            String[] updatedColumns = new String[columnArray.length - 1];
//            System.arraycopy(columnArray, 1, updatedColumns, 0, columnArray.length - 1);
//
//            List<String> updatedValueGroups = new ArrayList<>();
//            for (String valueGroup : valueGroups) {
//                // 去除多余的括号
//                String cleanedValueGroup = valueGroup.replaceAll("[()]", "").trim();
//                String[] valueArray = cleanedValueGroup.split("\\s*,\\s*");
//
//                if (valueArray.length > 1) {
//                    String[] updatedValues = new String[valueArray.length - 1];
//                    System.arraycopy(valueArray, 1, updatedValues, 0, valueArray.length - 1);
//                    updatedValueGroups.add("(" + String.join(", ", updatedValues) + ")");
//                }
//            }
//
//            // 构建新的 SQL
//            String updatedSql = "INSERT INTO " + sql.substring(12, matcher.start(1)) +
//                    "(" + String.join(", ", updatedColumns) + ") " +
//                    "VALUES " + String.join(", ", updatedValueGroups);
//
//            // 移除对应的第一个参数映射
//            int paramsToRemove = valueGroups.length;
//            for (int i = 0; i < paramsToRemove; i++) {
//                if (!parameterMappings.isEmpty()) {
//                    parameterMappings.remove(0);
//                }
//            }
//
//            return updatedSql;
//        }
//        return sql; // 如果正则匹配不到，返回原始 SQL
//    }

//    private String removeFirstColumnAndValue(String sql, List<ParameterMapping> parameterMappings) {
//        // 正则表达式匹配 INSERT INTO 语句的列部分和 VALUES 部分
//        Pattern pattern = Pattern.compile("INSERT INTO\\s+\\w+\\s+\\(([^)]*)\\)\\s+VALUES\\s+(.+)", Pattern.CASE_INSENSITIVE);
//        Matcher matcher = pattern.matcher(sql);
//
//        if (matcher.find()) {
//            String columns = matcher.group(1).trim();
//            String values = matcher.group(2).trim();
//
//            // 分割列名和对应的值
//            String[] columnArray = columns.split("\\s*,\\s*");
//            String[] valueGroups = values.split("\\)\\s*,\\s*\\(");
//
//            // 去掉第一列和每组值的第一个值
//            String[] updatedColumns = new String[columnArray.length - 1];
//            System.arraycopy(columnArray, 1, updatedColumns, 0, columnArray.length - 1);
//
//            List<String> updatedValueGroups = new ArrayList<>();
//            for (String valueGroup : valueGroups) {
//                String[] valueArray = valueGroup.replaceAll("[()]", "").split("\\s*,\\s*");
//                String[] updatedValues = new String[valueArray.length - 1];
//                System.arraycopy(valueArray, 1, updatedValues, 0, valueArray.length - 1);
//                updatedValueGroups.add("(" + String.join(", ", updatedValues) + ")");
//            }
//
//            // 构建新的 SQL
//            String updatedSql = "INSERT INTO " + sql.substring(12, matcher.start(1)) +
//                    "(" + String.join(", ", updatedColumns) + ") " +
//                    "VALUES " + String.join(", ", updatedValueGroups);
//
//            // 移除对应的第一个参数映射
//            for (int i = 0; i < valueGroups.length; i++) {
//                parameterMappings.remove(i * columnArray.length);
//            }
//
//            return updatedSql;
//        }
//        return sql; // 如果正则匹配不到，返回原始 SQL
//    }

    private int countQuestionMarks(String group) {
        int count = 0;
        int index = 0;
        while ((index = group.indexOf("?", index)) != -1) {
            count++;
            index++;
        }
        return count;
    }

    // 自定义方法，用于处理批量插入语句
    private String modifyBatchInsertSql(String originalSql, String sequenceName) {
        // 定位 "VALUES" 关键字
        int valuesPos = originalSql.indexOf("VALUES");
        if (valuesPos == -1) {
            return originalSql;
        }

        // 提取 "VALUES" 之后的部分，假设多条记录以逗号分隔
        String valuesClause = originalSql.substring(valuesPos + "VALUES".length()).trim();

        System.out.println("valuesClause="+valuesClause);

        // 替换每条记录的主键 ID 为序列值

        String modifiedValuesClause = valuesClause.replaceAll("\\(?,", "(nextval('" + sequenceName + "'), ");

        // 重构完整的 SQL 语句
        String newSql = originalSql.substring(0, valuesPos) + "VALUES " + modifiedValuesClause;
        System.out.println("newSql="+newSql);
        return newSql;
    }

    @Override
    public Object plugin(Object target) {
        return Plugin.wrap(target, this);
    }

    @Override
    public void setProperties(Properties properties) {
        // 可选：从配置文件加载属性
    }
}
