package com.chinamcloud.spider.system.config.interceptors.postgresql;

import com.alibaba.druid.util.StringUtils;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.plugin.*;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;

import java.sql.Connection;
import java.util.Properties;

@Intercepts({
        @Signature(type = StatementHandler.class, method = "prepare", args = {Connection.class, Integer.class})
})
public class PostgreSqlPrepareInterceptor implements Interceptor {
    @Override
    public Object intercept(Invocation invocation) throws Throwable {
        StatementHandler statementHandler = (StatementHandler) invocation.getTarget();
        BoundSql boundSql = statementHandler.getBoundSql();
        MetaObject metaObject = SystemMetaObject.forObject(statementHandler);
        // 获取原始的 SQL 语句
        String originalSql = boundSql.getSql();
        String modifiedSql = originalSql;
        for (TokenProcess value : TokenProcess.values()) {
            modifiedSql = value.process(originalSql);
        }
        if (!StringUtils.equals(originalSql, modifiedSql)) {
            metaObject.setValue("delegate.boundSql.sql", modifiedSql);

        }
        return invocation.proceed();
    }
    @Override
    public Object plugin(Object target) {
        return Plugin.wrap(target, this);
    }

    @Override
    public void setProperties(Properties properties) {
    }

    public enum TokenProcess{
        /*加双引号处理*/
        QUOTE {
            final String[] QUOTE_TOKEN = {"LEVEL","COMMENT","SYNONYM","SYSTEM","STAT","RULE","PAGE","MAP","JOB","DAILY","CATALOG","ROLE_ID","VALUE","TYPE"};
            @Override
            public String process(String sql) {
                for (String s : QUOTE_TOKEN) {
                    sql = sql.replaceAll("(?i)(?<=[\\s,.])+" + s + "(?=[\\s,])+", "\"" + "$0" + "\"");
                }
                return sql;
            }
        },
        ;
        protected String process(String oldSql) {
            return oldSql;
        }
    }
}
