package com.chinamcloud.spider.system.config.sqlwrapper;

import com.chinamcloud.spider.system.config.interceptors.dm.DMKeywordInterceptor;
import lombok.Getter;
import lombok.Setter;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.plugin.Invocation;

import java.util.Objects;

@Getter
@Setter
public class DynamicSqlSource implements SqlSource {
    private SqlSource sqlSourceOriginal;
    private Invocation invocation;

    private DynamicSqlSource(SqlSource sqlSourceOriginal, Invocation invocation) {
        this.sqlSourceOriginal = sqlSourceOriginal;
        this.invocation = invocation;
    }

    @Override
    public BoundSql getBoundSql(Object parameterObject) {
        return processSql(sqlSourceOriginal.getBoundSql(parameterObject), invocation);
    }

    public static DynamicSqlSource getDynamicSqlSource(SqlSource sqlSourceOriginal, Invocation invocation) {
        if (sqlSourceOriginal == null) {
            return null;
        }
        if (sqlSourceOriginal instanceof DynamicSqlSource) {
            DynamicSqlSource sourceOriginal = (DynamicSqlSource) sqlSourceOriginal;
            if (!Objects.equals(invocation, sourceOriginal.getInvocation())) {
                sourceOriginal.setInvocation(invocation);
            }
            return sourceOriginal;
        }
        //包装一下
        return new DynamicSqlSource(sqlSourceOriginal, invocation);
    }

    private static BoundSql processSql(BoundSql boundSql, Invocation invocation) {
        // 处理关键字和保留字
        // 例如：将 'comment' 替换为 '"comment"'
        DMKeywordInterceptor.ProcessTokenEnum[] values = DMKeywordInterceptor.ProcessTokenEnum.values();
        if (boundSql instanceof DynamicBoundSql) {
            return boundSql;
        }
        DynamicBoundSql dynamicSqlBound = DynamicBoundSql.getDynamicSqlBound(boundSql);
        for (DMKeywordInterceptor.ProcessTokenEnum value : values) {
            if (value.shouldProcess(dynamicSqlBound, invocation)) {
                dynamicSqlBound = value.process(dynamicSqlBound, invocation);
            }
        }
        return dynamicSqlBound;
    }
}
