package com.chinamcloud.spider.system.config.typeHandlers;

import org.apache.ibatis.type.BooleanTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedJdbcTypes;
import org.apache.ibatis.type.MappedTypes;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

/**
 * 从pgsql或kingbase 查询bit值为0x00或0x01映射为bool的时候,其驱动的BooleanTypeUtil.fromString方法报错
 * 设置bool到pgsql的bit字段不会像kingbase那样报错
 * @author jiapeng
 */
@MappedJdbcTypes(value = {JdbcType.BIT}, includeNullJdbcType = true)
@MappedTypes(value = {Boolean.class, boolean.class})
public class BitHex2BoolTypeHandler extends BooleanTypeHandler {
    @Override
    public Boolean getNullableResult(ResultSet rs, String columnName) throws SQLException {
        // 从 ResultSet 中获取 Boolean 值
        String value = rs.getString(columnName);
        if ("0x01".equals(value)) {
            return true;
        } else if ("0x00".equals(value)){
            return false;
        }
        return super.getNullableResult(rs, columnName);
    }

    @Override
    public Boolean getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        // 从 ResultSet 中获取 Boolean 值
        String value = rs.getString(columnIndex);
        if ("0x01".equals(value)) {
            return true;
        } else if ("0x00".equals(value)){
            return false;
        }
        return super.getNullableResult(rs, columnIndex);
    }

    @Override
    public Boolean getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        String value = cs.getString(columnIndex);
        if ("0x01".equals(value)) {
            return true;
        } else if ("0x00".equals(value)){
            return false;
        }
        return super.getNullableResult(cs, columnIndex);
    }
}