package com.chinamcloud.spider.system.config.typeHandlers;


import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedJdbcTypes;
import org.apache.ibatis.type.MappedTypes;

import java.sql.PreparedStatement;
import java.sql.SQLException;


/**
 * 解决使用kingbase驱动时设置bool值到bit类型时，出现异常的问题
 */
@MappedJdbcTypes(value = {JdbcType.BIT}, includeNullJdbcType = true)
@MappedTypes(value = {Boolean.class, boolean.class})
public class KingbaseBitHexBoolTypeHandler extends BitHex2BoolTypeHandler{
    @Override
    public void setParameter(PreparedStatement ps, int i, Boolean parameter, JdbcType jdbcType) throws SQLException {
        if (parameter == null) {
            ps.setNull(i, JdbcType.BIT.TYPE_CODE);
        }
        //转为设置数值
        ps.setInt(i, Boolean.TRUE.equals(parameter) ? 1 : 0);
    }
}
