/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.spider.system.config.interceptors.dm;

import com.chinamcloud.spider.system.config.sqlwrapper.DynamicBoundSql;
import com.chinamcloud.spider.system.config.sqlwrapper.DynamicSqlSource;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.ResultMapping;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.JdbcType;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class})})
public class DMKeywordInterceptor
implements Interceptor {
    public Object intercept(Invocation invocation) throws Throwable {
        MappedStatement mappedStatement = (MappedStatement)invocation.getArgs()[0];
        Class<?> mappedStatementClass = mappedStatement.getClass();
        Field sqlSourceField = mappedStatementClass.getDeclaredField("sqlSource");
        sqlSourceField.setAccessible(true);
        SqlSource sqlSource = (SqlSource)sqlSourceField.get(mappedStatement);
        sqlSourceField.set(mappedStatement, DynamicSqlSource.getDynamicSqlSource(sqlSource, invocation));
        return invocation.proceed();
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }

    public static enum ProcessTokenEnum {
        SET_NULL_JDBC_TYPE{
            boolean processFlag = false;
            private final Field PARAMETERMAPPING_JDBC_FIELD;
            {
                try {
                    this.PARAMETERMAPPING_JDBC_FIELD = ParameterMapping.class.getDeclaredField("jdbcType");
                    this.PARAMETERMAPPING_JDBC_FIELD.setAccessible(true);
                }
                catch (NoSuchFieldException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public boolean shouldProcess(DynamicBoundSql originSql, Invocation invocation) {
                return true;
            }

            @Override
            public DynamicBoundSql process(DynamicBoundSql oldSql, Invocation invocation) {
                if (!this.processFlag) {
                    MappedStatement mappedStatement = (MappedStatement)invocation.getArgs()[0];
                    Configuration configuration = mappedStatement.getConfiguration();
                    configuration.setJdbcTypeForNull(JdbcType.OTHER);
                    this.processFlag = true;
                }
                List<ParameterMapping> parameterMappings = oldSql.getParameterMappings();
                ResultMap baseResultMap = ProcessTokenEnum.getBaseResultMap(invocation);
                if (baseResultMap == null) {
                    return oldSql;
                }
                List resultMappings = baseResultMap.getResultMappings();
                HashMap<String, JdbcType> propertyJdbcTypeMap = new HashMap<String, JdbcType>();
                for (ResultMapping resultMapping : resultMappings) {
                    String property = resultMapping.getProperty();
                    JdbcType jdbcType_act = resultMapping.getJdbcType();
                    propertyJdbcTypeMap.put(property, jdbcType_act);
                }
                for (ParameterMapping parameterMapping : parameterMappings) {
                    String property;
                    JdbcType type;
                    JdbcType jdbcType = parameterMapping.getJdbcType();
                    if (jdbcType != null || (type = (JdbcType)propertyJdbcTypeMap.get(property = parameterMapping.getProperty())) == null) continue;
                    this.PARAMETERMAPPING_JDBC_FIELD.set(parameterMapping, type);
                }
                return oldSql;
            }
        }
        ,
        KEYWORD{
            final String[] targetToken = new String[]{"COMMENT", "SYNONYM", "SYSTEM", "STAT", "RULE", "PAGE", "MAP", "JOB", "DAILY", "CATALOG", "ROLE_ID", "VALUE", "TYPE"};

            @Override
            public boolean shouldProcess(DynamicBoundSql originSql, Invocation invocation) {
                String upperCaseSql = originSql.getSql().toUpperCase();
                for (String token : this.targetToken) {
                    if (!upperCaseSql.contains(token)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public DynamicBoundSql process(DynamicBoundSql oldSql, Invocation invocation) {
                String processSql = oldSql.getSql();
                for (String s : this.targetToken) {
                    processSql = processSql.replaceAll("(?i)(?<=[\\s,.])+" + s + "(?=[\\s,])+", "\"$0\"");
                }
                oldSql.setSql(processSql);
                return oldSql;
            }
        }
        ,
        SUBDATE,
        GROUP_BY{
            private final String COMPATIBILITY_IDENTIFICATION = "/*+ GROUP_OPT_FLAG(1)*/";

            @Override
            public boolean shouldProcess(DynamicBoundSql dynamicSqlBound, Invocation invocation) {
                String originSql2 = dynamicSqlBound.getSql().replace(" ", "");
                return (originSql2 = originSql2.toUpperCase()).contains("GROUPBY") && !originSql2.contains("/*+ GROUP_OPT_FLAG(1)*/".toUpperCase());
            }

            @Override
            public DynamicBoundSql process(DynamicBoundSql dynamicSqlBound, Invocation invocation) {
                String sqlNew = dynamicSqlBound.getSql().replaceFirst("(?i)(?<=SELECT)[^aA]*?(?=FROM)", " /*+ GROUP_OPT_FLAG(1)*/ $0");
                dynamicSqlBound.setSql(sqlNew);
                return dynamicSqlBound;
            }
        }
        ,
        GROUP_CONCAT{

            @Override
            public boolean shouldProcess(DynamicBoundSql originSql, Invocation invocation) {
                String lowerSql = originSql.getSql().toUpperCase();
                return lowerSql.contains("GROUP_CONCAT(");
            }

            @Override
            public DynamicBoundSql process(DynamicBoundSql oldSql, Invocation invocation) {
                String sql = oldSql.getSql();
                String funcOld = "(?i)" + this.name() + "\\(";
                String funcNew = "WM_CONCAT\\(";
                sql = sql.replaceAll(funcOld, funcNew);
                oldSql.setSql(sql);
                return oldSql;
            }
        }
        ,
        RETURNING_ID,
        INSERT_PK;

        private static volatile Map<String, ResultMap> resultMaps;

        public boolean shouldProcess(DynamicBoundSql originSql, Invocation invocation) {
            return false;
        }

        public DynamicBoundSql process(DynamicBoundSql oldSql, Invocation invocation) {
            return oldSql;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static Map<String, ResultMap> getResultMaps(Invocation invocation) {
            if (resultMaps != null) return resultMaps;
            Class<DMKeywordInterceptor> clazz = DMKeywordInterceptor.class;
            synchronized (DMKeywordInterceptor.class) {
                if (resultMaps != null) return resultMaps;
                MappedStatement arg0 = (MappedStatement)invocation.getArgs()[0];
                Configuration configuration = arg0.getConfiguration();
                Field resultMapField = Configuration.class.getDeclaredField("resultMaps");
                resultMapField.setAccessible(true);
                resultMaps = (Map)resultMapField.get(configuration);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return resultMaps;
            }
        }

        private static ResultMap getBaseResultMap(Invocation invocation) {
            Object arg0 = invocation.getArgs()[0];
            if (arg0 instanceof MappedStatement) {
                MappedStatement statement = (MappedStatement)arg0;
                String id = statement.getId();
                String mapperNameSpace = id.substring(0, id.lastIndexOf("."));
                Map<String, ResultMap> resultMaps = ProcessTokenEnum.getResultMaps(invocation);
                ResultMap baseResultMap = null;
                try {
                    baseResultMap = resultMaps.get(mapperNameSpace + ".BaseResultMap");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return baseResultMap;
            }
            return null;
        }
    }
}

