/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.spider.system.config.interceptors.kingbase;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class})})
public class KingbaseBatchSaveInterceptor
implements Interceptor {
    public Object intercept(Invocation invocation) throws Throwable {
        System.out.println("KingbaseBatchSaveInterceptor\u62e6\u622a\u5668intercept()\u65b9\u6cd5\u6267\u884c\u4e86");
        StatementHandler statementHandler = (StatementHandler)invocation.getTarget();
        BoundSql boundSql = statementHandler.getBoundSql();
        MetaObject metaObject = SystemMetaObject.forObject((Object)statementHandler);
        String originalSql = boundSql.getSql().trim();
        if (originalSql.toLowerCase().startsWith("insert")) {
            String modifiedSql = null;
            if (this.isBatchInsert(originalSql)) {
                List parameterMappings = boundSql.getParameterMappings();
                this.replaceIdPlaceholdersWithSequence(originalSql, parameterMappings);
                modifiedSql = this.removeFirstColumnAndValue(originalSql, parameterMappings);
                System.out.println("modifiedSql=" + modifiedSql);
            } else {
                modifiedSql = originalSql;
            }
            metaObject.setValue("delegate.boundSql.sql", (Object)modifiedSql);
        }
        return invocation.proceed();
    }

    private boolean isBatchInsert(String sql) {
        Pattern pattern = Pattern.compile("(?i)\\)\\s*,\\s*\\(");
        Matcher matcher = pattern.matcher(sql);
        return matcher.find();
    }

    private void replaceIdPlaceholdersWithSequence(String sql, List<ParameterMapping> parameterMappings) {
        Pattern pattern = Pattern.compile("\\(\\s*\\?\\s*(,\\s*\\?\\s*)*\\)");
        Matcher matcher = pattern.matcher(sql);
        StringBuffer buffer = new StringBuffer();
        ArrayList<Integer> indexesToRemove = new ArrayList<Integer>();
        int parameterIndex = 0;
        while (matcher.find()) {
            String group = matcher.group();
            indexesToRemove.add(parameterIndex);
            parameterIndex += this.countQuestionMarks(group);
        }
        for (int i = indexesToRemove.size() - 1; i >= 0; --i) {
            int index = (Integer)indexesToRemove.get(i);
            if (index >= parameterMappings.size()) continue;
            parameterMappings.remove(index);
        }
    }

    private String removeFirstColumnAndValue(String sql, List<ParameterMapping> parameterMappings) {
        Pattern pattern = Pattern.compile("INSERT INTO\\s+\\w+\\s*\\(([^)]*)\\)\\s*VALUES\\s*(.*)", 34);
        Matcher matcher = pattern.matcher(sql);
        if (matcher.find()) {
            String columns = matcher.group(1).trim();
            String values = matcher.group(2).trim();
            String[] columnArray = columns.split("\\s*,\\s*");
            String[] valueGroups = values.split("\\)\\s*,\\s*\\(");
            if (columnArray.length <= 1 || valueGroups.length == 0) {
                return sql;
            }
            CharSequence[] updatedColumns = new String[columnArray.length - 1];
            System.arraycopy(columnArray, 1, updatedColumns, 0, columnArray.length - 1);
            ArrayList<String> updatedValueGroups = new ArrayList<String>();
            boolean index = false;
            for (String valueGroup : valueGroups) {
                String cleanedValueGroup = valueGroup.replaceAll("[()]", "").trim();
                String[] valueArray = cleanedValueGroup.split("\\s*,\\s*");
                if (valueArray.length <= 1) continue;
                CharSequence[] updatedValues = new String[valueArray.length - 1];
                System.arraycopy(valueArray, 1, updatedValues, 0, valueArray.length - 1);
                updatedValueGroups.add("(" + String.join((CharSequence)", ", updatedValues) + ")");
            }
            String updatedSql = "INSERT INTO " + sql.substring(12, matcher.start(1)) + String.join((CharSequence)", ", updatedColumns) + ") VALUES " + String.join((CharSequence)", ", updatedValueGroups);
            return updatedSql;
        }
        return sql;
    }

    private int countQuestionMarks(String group) {
        int count = 0;
        int index = 0;
        while ((index = group.indexOf("?", index)) != -1) {
            ++count;
            ++index;
        }
        return count;
    }

    private String modifyBatchInsertSql(String originalSql, String sequenceName) {
        int valuesPos = originalSql.indexOf("VALUES");
        if (valuesPos == -1) {
            return originalSql;
        }
        String valuesClause = originalSql.substring(valuesPos + "VALUES".length()).trim();
        System.out.println("valuesClause=" + valuesClause);
        String modifiedValuesClause = valuesClause.replaceAll("\\(?,", "(nextval('" + sequenceName + "'), ");
        String newSql = originalSql.substring(0, valuesPos) + "VALUES " + modifiedValuesClause;
        System.out.println("newSql=" + newSql);
        return newSql;
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }
}

