/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.spider.listener;

import cn.ms.sequence.Sequence;
import com.chinamcloud.spider.dao.ModuleIdMapper;
import com.chinamcloud.spider.model.ModuleId;
import com.chinamcloud.spider.ordering.ModuleIdByModuleNumberOrdering;
import com.chinamcloud.spider.utils.IdUtil;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class ModelIdStartupListener
implements ApplicationListener<ContextRefreshedEvent> {
    private static final Logger log = LoggerFactory.getLogger(ModelIdStartupListener.class);
    @Value(value="${spring.application.name}")
    private String applicationName;
    @Autowired
    private IdUtil idUtil;
    @Autowired
    private ModuleIdMapper moduleIdMapper;

    @Transactional
    public void onApplicationEvent(ContextRefreshedEvent contextRefreshedEvent) {
        log.info("begin init IdUtil moduleNumber and memberNumber");
        if (StringUtils.isBlank((String)this.applicationName)) {
            log.error("spring.application.name is blank ");
            throw new RuntimeException("spring.application.name is blank ");
        }
        List moduleIdList = this.moduleIdMapper.findAll();
        ModuleId moduleIdModel = this.getModuleIdModel(moduleIdList);
        Long moduleNumber = 0L;
        Long memberNumber = 0L;
        if (moduleIdModel == null) {
            moduleNumber = this.getCurrentModuleNumber(moduleIdList);
            this.insert(moduleNumber, memberNumber);
        } else {
            moduleNumber = moduleIdModel.getModuleNumber();
            memberNumber = moduleIdModel.getMemberNumber() + 1L;
            this.updateMemberNumber(moduleIdModel.getModuleId());
        }
        long moldNumber = 32L;
        Sequence sequence = new Sequence(moduleNumber % moldNumber, memberNumber % moldNumber);
        this.idUtil.setSequence(sequence);
        log.info("end init IdUtil moduleNumber and memberNumber");
    }

    private void insert(Long moduleNumber, long memberNumber) {
        ModuleId moduleIdModel = new ModuleId();
        moduleIdModel.setModuleName(this.applicationName);
        moduleIdModel.setModuleNumber(moduleNumber);
        moduleIdModel.setMemberNumber(memberNumber);
        Date date = new Date();
        moduleIdModel.setCreateTime(date);
        moduleIdModel.setUpdateTime(date);
        this.moduleIdMapper.save(moduleIdModel);
    }

    private long getCurrentModuleNumber(List<ModuleId> moduleIdList) {
        if (CollectionUtils.isEmpty(moduleIdList)) {
            return 0L;
        }
        Collections.sort(moduleIdList, ModuleIdByModuleNumberOrdering.INSTANCE);
        return moduleIdList.get(moduleIdList.size() - 1).getModuleNumber() + 1L;
    }

    private ModuleId getModuleIdModel(List<ModuleId> moduleIdList) {
        if (CollectionUtils.isEmpty(moduleIdList)) {
            return null;
        }
        for (ModuleId moduleId : moduleIdList) {
            if (!moduleId.getModuleName().equals(this.applicationName)) continue;
            return moduleId;
        }
        return null;
    }

    private void updateMemberNumber(long moduleId) {
        HashMap parameterMap = Maps.newHashMap();
        parameterMap.put("moduleId", moduleId);
        parameterMap.put("updateTime", new Date());
        this.moduleIdMapper.updateBySql("updateMemberId", parameterMap);
    }
}

