/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.spider.system.config.sqlwrapper;

import com.chinamcloud.spider.system.config.interceptors.dm.DMKeywordInterceptor;
import com.chinamcloud.spider.system.config.sqlwrapper.DynamicBoundSql;
import java.util.Objects;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.plugin.Invocation;

public class DynamicSqlSource
implements SqlSource {
    private SqlSource sqlSourceOriginal;
    private Invocation invocation;

    private DynamicSqlSource(SqlSource sqlSourceOriginal, Invocation invocation) {
        this.sqlSourceOriginal = sqlSourceOriginal;
        this.invocation = invocation;
    }

    public BoundSql getBoundSql(Object parameterObject) {
        return DynamicSqlSource.processSql(this.sqlSourceOriginal.getBoundSql(parameterObject), this.invocation);
    }

    public static DynamicSqlSource getDynamicSqlSource(SqlSource sqlSourceOriginal, Invocation invocation) {
        if (sqlSourceOriginal == null) {
            return null;
        }
        if (sqlSourceOriginal instanceof DynamicSqlSource) {
            DynamicSqlSource sourceOriginal = (DynamicSqlSource)sqlSourceOriginal;
            if (!Objects.equals(invocation, sourceOriginal.getInvocation())) {
                sourceOriginal.setInvocation(invocation);
            }
            return sourceOriginal;
        }
        return new DynamicSqlSource(sqlSourceOriginal, invocation);
    }

    private static BoundSql processSql(BoundSql boundSql, Invocation invocation) {
        DMKeywordInterceptor.ProcessTokenEnum[] values = DMKeywordInterceptor.ProcessTokenEnum.values();
        if (boundSql instanceof DynamicBoundSql) {
            return boundSql;
        }
        DynamicBoundSql dynamicSqlBound = DynamicBoundSql.getDynamicSqlBound(boundSql);
        for (DMKeywordInterceptor.ProcessTokenEnum value : values) {
            if (!value.shouldProcess(dynamicSqlBound, invocation)) continue;
            dynamicSqlBound = value.process(dynamicSqlBound, invocation);
        }
        return dynamicSqlBound;
    }

    public SqlSource getSqlSourceOriginal() {
        return this.sqlSourceOriginal;
    }

    public Invocation getInvocation() {
        return this.invocation;
    }

    public void setSqlSourceOriginal(SqlSource sqlSourceOriginal) {
        this.sqlSourceOriginal = sqlSourceOriginal;
    }

    public void setInvocation(Invocation invocation) {
        this.invocation = invocation;
    }
}

