/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.spider.utils;

import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class DatabasePasswordManager {
    private final String[] keySeeds = new String[]{"MySecretKeyForDB1", "AnotherSecureKey2", "DatabaseEncryption3", "SafePasswordKey4"};
    private final SecureRandom secureRandom = new SecureRandom();

    private boolean validatePassword(String password) {
        return password != null && password.length() > 6;
    }

    private byte[] generateKeyFromSeed(String seed, int controlBit) throws Exception {
        String combined = seed + controlBit;
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        return digest.digest(combined.getBytes(StandardCharsets.UTF_8));
    }

    public String decryptPassword(String encryptedPassword) throws Exception {
        byte[] decodedBytes = Base64.getDecoder().decode(encryptedPassword);
        String decodedString = new String(decodedBytes, StandardCharsets.UTF_8);
        int controlBit = Character.getNumericValue(decodedString.charAt(0));
        int method = Character.getNumericValue(decodedString.charAt(1));
        String encryptedContent = decodedString.substring(2);
        if (method == 1) {
            return this.method1Decrypt(encryptedContent, controlBit);
        }
        if (method == 2) {
            return this.method2Decrypt(encryptedContent, controlBit);
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u89e3\u5bc6\u65b9\u6cd5: " + method);
    }

    private String method1Decrypt(String encryptedContent, int controlBit) throws Exception {
        int seedIndex = controlBit % this.keySeeds.length;
        String seed = this.keySeeds[seedIndex];
        byte[] key = this.generateKeyFromSeed(seed, controlBit);
        byte[] encryptedBytes = Base64.getDecoder().decode(encryptedContent);
        byte[] iv = new byte[16];
        byte[] ciphertext = new byte[encryptedBytes.length - 16];
        System.arraycopy(encryptedBytes, 0, iv, 0, 16);
        System.arraycopy(encryptedBytes, 16, ciphertext, 0, ciphertext.length);
        SecretKeySpec secretKey = new SecretKeySpec(key, "AES");
        IvParameterSpec ivSpec = new IvParameterSpec(iv);
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipher.init(2, (Key)secretKey, ivSpec);
        byte[] plaintext = cipher.doFinal(ciphertext);
        return new String(plaintext, StandardCharsets.UTF_8);
    }

    private String method2Decrypt(String encryptedContent, int controlBit) {
        String encryptedChars;
        int calculatedChecksum;
        byte[] decodedBytes = Base64.getDecoder().decode(encryptedContent);
        String encryptedData = new String(decodedBytes, StandardCharsets.UTF_8);
        char checksum = encryptedData.charAt(encryptedData.length() - 1);
        if (checksum != (calculatedChecksum = (encryptedChars = encryptedData.substring(0, encryptedData.length() - 1)).chars().sum() % 256)) {
            throw new IllegalArgumentException("\u6821\u9a8c\u5931\u8d25\uff0c\u6570\u636e\u53ef\u80fd\u88ab\u7be1\u6539");
        }
        StringBuilder decryptedChars = new StringBuilder();
        for (char c : encryptedChars.toCharArray()) {
            char originalChar = (char)((c - controlBit) % 65536);
            decryptedChars.append(originalChar);
        }
        String decryptedStr = decryptedChars.toString();
        String controlStr = String.valueOf(controlBit);
        int pos = (decryptedStr.length() - 1) / 2;
        if (pos != -1) {
            return decryptedStr.substring(0, pos) + decryptedStr.substring(pos + controlStr.length());
        }
        return decryptedStr;
    }
}

