/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.spider.system.config;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoAuthConfig {
    private static final Logger log = LoggerFactory.getLogger(NoAuthConfig.class);
    public List<String> patternPathList;

    public static final NoAuthConfig getInstance() {
        return NoAuthConfigHolder.noAuthConfig;
    }

    private NoAuthConfig() {
        this.initialization();
    }

    private void initialization() {
        String configPath = "config/noAuth.xml";
        log.info("*** NoAuthConfig init begin ***");
        try {
            this.patternPathList = Lists.newArrayList();
            SAXReader reader = new SAXReader();
            Document document = reader.read(NoAuthConfig.class.getClassLoader().getResource(configPath).getPath());
            Element rootElement = document.getRootElement();
            Iterator iterator = rootElement.elementIterator();
            while (iterator.hasNext()) {
                Element next = (Element)iterator.next();
                this.patternPathList.add(next.getText());
            }
            log.info("*** NoAuthConfig init end ***");
        }
        catch (DocumentException e) {
            log.error("NoAuthConfig init error,{}", (Object)configPath, (Object)e);
        }
    }

    public List<String> getPatternPathList() {
        return this.patternPathList;
    }

    private static class NoAuthConfigHolder {
        private static final NoAuthConfig noAuthConfig = new NoAuthConfig();

        private NoAuthConfigHolder() {
        }
    }
}

