/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.spider.utils;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.springframework.core.convert.converter.Converter;
import org.springframework.util.StringUtils;

public class StringToDateConverter
implements Converter<String, Date> {
    private static final String dateFormat = "yyyy-MM-dd HH:mm:ss";
    private static final String shortDateFormat = "yyyy-MM-dd";

    public Date convert(String source) {
        if (StringUtils.isEmpty((Object)source)) {
            return null;
        }
        source = source.trim();
        try {
            if (source.contains("-")) {
                SimpleDateFormat formatter = source.contains(":") ? new SimpleDateFormat(dateFormat) : new SimpleDateFormat(shortDateFormat);
                Date dtDate = formatter.parse(source);
                return dtDate;
            }
            if (source.matches("^\\d+$")) {
                Long lDate = new Long(source);
                return new Date(lDate);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("parser %s to Date fail", source));
        }
        throw new RuntimeException(String.format("parser %s to Date fail", source));
    }
}

