/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.spider.utils;

import com.chinamcloud.spider.base.ResultDTO;
import com.google.common.base.MoreObjects;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.ConversionNotSupportedException;
import org.springframework.beans.TypeMismatchException;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerAdvice
public class SpiderExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(SpiderExceptionHandler.class);

    @ExceptionHandler(value={RuntimeException.class})
    @ResponseBody
    public ResultDTO runtimeExceptionHandler(RuntimeException ex) {
        log.error("\u5168\u5c40\u5f02\u5e38\u5904\u7406 \u9519\u8bef\u539f\u56e0(\u8fd0\u884c\u65f6\u5f02\u5e38) {}", (Throwable)ex);
        return ResultDTO.fail((String)((String)MoreObjects.firstNonNull((Object)ex.getMessage(), (Object)"\u64cd\u4f5c\u5931\u8d25\uff0c\u670d\u52a1\u9047\u5230\u5f02\u5e38")));
    }

    @ExceptionHandler(value={NullPointerException.class})
    @ResponseBody
    public ResultDTO nullPointerExceptionHandler(NullPointerException ex) {
        log.error("\u5168\u5c40\u5f02\u5e38\u5904\u7406 \u9519\u8bef\u539f\u56e0(\u7a7a\u6307\u9488\u5f02\u5e38) {}", (Throwable)ex);
        return ResultDTO.fail();
    }

    @ExceptionHandler(value={ClassCastException.class})
    @ResponseBody
    public ResultDTO classCastExceptionHandler(ClassCastException ex) {
        log.error("\u5168\u5c40\u5f02\u5e38\u5904\u7406 \u9519\u8bef\u539f\u56e0(\u7c7b\u578b\u8f6c\u6362\u5f02\u5e38) {}", (Throwable)ex);
        return ResultDTO.fail();
    }

    @ExceptionHandler(value={IOException.class})
    @ResponseBody
    public ResultDTO iOExceptionHandler(IOException ex) {
        log.error("\u5168\u5c40\u5f02\u5e38\u5904\u7406 \u9519\u8bef\u539f\u56e0(IO\u5f02\u5e38) {}", (Throwable)ex);
        return ResultDTO.fail();
    }

    @ExceptionHandler(value={NoSuchMethodException.class})
    @ResponseBody
    public ResultDTO noSuchMethodExceptionHandler(NoSuchMethodException ex) {
        log.error("\u5168\u5c40\u5f02\u5e38\u5904\u7406 \u9519\u8bef\u539f\u56e0(\u672a\u77e5\u65b9\u6cd5\u5f02\u5e38) {}", (Throwable)ex);
        return ResultDTO.fail();
    }

    @ExceptionHandler(value={IndexOutOfBoundsException.class})
    @ResponseBody
    public ResultDTO indexOutOfBoundsExceptionHandler(IndexOutOfBoundsException ex) {
        log.error("\u5168\u5c40\u5f02\u5e38\u5904\u7406 \u9519\u8bef\u539f\u56e0(\u6570\u7ec4\u8d8a\u754c\u5f02\u5e38) {}", (Throwable)ex);
        return ResultDTO.fail();
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    @ResponseBody
    public ResultDTO requestNotReadable(HttpMessageNotReadableException ex) {
        log.error("\u5168\u5c40\u5f02\u5e38\u5904\u7406 \u9519\u8bef\u539f\u56e0(400\u9519\u8bef) {}", (Throwable)ex);
        return ResultDTO.fail();
    }

    @ExceptionHandler(value={TypeMismatchException.class})
    @ResponseBody
    public ResultDTO requestTypeMismatch(TypeMismatchException ex) {
        log.error("\u5168\u5c40\u5f02\u5e38\u5904\u7406 \u9519\u8bef\u539f\u56e0(\u7c7b\u578b\u4e0d\u652f\u6301) {}", (Throwable)ex);
        return ResultDTO.fail();
    }

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    @ResponseBody
    public ResultDTO requestMissingServletRequest(MissingServletRequestParameterException ex) {
        log.error("\u5168\u5c40\u5f02\u5e38\u5904\u7406 \u9519\u8bef\u539f\u56e0(\u9519\u8bef\u8bf7\u6c42\u53c2\u6570) {}", (Throwable)ex);
        return ResultDTO.fail();
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    @ResponseBody
    public ResultDTO request405(HttpRequestMethodNotSupportedException ex) {
        log.error("\u5168\u5c40\u5f02\u5e38\u5904\u7406 \u9519\u8bef\u539f\u56e0(\u65b9\u6cd5\u4e0d\u5141\u8bb8) {}", (Throwable)ex);
        return ResultDTO.fail((int)405, (String)ex.getMessage());
    }

    @ExceptionHandler(value={HttpMediaTypeNotAcceptableException.class})
    @ResponseBody
    public ResultDTO request406(HttpMediaTypeNotAcceptableException ex) {
        log.error("\u5168\u5c40\u5f02\u5e38\u5904\u7406 \u9519\u8bef\u539f\u56e0(\u4e0d\u80fd\u63a5\u53d7) {}", (Throwable)ex);
        return ResultDTO.fail((int)406, (String)ex.getMessage());
    }

    @ExceptionHandler(value={ConversionNotSupportedException.class, HttpMessageNotWritableException.class})
    @ResponseBody
    public ResultDTO server500(RuntimeException ex) {
        log.error("\u5168\u5c40\u5f02\u5e38\u5904\u7406 \u9519\u8bef\u539f\u56e0(\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef(\u8fd0\u884c\u65f6\u5f02\u5e38)) {}", (Throwable)ex);
        return ResultDTO.fail((int)500, (String)ex.getMessage());
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public ResultDTO unknow500(RuntimeException ex) {
        log.error("\u5168\u5c40\u5f02\u5e38\u5904\u7406 \u9519\u8bef\u539f\u56e0(\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef(\u975e\u8fd0\u884c\u5f02\u5e38)) {}", (Throwable)ex);
        return ResultDTO.fail((int)500, (String)ex.getMessage());
    }
}

