/*
 * Decompiled with CFR 0.152.
 */
package com.cxytiandi.encrypt.core;

import com.cxytiandi.encrypt.algorithm.AesEncryptAlgorithm;
import com.cxytiandi.encrypt.algorithm.EncryptAlgorithm;
import com.cxytiandi.encrypt.core.EncryptionConfig;
import com.cxytiandi.encrypt.core.EncryptionReqestWrapper;
import com.cxytiandi.encrypt.core.EncryptionResponseWrapper;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class EncryptionFilter
implements Filter {
    private Logger logger = LoggerFactory.getLogger(EncryptionFilter.class);
    private EncryptionConfig encryptionConfig;
    private EncryptAlgorithm encryptAlgorithm = new AesEncryptAlgorithm();

    public EncryptionFilter() {
        this.encryptionConfig = new EncryptionConfig();
    }

    public EncryptionFilter(EncryptionConfig config) {
        this.encryptionConfig = config;
    }

    public EncryptionFilter(EncryptionConfig config, EncryptAlgorithm encryptAlgorithm) {
        this.encryptionConfig = config;
        this.encryptAlgorithm = encryptAlgorithm;
    }

    public EncryptionFilter(String key) {
        EncryptionConfig config = new EncryptionConfig();
        config.setKey(key);
        this.encryptionConfig = config;
    }

    public EncryptionFilter(String key, List<String> responseEncryptUriList, List<String> requestDecyptUriList, String responseCharset, boolean debug) {
        this.encryptionConfig = new EncryptionConfig(key, responseEncryptUriList, requestDecyptUriList, responseCharset, debug);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        String uri = req.getRequestURI();
        this.logger.debug("RequestURI: {}", (Object)uri);
        if (this.encryptionConfig.isDebug()) {
            chain.doFilter((ServletRequest)req, (ServletResponse)resp);
            return;
        }
        boolean decryptionStatus = this.contains(this.encryptionConfig.getRequestDecyptUriList(), uri, req.getMethod());
        boolean encryptionStatus = this.contains(this.encryptionConfig.getResponseEncryptUriList(), uri, req.getMethod());
        boolean decryptionIgnoreStatus = this.contains(this.encryptionConfig.getRequestDecyptUriIgnoreList(), uri, req.getMethod());
        boolean encryptionIgnoreStatus = this.contains(this.encryptionConfig.getResponseEncryptUriIgnoreList(), uri, req.getMethod());
        if (CollectionUtils.isEmpty(this.encryptionConfig.getRequestDecyptUriList()) && CollectionUtils.isEmpty(this.encryptionConfig.getResponseEncryptUriList())) {
            decryptionStatus = true;
            encryptionStatus = true;
        }
        if (encryptionIgnoreStatus) {
            encryptionStatus = false;
        }
        if (decryptionIgnoreStatus) {
            decryptionStatus = false;
        }
        if (!decryptionStatus && !encryptionStatus) {
            chain.doFilter((ServletRequest)req, (ServletResponse)resp);
            return;
        }
        EncryptionResponseWrapper responseWrapper = null;
        EncryptionReqestWrapper reqestWrapper = null;
        if (decryptionStatus) {
            reqestWrapper = new EncryptionReqestWrapper(req);
            this.processDecryption(reqestWrapper, req);
        }
        if (encryptionStatus) {
            responseWrapper = new EncryptionResponseWrapper(resp);
        }
        if (encryptionStatus && decryptionStatus) {
            chain.doFilter((ServletRequest)reqestWrapper, (ServletResponse)responseWrapper);
        } else if (encryptionStatus) {
            chain.doFilter((ServletRequest)req, (ServletResponse)responseWrapper);
        } else if (decryptionStatus) {
            chain.doFilter((ServletRequest)reqestWrapper, (ServletResponse)resp);
        }
        if (encryptionStatus) {
            String responeData = responseWrapper.getResponseData();
            this.writeEncryptContent(responeData, response);
        }
    }

    private void processDecryption(EncryptionReqestWrapper reqestWrapper, HttpServletRequest req) {
        String requestData = reqestWrapper.getRequestData();
        String uri = req.getRequestURI();
        this.logger.debug("RequestData: {}", (Object)requestData);
        try {
            String decyptRequestData = this.encryptAlgorithm.decrypt(requestData, this.encryptionConfig.getKey());
            this.logger.debug("DecyptRequestData: {}", (Object)decyptRequestData);
            reqestWrapper.setRequestData(decyptRequestData);
            HashMap<String, String> paramMap = new HashMap<String, String>();
            Enumeration parameterNames = req.getParameterNames();
            while (parameterNames.hasMoreElements()) {
                String paramName = (String)parameterNames.nextElement();
                String prefixUri = req.getMethod().toLowerCase() + ":" + uri;
                if (!this.encryptionConfig.getRequestDecyptParams(prefixUri).contains(paramName)) continue;
                String paramValue = req.getParameter(paramName);
                String decryptParamValue = this.encryptAlgorithm.decrypt(paramValue, this.encryptionConfig.getKey());
                paramMap.put(paramName, decryptParamValue);
            }
            reqestWrapper.setParamMap(paramMap);
        }
        catch (Exception e) {
            this.logger.error("\u8bf7\u6c42\u6570\u636e\u89e3\u5bc6\u5931\u8d25", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void writeEncryptContent(String responeData, ServletResponse response) throws IOException {
        this.logger.debug("ResponeData: {}", (Object)responeData);
        ServletOutputStream out = null;
        try {
            responeData = this.encryptAlgorithm.encrypt(responeData, this.encryptionConfig.getKey());
            this.logger.debug("EncryptResponeData: {}", (Object)responeData);
            response.setContentLength(responeData.length());
            response.setCharacterEncoding(this.encryptionConfig.getResponseCharset());
            out = response.getOutputStream();
            out.write(responeData.getBytes(this.encryptionConfig.getResponseCharset()));
        }
        catch (Exception e) {
            this.logger.error("\u54cd\u5e94\u6570\u636e\u52a0\u5bc6\u5931\u8d25", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            if (out != null) {
                out.flush();
                out.close();
            }
        }
    }

    private boolean contains(List<String> list, String uri, String methodType) {
        if (list.contains(uri)) {
            return true;
        }
        String prefixUri = methodType.toLowerCase() + ":" + uri;
        this.logger.debug("contains uri: {}", (Object)prefixUri);
        return list.contains(prefixUri);
    }

    public void destroy() {
    }
}

