/*
 * Decompiled with CFR 0.152.
 */
package com.cxytiandi.encrypt.springboot.init;

import com.cxytiandi.encrypt.springboot.annotation.Decrypt;
import com.cxytiandi.encrypt.springboot.annotation.DecryptIgnore;
import com.cxytiandi.encrypt.springboot.annotation.Encrypt;
import com.cxytiandi.encrypt.springboot.annotation.EncryptIgnore;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

public class ApiEncryptDataInit
implements ApplicationContextAware {
    private Logger logger = LoggerFactory.getLogger(ApiEncryptDataInit.class);
    public static List<String> responseEncryptUriList = new ArrayList<String>();
    public static List<String> requestDecyptUriList = new ArrayList<String>();
    public static List<String> responseEncryptUriIgnoreList = new ArrayList<String>();
    public static List<String> requestDecyptUriIgnoreList = new ArrayList<String>();
    public static Map<String, List<String>> requestDecyptParamMap = new HashMap<String, List<String>>();
    private String contextPath;

    public void setApplicationContext(ApplicationContext ctx) throws BeansException {
        this.contextPath = ctx.getEnvironment().getProperty("server.servlet.context-path");
        Map beanMap = ctx.getBeansWithAnnotation(Controller.class);
        this.initData(beanMap);
        this.initRequestDecyptParam(ctx.getEnvironment());
    }

    private void initRequestDecyptParam(Environment environment) {
        for (PropertySource propertySource : ((AbstractEnvironment)environment).getPropertySources()) {
            if (!(propertySource instanceof EnumerablePropertySource)) continue;
            for (String name : ((EnumerablePropertySource)propertySource).getPropertyNames()) {
                if (!name.startsWith("spring.encrypt.requestDecyptParam")) continue;
                String[] keys = name.split("\\.");
                String key = keys[keys.length - 1];
                String property = environment.getProperty(name);
                requestDecyptParamMap.put(key.replace("$", ":"), Arrays.asList(property.split(",")));
            }
        }
    }

    private void initData(Map<String, Object> beanMap) {
        if (beanMap != null) {
            for (Object bean : beanMap.values()) {
                Method[] methods;
                Class<?> clz = bean.getClass();
                for (Method method : methods = clz.getMethods()) {
                    DecryptIgnore decryptIgnore;
                    EncryptIgnore encryptIgnore;
                    Decrypt decrypt;
                    Encrypt encrypt = (Encrypt)AnnotationUtils.findAnnotation((Method)method, Encrypt.class);
                    if (encrypt != null) {
                        String uri = encrypt.value();
                        if (!StringUtils.hasText((String)uri)) {
                            uri = this.getApiUri(clz, method);
                        }
                        this.logger.debug("Encrypt URI: {}", (Object)uri);
                        responseEncryptUriList.add(uri);
                    }
                    if ((decrypt = (Decrypt)AnnotationUtils.findAnnotation((Method)method, Decrypt.class)) != null) {
                        String decyptParam;
                        String uri = decrypt.value();
                        if (!StringUtils.hasText((String)uri)) {
                            uri = this.getApiUri(clz, method);
                        }
                        if (StringUtils.hasText((String)(decyptParam = decrypt.decyptParam()))) {
                            requestDecyptParamMap.put(uri, Arrays.asList(decyptParam.split(",")));
                        }
                        this.logger.debug("Decrypt URI: {}", (Object)uri);
                        requestDecyptUriList.add(uri);
                    }
                    if ((encryptIgnore = (EncryptIgnore)AnnotationUtils.findAnnotation((Method)method, EncryptIgnore.class)) != null) {
                        String uri = encryptIgnore.value();
                        if (!StringUtils.hasText((String)uri)) {
                            uri = this.getApiUri(clz, method);
                        }
                        this.logger.debug("EncryptIgnore URI: {}", (Object)uri);
                        responseEncryptUriIgnoreList.add(uri);
                    }
                    if ((decryptIgnore = (DecryptIgnore)AnnotationUtils.findAnnotation((Method)method, DecryptIgnore.class)) == null) continue;
                    String uri = decryptIgnore.value();
                    if (!StringUtils.hasText((String)uri)) {
                        uri = this.getApiUri(clz, method);
                    }
                    this.logger.debug("DecryptIgnore URI: {}", (Object)uri);
                    requestDecyptUriIgnoreList.add(uri);
                }
            }
        }
    }

    private String getApiUri(Class<?> clz, Method method) {
        String methodType = "";
        StringBuilder uri = new StringBuilder();
        RequestMapping reqMapping = (RequestMapping)AnnotationUtils.findAnnotation(clz, RequestMapping.class);
        if (reqMapping != null) {
            uri.append(this.formatUri(reqMapping.value()[0]));
        }
        GetMapping getMapping = (GetMapping)AnnotationUtils.findAnnotation((Method)method, GetMapping.class);
        PostMapping postMapping = (PostMapping)AnnotationUtils.findAnnotation((Method)method, PostMapping.class);
        RequestMapping requestMapping = (RequestMapping)AnnotationUtils.findAnnotation((Method)method, RequestMapping.class);
        PutMapping putMapping = (PutMapping)AnnotationUtils.findAnnotation((Method)method, PutMapping.class);
        DeleteMapping deleteMapping = (DeleteMapping)AnnotationUtils.findAnnotation((Method)method, DeleteMapping.class);
        if (getMapping != null) {
            methodType = "get:";
            uri.append(this.formatUri(getMapping.value()[0]));
        } else if (postMapping != null) {
            methodType = "post:";
            uri.append(this.formatUri(postMapping.value()[0]));
        } else if (putMapping != null) {
            methodType = "put:";
            uri.append(this.formatUri(putMapping.value()[0]));
        } else if (deleteMapping != null) {
            methodType = "delete:";
            uri.append(this.formatUri(deleteMapping.value()[0]));
        } else if (requestMapping != null) {
            RequestMethod m = requestMapping.method()[0];
            methodType = m.name().toLowerCase() + ":";
            uri.append(this.formatUri(requestMapping.value()[0]));
        }
        if (StringUtils.hasText((String)this.contextPath) && !"/".equals(this.contextPath)) {
            return methodType + this.contextPath + uri.toString();
        }
        return methodType + uri.toString();
    }

    private String formatUri(String uri) {
        if (uri.startsWith("/")) {
            return uri;
        }
        return "/" + uri;
    }
}

