/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.b.a;
import dm.jdbc.b.b;
import dm.jdbc.b.c;
import dm.jdbc.b.d;
import dm.jdbc.desc.ArrayDescriptor;
import dm.jdbc.desc.Configuration;
import dm.jdbc.desc.Const;
import dm.jdbc.desc.DmProperties;
import dm.jdbc.desc.DmSvcConf;
import dm.jdbc.desc.EP;
import dm.jdbc.desc.EPGroup;
import dm.jdbc.desc.StructDescriptor;
import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbArray;
import dm.jdbc.driver.DmdbBlob;
import dm.jdbc.driver.DmdbCallableStatement;
import dm.jdbc.driver.DmdbClob;
import dm.jdbc.driver.DmdbConnection$1;
import dm.jdbc.driver.DmdbConnection$2;
import dm.jdbc.driver.DmdbConnection$3;
import dm.jdbc.driver.DmdbConnection$4;
import dm.jdbc.driver.DmdbDatabaseMetaData;
import dm.jdbc.driver.DmdbNClob;
import dm.jdbc.driver.DmdbPreparedStatement;
import dm.jdbc.driver.DmdbSQLXML;
import dm.jdbc.driver.DmdbSavepoint;
import dm.jdbc.driver.DmdbStatement;
import dm.jdbc.driver.DmdbStruct;
import dm.jdbc.enums.ENCODING;
import dm.jdbc.filter.FilterChain;
import dm.jdbc.filter.Filterable;
import dm.jdbc.filter.log.ILogger;
import dm.jdbc.filter.log.LogFactory;
import dm.jdbc.jni.MarkDll;
import dm.jdbc.parser.LVal;
import dm.jdbc.parser.SQLProcessor;
import dm.jdbc.processor.DBAliveCheckThread;
import dm.jdbc.util.CacheMap;
import dm.jdbc.util.CacheQueue;
import dm.jdbc.util.DriverUtil;
import dm.jdbc.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLPermission;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;

public class DmdbConnection
extends Filterable
implements dm.jdbc.a.a,
Connection {
    public long sessionID = -1L;
    public String schema;
    public String guid;
    private String serverEncoding = ENCODING.GB18030.stringValue();
    public boolean constParaOpt = false;
    public short dbTimezone = 0;
    public int sslEncrypt = 0;
    public int maxSession;
    public int maxRowSize;
    public int svrMode;
    public int svrStat;
    public boolean caseSensitive = true;
    public boolean ddlAutoCommit;
    public int isoLevel = -1;
    public int trxStatus = 0;
    public boolean trxFinish = true;
    public boolean malini2 = true;
    public boolean execute2 = false;
    public static final int NEW_LOB_FLAG_EX = 1;
    public static final int NEW_LOB_FLAG_LLOB = 2;
    public int newLobFlag = 3;
    public boolean supportNameParameter = false;
    public boolean lobEmptyCompOrcl = false;
    public int oracleDateLanguage = DmSvcConf.GLOBAL.getLanguage();
    public String formatDate;
    public String formatTimestamp;
    public String formatTimestampTZ;
    public String formatTime;
    public String formatTimeTZ;
    public String standbyHost;
    public int standbyPort;
    public int standbyCount;
    public boolean dscControl;
    public String url;
    public String user;
    public String password;
    public String host = "localhost";
    public int port = 5236;
    public int socketTimeout = 0;
    public int connectTimeout = 5000;
    public int sessionTimeout = 0;
    public boolean keepAlive = true;
    public boolean loginEncrypt = true;
    public String loginCertificate = null;
    public String cipherPath = null;
    public byte osAuthType;
    public String sslFilesPath = "";
    public String sslKeystorePass = "";
    public String kerberosLoginConfPath = "";
    public String uKeyName = "";
    public String uKeyPin = "";
    public int compress = 0;
    public byte compressID = 0;
    public String sessEncode;
    public boolean enRsCache = false;
    public int rsCacheSize = 20;
    public int rsRefreshFreq = 10;
    public String[] keyWords = null;
    public int rwSeparate = 0;
    public int rwPercent = 25;
    public boolean rwAutoDistribute = true;
    public int rwStandbyRecoverTime = 1000;
    public boolean rwHA = false;
    public boolean rwIgnoreSql = false;
    public boolean mppLocal = false;
    public static final int MPP_FLDR_INSERT = 1;
    public static final int MPP_FLDR_SELECT = 2;
    public int mppOpt = 0;
    public String appName = "";
    public String osName = System.getProperty("os.name", "");
    public short localTimezone = Const.TIME_ZONE_DEFAULT;
    public int stmtPoolSize = 15;
    public int pstmtPoolSize = 0;
    public int pstmtPoolValidTime = 0;
    public boolean alwaysAllowCommit = true;
    public boolean autoCommit = true;
    public boolean escapeProcess = true;
    public boolean batchNotOnCall = false;
    public int batchType = 1;
    public boolean batchContinueOnError = false;
    public int batchAllowMaxErrors = 0;
    public boolean dbmdChkPrv = true;
    public boolean isBdtaRS = false;
    public int resultSetType = 1003;
    public int maxRows = 0;
    public int bufPrefetch = 0;
    public int lobMode = 1;
    public int compatibleMode = 0;
    public String databaseProductName = "";
    public boolean clobAsString = false;
    public boolean ignoreCase = true;
    public int columnNameCase = 0;
    public String unixSocketFile;
    public String sslProtocol;
    public List serverOption = new ArrayList();
    public boolean markEnable = false;
    public String socketMark;
    public int bufferType = 0;
    public static AtomicLong IDGenerator = new AtomicLong(0L);
    public DmProperties props;
    public EPGroup epGroup;
    public EP ep;
    public boolean rwStandby = false;
    private Object abortMutex = new Object();
    private ILogger LOG = LogFactory.getLog(DmdbConnection.class);
    public volatile int switchToEpSeqno = -1;
    public a dbAccess;
    public boolean closed = true;
    public boolean pingResult = true;
    public boolean readOnly = false;
    public int resultSetHoldability = 1;
    public SQLWarning sqlWarning;
    public Map typeMap;
    public CacheQueue stmtPool;
    public List activeStmtList = new ArrayList();
    public CacheMap pstmtPool;
    public Executor closeExecutor;
    public int msgVersion = 6;
    public boolean lobOptimized;
    public boolean prepareOptimize = true;
    public static final SQLPermission ABORT_PERMISSION = new SQLPermission("abort");
    public static final SQLPermission SET_NETWORK_TIMEOUT_PERMISSION = new SQLPermission("setNetworkTimeout");
    public Map tempMap = new HashMap();

    @Override
    public long getID() {
        if (this.ID < 0L) {
            this.ID = IDGenerator.incrementAndGet();
        }
        return this.ID;
    }

    public void setAttributes(DmProperties dmProperties) {
        if (dmProperties == null || dmProperties.size() == 0) {
            return;
        }
        this.url = dmProperties.getTrimString(Configuration.url);
        this.host = dmProperties.getTrimString(Configuration.host);
        this.port = dmProperties.getInt(Configuration.port);
        this.user = dmProperties.getProperty(Configuration.user.getName(), (String)Configuration.user.getDefault());
        this.password = dmProperties.getProperty(Configuration.password.getName(), (String)Configuration.password.getDefault());
        this.rwStandby = dmProperties.getBoolean(Configuration.rwStandby);
        this.compress = dmProperties.getBoolean(Configuration.isCompress) ? 2 : 0;
        this.compress = dmProperties.getInt(Configuration.compress);
        this.compressID = (byte)dmProperties.getInt(Configuration.compressID);
        String string = dmProperties.getTrimString(Configuration.sessEncode);
        if (StringUtil.isNotEmpty(string) && !Charset.isSupported(string)) {
            this.sessEncode = null;
            this.LOG.warn(this, "setAttributes", "unsupported sessEncode:" + string);
        } else {
            this.sessEncode = string;
        }
        this.enRsCache = dmProperties.getBoolean(Configuration.enRsCache);
        this.localTimezone = (short)dmProperties.getInt(Configuration.localTimezone);
        this.rsCacheSize = dmProperties.getInt(Configuration.rsCacheSize);
        this.rsRefreshFreq = dmProperties.getInt(Configuration.rsRefreshFreq);
        this.loginEncrypt = dmProperties.getBoolean(Configuration.loginEncrypt);
        this.loginCertificate = dmProperties.getTrimString(Configuration.loginCertificate);
        this.rwSeparate = dmProperties.getInt(Configuration.rwSeparate);
        this.rwAutoDistribute = dmProperties.getBoolean(Configuration.rwAutoDistribute);
        this.rwPercent = dmProperties.getInt(Configuration.rwPercent);
        this.rwHA = dmProperties.getBoolean(Configuration.rwHA);
        this.rwStandbyRecoverTime = dmProperties.getInt(Configuration.rwStandbyRecoverTime);
        this.rwIgnoreSql = dmProperties.getBoolean(Configuration.rwIgnoreSql);
        this.cipherPath = dmProperties.getTrimString(Configuration.cipherPath);
        this.compatibleMode = Configuration.parseCompatibleMode(dmProperties);
        this.keyWords = dmProperties.getStringArray(Configuration.keyWords);
        this.appName = dmProperties.getTrimString(Configuration.appName);
        this.osName = dmProperties.getTrimString(Configuration.osName);
        this.mppLocal = dmProperties.getBoolean(Configuration.mppLocal);
        this.socketTimeout = dmProperties.getInt(Configuration.socketTimeout);
        this.keepAlive = dmProperties.getBoolean(Configuration.keepAlive);
        this.connectTimeout = dmProperties.getInt(Configuration.connectTimeout);
        this.sessionTimeout = dmProperties.getInt(Configuration.sessionTimeout);
        this.osAuthType = Configuration.parseOsAuthType(dmProperties);
        this.escapeProcess = dmProperties.getBoolean(Configuration.escapeProcess);
        this.autoCommit = dmProperties.getBoolean(Configuration.autoCommit);
        this.maxRows = dmProperties.getInt(Configuration.maxRows);
        this.bufPrefetch = dmProperties.getInt(Configuration.bufPrefetch);
        this.lobMode = dmProperties.getInt(Configuration.lobMode);
        this.stmtPoolSize = dmProperties.getInt(Configuration.stmtPoolSize);
        this.pstmtPoolSize = dmProperties.getInt(Configuration.pstmtPoolSize);
        this.pstmtPoolValidTime = dmProperties.getInt(Configuration.pstmtPoolValidTime);
        this.ignoreCase = dmProperties.getBoolean(Configuration.ignoreCase);
        this.alwaysAllowCommit = dmProperties.getBoolean(Configuration.alwaysAllowCommit);
        this.batchType = dmProperties.getInt(Configuration.batchType);
        this.batchContinueOnError = dmProperties.getBoolean(Configuration.batchContinueOnError);
        this.batchNotOnCall = dmProperties.getBoolean(Configuration.batchNotOnCall);
        this.batchAllowMaxErrors = dmProperties.getInt(Configuration.batchAllowMaxErrors);
        this.resultSetType = dmProperties.getInt(Configuration.resultSetType);
        this.dbmdChkPrv = dmProperties.getBoolean(Configuration.dbmdChkPrv);
        this.isBdtaRS = dmProperties.getBoolean(Configuration.isBdtaRS);
        this.clobAsString = dmProperties.getBoolean(Configuration.clobAsString);
        this.sslFilesPath = dmProperties.getTrimString(Configuration.sslFilesPath);
        this.sslKeystorePass = dmProperties.getTrimString(Configuration.sslKeystorePass);
        this.kerberosLoginConfPath = dmProperties.getTrimString(Configuration.kerberosLoginConfPath);
        this.uKeyName = dmProperties.getTrimString(Configuration.uKeyName);
        this.uKeyPin = dmProperties.getTrimString(Configuration.uKeyPin);
        this.columnNameCase = Configuration.parseColumnNameCase(dmProperties.getTrimString(Configuration.columnNameCase));
        this.databaseProductName = dmProperties.getTrimString(Configuration.databaseProductName);
        this.bufferType = dmProperties.getInt(Configuration.bufferType);
        this.epGroup = (EPGroup)dmProperties.getObject(Configuration.epGroup.getName());
        this.mppOpt = dmProperties.getInt(Configuration.mppOpt);
        this.unixSocketFile = dmProperties.getTrimString(Configuration.unixSocketFile);
        this.sslProtocol = dmProperties.getTrimString(Configuration.sslProtocol);
        if (StringUtil.isNotEmpty(dmProperties.getTrimString(Configuration.gwdsn))) {
            this.serverOption.add(String.valueOf(Configuration.gwdsn.getName()) + "=" + dmProperties.getTrimString(Configuration.gwdsn));
        }
        this.prepareOptimize = dmProperties.getBoolean(Configuration.prepareOptimize);
        this.markEnable = StringUtil.isNotEmpty(DmSvcConf.GLOBAL.markConf);
        if (this.user == null && this.osAuthType == 0) {
            this.user = "SYSDBA";
        } else if (this.osAuthType != 0 && StringUtil.isNotEmpty(this.user)) {
            DBError.ECJDBC_OSAUTH_ERROR.throwz(new Object[0]);
        } else if (this.osAuthType != 0) {
            this.user = System.getProperty("user.name", "");
            this.password = "";
        }
    }

    @Override
    public boolean compatibleOracle() {
        return this.compatibleMode == 1;
    }

    public boolean compatibleMysql() {
        return this.compatibleMode == 2;
    }

    public boolean isColumnNameUpperCase() {
        return this.columnNameCase == 1;
    }

    public boolean isColumnNameLowerCase() {
        return this.columnNameCase == 2;
    }

    @Override
    public boolean lobFetchAll() {
        return this.lobMode == 2;
    }

    public DmdbConnection(DmProperties dmProperties) {
        super(null, dmProperties);
        this.props = dmProperties;
        this.setAttributes(dmProperties);
        if (this.stmtPoolSize > 0) {
            this.stmtPool = new DmdbConnection$1(this, this.stmtPoolSize, false);
        }
        if (this.pstmtPoolSize > 0) {
            this.pstmtPool = new DmdbConnection$2(this, this.pstmtPoolSize);
        }
    }

    public void openConnection() {
        try {
            this.dbAccess = this.markEnable ? new c(this) : (StringUtil.isNotEmpty(this.unixSocketFile) && DriverUtil.isLocalHost(this.host) && DriverUtil.isUnix() ? new d(this, new File(this.unixSocketFile)) : (this.bufferType == 0 ? new a(this) : new b(this)));
            this.dbAccess.c();
            this.closed = false;
            this.do_setSchema(this.props.getProperty(Configuration.schema.getName()));
            this.resetClientInfo();
            DBAliveCheckThread.addConnection(this);
            if (this.epGroup != null) {
                this.epGroup.incrementSession(this);
            }
        }
        finally {
            if (this.closed) {
                this.free();
            }
        }
    }

    private void resetClientInfo() {
        this.props.setProperty("ApplicationName", this.appName);
        this.props.setProperty("ClientUser", this.user);
        this.props.setProperty("ClientHostname", this.host);
        this.props.setProperty("svrStat", String.valueOf(this.svrStat));
        this.props.setProperty("svrMode", String.valueOf(this.svrMode));
        this.props.setProperty("guid", this.guid);
        this.props.setProperty("dscControl", String.valueOf(this.dscControl));
    }

    public DmdbStatement do_createStatement() {
        return this.do_createStatement(this.resultSetType, 1007, this.resultSetHoldability);
    }

    public DmdbStatement do_createStatement(int n2, int n3) {
        return this.do_createStatement(n2, n3, this.resultSetHoldability);
    }

    public DmdbStatement do_createStatement(int n2, int n3, int n4) {
        this.checkClosed();
        DmdbStatement dmdbStatement = new DmdbStatement(this, n2, n3, n4, true);
        this.activeStmtList.add(dmdbStatement);
        return dmdbStatement;
    }

    public DmdbStatement createCursorStatement(int n2, int n3, int n4) {
        this.checkClosed();
        DmdbStatement dmdbStatement = new DmdbStatement(this, n2, n3, n4, false);
        this.activeStmtList.add(dmdbStatement);
        return dmdbStatement;
    }

    public DmdbPreparedStatement do_prepareStatement(String string) {
        return this.do_prepareStatement(string, this.resultSetType, 1007, this.resultSetHoldability);
    }

    public DmdbPreparedStatement do_prepareStatement(String string, int n2, int n3) {
        return this.do_prepareStatement(string, n2, n3, this.resultSetHoldability);
    }

    public DmdbPreparedStatement do_prepareStatement(String string, int n2, int n3, int n4) {
        this.checkClosed();
        DmdbPreparedStatement dmdbPreparedStatement = new DmdbPreparedStatement(this, string, n2, n3, n4, true);
        this.activeStmtList.add(dmdbPreparedStatement);
        return dmdbPreparedStatement;
    }

    public DmdbPreparedStatement do_prepareStatement(String string, int n2) {
        this.checkClosed();
        DmdbPreparedStatement dmdbPreparedStatement = new DmdbPreparedStatement(this, string, n2, true);
        this.activeStmtList.add(dmdbPreparedStatement);
        return dmdbPreparedStatement;
    }

    public DmdbPreparedStatement do_prepareStatement(String string, int[] nArray) {
        this.checkClosed();
        DmdbPreparedStatement dmdbPreparedStatement = new DmdbPreparedStatement(this, string, nArray, true);
        this.activeStmtList.add(dmdbPreparedStatement);
        return dmdbPreparedStatement;
    }

    public DmdbPreparedStatement do_prepareStatement(String string, String[] stringArray) {
        Object object;
        if (this.msgVersion >= 3) {
            this.checkClosed();
            DmdbPreparedStatement dmdbPreparedStatement = new DmdbPreparedStatement(this, string, stringArray, true);
            this.activeStmtList.add(dmdbPreparedStatement);
            return dmdbPreparedStatement;
        }
        if (stringArray != null && stringArray.length > 0) {
            String string2;
            object = null;
            try {
                object = SQLProcessor.lexSkipWhitespace(string, 2);
            }
            catch (Throwable throwable) {}
            int n2 = object == null ? 0 : object.size();
            String string3 = n2 > 0 ? ((LVal)object.get((int)0)).value : null;
            String string4 = string2 = n2 > 1 ? ((LVal)object.get((int)1)).value : null;
            if (StringUtil.equalsIgnoreCase("update", string3) || StringUtil.equals("delete", string3) || StringUtil.equalsIgnoreCase("insert", string3) && StringUtil.equalsIgnoreCase("into", string2)) {
                StringBuilder stringBuilder = new StringBuilder(256);
                stringBuilder.append(string);
                while (stringBuilder.charAt(stringBuilder.length() - 1) == ';') {
                    stringBuilder.deleteCharAt(stringBuilder.length() - 1);
                }
                stringBuilder.append(" return ");
                stringBuilder.append(StringUtil.join(stringArray, ", "));
                stringBuilder.append(" into ");
                stringBuilder.append(StringUtil.join("?", stringArray.length, ", "));
                string = stringBuilder.toString();
            }
        }
        object = this.do_prepareStatement(string, stringArray != null && stringArray.length > 0 ? 1 : 2);
        ((DmdbPreparedStatement)object).generateKeyColumnNames = stringArray;
        return object;
    }

    public DmdbCallableStatement do_prepareCall(String string) {
        return this.do_prepareCall(string, 1003, 1007, this.resultSetHoldability);
    }

    public DmdbCallableStatement do_prepareCall(String string, int n2, int n3) {
        return this.do_prepareCall(string, n2, n3, this.resultSetHoldability);
    }

    public DmdbCallableStatement do_prepareCall(String string, int n2, int n3, int n4) {
        this.checkClosed();
        DmdbCallableStatement dmdbCallableStatement = new DmdbCallableStatement(this, string, n2, n3, n4, true);
        this.activeStmtList.add(dmdbCallableStatement);
        return dmdbCallableStatement;
    }

    public String do_nativeSQL(String string) {
        try {
            return SQLProcessor.escape(string, this.keyWords);
        }
        catch (IOException iOException) {
            DBError.ECJDBC_SQL_ESCAPE_FAILED.throwException(iOException);
            return string;
        }
    }

    public void do_commit() {
        this.checkClosed();
        if (!this.autoCommit) {
            this.dbAccess.commit();
            this.trxFinish = true;
        } else if (!this.alwaysAllowCommit) {
            DBError.ECJDBC_COMMIT_IN_AUTOCOMMIT_MODE.throwz(new Object[0]);
        }
    }

    public void do_rollback() {
        this.checkClosed();
        if (!this.autoCommit) {
            this.dbAccess.rollback();
            this.trxFinish = true;
        } else if (!this.alwaysAllowCommit) {
            DBError.ECJDBC_ROLLBACK_IN_AUTOCOMMIT_MODE.throwz(new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void free() {
        Object object = this.abortMutex;
        synchronized (object) {
            if (!this.closed && this.epGroup != null) {
                this.epGroup.decrementSession(this);
            }
            if (this.dbAccess != null) {
                this.dbAccess.close();
            }
            this.closed = true;
            if (this.activeStmtList != null) {
                for (DmdbStatement dmdbStatement : this.activeStmtList) {
                    dmdbStatement.free();
                }
            }
            if (this.stmtPool != null) {
                this.stmtPool.clear();
            }
            if (this.pstmtPool != null) {
                this.pstmtPool.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void do_close() {
        Object object = this.abortMutex;
        synchronized (object) {
            try {
                if (this.compatibleOracle() && !this.closed) {
                    this.do_commit();
                }
            }
            catch (Exception exception) {}
            this.free();
            if (this.activeStmtList != null) {
                this.activeStmtList.clear();
            }
            this.closed = true;
        }
    }

    public void checkClosed() {
        if (this.closed) {
            DBError.ECJDBC_CONNECTION_CLOSED.throwz(new Object[0]);
        }
    }

    public DmdbDatabaseMetaData do_getMetaData() {
        this.checkClosed();
        return new DmdbDatabaseMetaData(this);
    }

    public void do_setTransactionIsolation(int n2) {
        this.checkClosed();
        switch (n2) {
            case 0: 
            case 1: {
                break;
            }
            case 2: 
            case 8: {
                this.dbAccess.setTransactionIsolation(n2);
                this.isoLevel = n2;
                break;
            }
            case 4: {
                if (!this.compatibleMysql()) break;
                n2 = 2;
                this.dbAccess.setTransactionIsolation(n2);
                this.isoLevel = n2;
                break;
            }
            default: {
                DBError.ECJDBC_INVALID_TRAN_ISOLATION.throwz(new Object[0]);
            }
        }
    }

    public void addSQLWarning(SQLWarning sQLWarning) {
        if (this.sqlWarning == sQLWarning) {
            return;
        }
        if (this.sqlWarning == null) {
            this.sqlWarning = sQLWarning;
        } else {
            this.sqlWarning.setNextWarning(sQLWarning);
        }
    }

    public void do_clearWarnings() {
        this.sqlWarning = null;
    }

    public DmdbSavepoint do_setSavepoint() {
        return this.do_setSavepoint(null);
    }

    public DmdbSavepoint do_setSavepoint(String string) {
        this.checkClosed();
        if (this.autoCommit) {
            DBError.ECJDBC_SAVEPOINT_IN_AUTOCOMMIT_MODE.throwz(new Object[0]);
        }
        return new DmdbSavepoint(this, string);
    }

    public void do_rollback(Savepoint savepoint) {
        this.checkClosed();
        if (savepoint == null) {
            DBError.ECJDBC_INVALID_SAVEPOINT.throwz(new Object[0]);
        }
        if (this.autoCommit && !this.alwaysAllowCommit) {
            DBError.ECJDBC_ROLLBACK_TO_SAVEPOINT_IN_AUTOCOMMIT_MODE.throwz(new Object[0]);
        }
        DmdbSavepoint dmdbSavepoint = (DmdbSavepoint)savepoint;
        if (dmdbSavepoint.released) {
            DBError.ECJDBC_SAVEPOINT_RELEASED.throwz(new Object[0]);
        }
        String string = "ROLLBACK TO SAVEPOINT \"" + StringUtil.processDoubleQuoteOfName(dmdbSavepoint.name) + "\"";
        DriverUtil.execute(this, string);
    }

    public void do_releaseSavepoint(Savepoint savepoint) {
        this.checkClosed();
        if (savepoint == null) {
            DBError.ECJDBC_INVALID_SAVEPOINT.throwz(new Object[0]);
        }
        if (this.autoCommit && !this.alwaysAllowCommit) {
            DBError.ECJDBC_RELEASE_SAVEPOINT_IN_AUTOCOMMIT_MODE.throwz(new Object[0]);
        }
        ((DmdbSavepoint)savepoint).release();
    }

    public DmdbClob do_createClob() {
        this.checkClosed();
        return DmdbClob.newInstance("", this);
    }

    public DmdbBlob do_createBlob() {
        this.checkClosed();
        return DmdbBlob.newInstanceOfLocal(new byte[0], this);
    }

    public boolean do_isValid(int n2) {
        if (this.do_isClosed()) {
            return false;
        }
        if (n2 <= 0) {
            try {
                DriverUtil.execute(this, "select 1 from dual");
                this.pingResult = true;
            }
            catch (Throwable throwable) {
                this.pingResult = false;
            }
        } else {
            try {
                Thread thread = new Thread(new DmdbConnection$3(this));
                thread.start();
                thread.join(n2 * 1000);
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.pingResult;
    }

    public void do_setClientInfo(String string, Object object) {
        this.props.setObject(string, object);
    }

    public void do_setClientInfo(Properties properties) {
        this.props.setProperties(properties);
    }

    public String do_getClientInfo(String string) {
        return this.props.getProperty(string);
    }

    public Properties do_getClientInfo() {
        return this.props.getProperties();
    }

    public DmdbArray do_createArrayOf(String string, Object[] objectArray) {
        this.checkClosed();
        ArrayDescriptor arrayDescriptor = new ArrayDescriptor(string, this);
        return new DmdbArray(arrayDescriptor, this, objectArray);
    }

    public DmdbStruct do_createStruct(String string, Object[] objectArray) {
        this.checkClosed();
        StructDescriptor structDescriptor = new StructDescriptor(string, this);
        return new DmdbStruct(structDescriptor, this, objectArray);
    }

    public void do_setAutoCommit(boolean bl) {
        this.autoCommit = bl;
    }

    public boolean do_getAutoCommit() {
        return this.autoCommit;
    }

    public boolean do_isClosed() {
        return this.closed;
    }

    public void do_setReadOnly(boolean bl) {
        this.readOnly = bl;
        if (this.compatibleOracle()) {
            return;
        }
        DriverUtil.execute(this, "SP_SET_SESSION_READONLY (" + (bl ? 1 : 0) + ")");
    }

    public boolean do_isReadOnly() {
        return this.readOnly;
    }

    public void do_setCatalog(String string) {
    }

    public String do_getCatalog() {
        return null;
    }

    public int do_getTransactionIsolation() {
        return this.isoLevel;
    }

    public SQLWarning do_getWarnings() {
        return this.sqlWarning;
    }

    public Map do_getTypeMap() {
        return this.typeMap;
    }

    public void do_setTypeMap(Map map) {
        this.typeMap = map;
    }

    public void do_setHoldability(int n2) {
        this.resultSetHoldability = n2;
    }

    public int do_getHoldability() {
        return this.resultSetHoldability;
    }

    public NClob do_createNClob() {
        this.checkClosed();
        return DmdbNClob.newInstance("", this);
    }

    public SQLXML do_createSQLXML() {
        return new DmdbSQLXML();
    }

    public void do_setSchema(String string) {
        if (StringUtil.isNotEmpty(string) && !StringUtil.equals(string, this.schema)) {
            DriverUtil.execute(this, "set schema " + string);
        }
    }

    public String do_getSchema() {
        return this.schema;
    }

    public void do_abort(Executor executor) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(ABORT_PERMISSION);
        }
        if (executor == null) {
            this.free();
            return;
        }
        executor.execute(new DmdbConnection$4(this));
    }

    public void do_setNetworkTimeout(Executor executor, int n2) {
        this.checkClosed();
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SET_NETWORK_TIMEOUT_PERMISSION);
        }
        this.dbAccess.a(n2);
        this.socketTimeout = n2;
        this.closeExecutor = executor;
    }

    public int do_getNetworkTimeout() {
        return this.socketTimeout;
    }

    public void setTrxFinish(int n2) {
        switch (n2 & 0xFFF) {
            case 0: 
            case 32: 
            case 64: {
                this.trxFinish = true;
                break;
            }
            default: {
                this.trxFinish = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Statement createStatement() {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_createStatement();
            }
            return this.filterChain.reset().Connection_createStatement(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreparedStatement prepareStatement(String string) {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_prepareStatement(string);
            }
            return this.filterChain.reset().Connection_prepareStatement(this, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CallableStatement prepareCall(String string) {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_prepareCall(string);
            }
            return this.filterChain.reset().Connection_prepareCall(this, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String nativeSQL(String string) {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_nativeSQL(string);
            }
            return this.filterChain.reset().Connection_nativeSQL(this, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAutoCommit(boolean bl) {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_setAutoCommit(bl);
            } else {
                this.filterChain.reset().Connection_setAutoCommit(this, bl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getAutoCommit() {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getAutoCommit();
            }
            return this.filterChain.reset().Connection_getAutoCommit(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_commit();
            } else {
                this.filterChain.reset().Connection_commit(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_rollback();
            } else {
                this.filterChain.reset().Connection_rollback(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_close();
            } else {
                this.filterChain.reset().Connection_close(this);
            }
        }
    }

    @Override
    public boolean isClosed() {
        if (this.filterChain == null) {
            return this.do_isClosed();
        }
        return this.filterChain.reset().Connection_isClosed(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DatabaseMetaData getMetaData() {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getMetaData();
            }
            return this.filterChain.reset().Connection_getMetaData(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setReadOnly(boolean bl) {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_setReadOnly(bl);
            } else {
                this.filterChain.reset().Connection_setReadOnly(this, bl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isReadOnly() {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_isReadOnly();
            }
            return this.filterChain.reset().Connection_isReadOnly(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCatalog(String string) {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_setCatalog(string);
            } else {
                this.filterChain.reset().Connection_setCatalog(this, string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCatalog() {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getCatalog();
            }
            return this.filterChain.reset().Connection_getCatalog(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTransactionIsolation(int n2) {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_setTransactionIsolation(n2);
            } else {
                this.filterChain.reset().Connection_setTransactionIsolation(this, n2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTransactionIsolation() {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getTransactionIsolation();
            }
            return this.filterChain.reset().Connection_getTransactionIsolation(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SQLWarning getWarnings() {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getWarnings();
            }
            return this.filterChain.reset().Connection_getWarnings(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearWarnings() {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_clearWarnings();
            } else {
                this.filterChain.reset().Connection_clearWarnings(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Statement createStatement(int n2, int n3) {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_createStatement(n2, n3);
            }
            return this.filterChain.reset().Connection_createStatement(this, n2, n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreparedStatement prepareStatement(String string, int n2, int n3) {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_prepareStatement(string, n2, n3);
            }
            return this.filterChain.reset().Connection_prepareStatement(this, string, n2, n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CallableStatement prepareCall(String string, int n2, int n3) {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_prepareCall(string, n2, n3);
            }
            return this.filterChain.reset().Connection_prepareCall(this, string, n2, n3);
        }
    }

    public Map getTypeMap() {
        if (this.filterChain == null) {
            return this.do_getTypeMap();
        }
        return this.filterChain.reset().Connection_getTypeMap(this);
    }

    public void setTypeMap(Map map) {
        if (this.filterChain == null) {
            this.do_setTypeMap(map);
        } else {
            this.filterChain.reset().Connection_setTypeMap(this, map);
        }
    }

    @Override
    public void setHoldability(int n2) {
        if (this.filterChain == null) {
            this.do_setHoldability(n2);
        } else {
            this.filterChain.reset().Connection_setHoldability(this, n2);
        }
    }

    @Override
    public int getHoldability() {
        if (this.filterChain == null) {
            return this.do_getHoldability();
        }
        return this.filterChain.reset().Connection_getHoldability(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Savepoint setSavepoint() {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_setSavepoint();
            }
            return this.filterChain.reset().Connection_setSavepoint(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Savepoint setSavepoint(String string) {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_setSavepoint(string);
            }
            return this.filterChain.reset().Connection_setSavepoint(this, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(Savepoint savepoint) {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_rollback(savepoint);
            } else {
                this.filterChain.reset().Connection_rollback(this, savepoint);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseSavepoint(Savepoint savepoint) {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_releaseSavepoint(savepoint);
            } else {
                this.filterChain.reset().Connection_releaseSavepoint(this, savepoint);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Statement createStatement(int n2, int n3, int n4) {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_createStatement(n2, n3, n4);
            }
            return this.filterChain.reset().Connection_createStatement(this, n2, n3, n4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreparedStatement prepareStatement(String string, int n2, int n3, int n4) {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_prepareStatement(string, n2, n3, n4);
            }
            return this.filterChain.reset().Connection_prepareStatement(this, string, n2, n3, n4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CallableStatement prepareCall(String string, int n2, int n3, int n4) {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_prepareCall(string, n2, n3, n4);
            }
            return this.filterChain.reset().Connection_prepareCall(this, string, n2, n3, n4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreparedStatement prepareStatement(String string, int n2) {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_prepareStatement(string, n2);
            }
            return this.filterChain.reset().Connection_prepareStatement(this, string, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreparedStatement prepareStatement(String string, int[] nArray) {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_prepareStatement(string, nArray);
            }
            return this.filterChain.reset().Connection_prepareStatement(this, string, nArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreparedStatement prepareStatement(String string, String[] stringArray) {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_prepareStatement(string, stringArray);
            }
            return this.filterChain.reset().Connection_prepareStatement(this, string, stringArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Clob createClob() {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_createClob();
            }
            return this.filterChain.reset().Connection_createClob(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Blob createBlob() {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_createBlob();
            }
            return this.filterChain.reset().Connection_createBlob(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NClob createNClob() {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_createNClob();
            }
            return this.filterChain.reset().Connection_createNClob(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SQLXML createSQLXML() {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_createSQLXML();
            }
            return this.filterChain.reset().Connection_createSQLXML(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValid(int n2) {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_isValid(n2);
            }
            return this.filterChain.reset().Connection_isValid(this, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setClientInfo(String string, String string2) {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_setClientInfo(string, string2);
            } else {
                this.filterChain.reset().Connection_setClientInfo(this, string, string2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setClientInfo(Properties properties) {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_setClientInfo(properties);
            } else {
                this.filterChain.reset().Connection_setClientInfo(this, properties);
            }
        }
    }

    @Override
    public String getClientInfo(String string) {
        if (this.filterChain == null) {
            return this.do_getClientInfo(string);
        }
        return this.filterChain.reset().Connection_getClientInfo(this, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties getClientInfo() {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getClientInfo();
            }
            return this.filterChain.reset().Connection_getClientInfo(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Array createArrayOf(String string, Object[] objectArray) {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_createArrayOf(string, objectArray);
            }
            return this.filterChain.reset().Connection_createArrayOf(this, string, objectArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Struct createStruct(String string, Object[] objectArray) {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_createStruct(string, objectArray);
            }
            return this.filterChain.reset().Connection_createStruct(this, string, objectArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSchema(String string) {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_setSchema(string);
            } else {
                this.filterChain.reset().Connection_setSchema(this, string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSchema() {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getSchema();
            }
            return this.filterChain.reset().Connection_getSchema(this);
        }
    }

    @Override
    public void abort(Executor executor) {
        if (this.filterChain == null) {
            this.do_abort(executor);
        } else {
            this.filterChain.reset().Connection_abort(this, executor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNetworkTimeout(Executor executor, int n2) {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_setNetworkTimeout(executor, n2);
            } else {
                this.filterChain.reset().Connection_setNetworkTimeout(this, executor, n2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNetworkTimeout() {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getNetworkTimeout();
            }
            return this.filterChain.reset().Connection_getNetworkTimeout(this);
        }
    }

    public Object unwrap(Class clazz) {
        return clazz.cast(this);
    }

    public boolean isWrapperFor(Class clazz) {
        return clazz.isInstance(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSessionTrace(String string) {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            return DriverUtil.executeAndGetExplain(this, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getExplainInfo(String string) {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (StringUtil.isEmpty(string)) {
                DBError.ECJDBC_SQL_IS_EMPTY.throwz(new Object[0]);
            }
            if (!string.equalsIgnoreCase("show_pln_stat")) {
                string = "EXPLAIN " + string;
            }
            return DriverUtil.executeAndGetExplain(this, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void do_reconnect() {
        this.free();
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.epGroup != null && this.switchToEpSeqno >= 0) {
                this.epGroup.connect(this, this.switchToEpSeqno);
            } else if (this.epGroup != null) {
                this.epGroup.connect(this);
            } else {
                this.openConnection();
            }
            ArrayList<DmdbStatement> arrayList = new ArrayList<DmdbStatement>(this.activeStmtList.size());
            for (DmdbStatement dmdbStatement : this.activeStmtList) {
                try {
                    dmdbStatement.reconnect(false);
                }
                catch (Throwable throwable) {
                    dmdbStatement.poolable = false;
                    arrayList.add(dmdbStatement);
                }
            }
            for (DmdbStatement dmdbStatement : arrayList) {
                try {
                    dmdbStatement.do_close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public void reconnect(String string, String string2) {
        this.user = string;
        this.password = string2;
        this.reconnect();
    }

    public void reconnect() {
        FilterChain filterChain = this.createFilterChain(this, this.props);
        if (filterChain == null) {
            this.do_reconnect();
        } else {
            filterChain.reset().Connection_reconnect(this);
        }
    }

    public short getDBTimeZone() {
        return this.dbTimezone;
    }

    public String getHostName() {
        return this.host;
    }

    public int getHostPort() {
        return this.port;
    }

    public boolean getTransFinish() {
        return this.trxFinish;
    }

    public String getLastLoginIP() {
        return (String)this.nonStandardInterface("lastLoginIP");
    }

    public String getLastLoginTime() {
        return (String)this.nonStandardInterface("lastLoginTime");
    }

    public int getLoginWarningID() {
        return (Integer)this.nonStandardInterface("loginWarningID");
    }

    public int getGraceTimeRemainder() {
        return (Integer)this.nonStandardInterface("GraceTimeRemainder");
    }

    public int getFailedAttempt() {
        return (Integer)this.nonStandardInterface("failedAttempts");
    }

    public boolean getNetworkEncypted() {
        return this.sslEncrypt == 1;
    }

    public int getNetworkPacketSize() {
        return this.dbAccess != null ? this.dbAccess.m : 0;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getLanguage() {
        return DmSvcConf.GLOBAL.getLanguage();
    }

    public boolean getBackslashEsc() {
        return (Boolean)this.nonStandardInterface("backslashEscape");
    }

    public int getGlobalServerSeries() {
        return (Integer)this.nonStandardInterface("globalServerSeries");
    }

    public int getEncryptMsg() {
        return this.sslEncrypt;
    }

    public boolean getEscape() {
        return this.escapeProcess;
    }

    public void setEscape(boolean bl) {
        this.escapeProcess = bl;
    }

    public void setEscape(Boolean bl) {
        this.escapeProcess = bl;
    }

    public void setDbmdChkPrivileges(boolean bl) {
        this.dbmdChkPrv = bl;
    }

    public boolean getDbmdChkPrivileges() {
        return this.dbmdChkPrv;
    }

    public void reset() {
        this.reconnect();
    }

    public void do_reset() {
        this.checkClosed();
        if (this.sessionID != -1L) {
            DriverUtil.executeWithNewConnection(this, "SP_CANCEL_SESSION_OPERATION(" + this.sessionID + ")");
        }
    }

    @Override
    public String getServerEncoding() {
        if (StringUtil.isNotEmpty(this.sessEncode)) {
            return this.sessEncode;
        }
        return this.serverEncoding;
    }

    @Override
    public void setServerEncoding(String string) {
        this.serverEncoding = string;
    }

    public Object nonStandardInterface(String string) {
        if (string == null) {
            return null;
        }
        return this.props.getObject(string.toLowerCase());
    }

    public boolean isMppFldrInsertEnable() {
        return (this.mppOpt & 1) != 0;
    }

    public boolean isMppFldrSelectEnable() {
        return (this.mppOpt & 2) != 0;
    }

    public void setMark(String string) {
        if (StringUtil.isEmpty(string)) {
            this.socketMark = null;
            return;
        }
        byte[] byArray = string.getBytes();
        if (this.dbAccess instanceof c && MarkDll.checkMark(((c)this.dbAccess).u, byArray, byArray.length) < 0) {
            DBError.ECJDBC_INVALID_SOCKET_MARK.throwz(string);
        }
        this.socketMark = string;
    }

    @Override
    public boolean getIgnoreCase() {
        return !this.caseSensitive || this.ignoreCase;
    }

    @Override
    public boolean getRwStandby() {
        return this.rwStandby;
    }

    @Override
    public int getNewLobFlag() {
        return this.newLobFlag;
    }

    @Override
    public void setNewLobFlag(int n2) {
        this.newLobFlag = n2;
    }

    @Override
    public short getLocalTimezone() {
        return this.localTimezone;
    }

    @Override
    public short getDBTimezone() {
        return this.dbTimezone;
    }

    @Override
    public boolean getClobAsString() {
        return this.clobAsString;
    }

    @Override
    public int getDateLanguage() {
        return this.oracleDateLanguage;
    }

    @Override
    public String getFormat(int n2) {
        switch (n2) {
            case 14: {
                return this.formatDate;
            }
            case 15: {
                return this.formatTime;
            }
            case 22: {
                return this.formatTimeTZ;
            }
            case 16: {
                return this.formatTimestamp;
            }
            case 23: {
                return this.formatTimestampTZ;
            }
        }
        return "";
    }

    @Override
    public String getGuid() {
        return this.guid;
    }

    @Override
    public boolean isDscControl() {
        return this.dscControl;
    }

    @Override
    public int getServerStatus() {
        return this.svrStat;
    }

    @Override
    public int getServerMode() {
        return this.svrMode;
    }
}

