/*
 * Decompiled with CFR 0.152.
 */
package com.dampcake.bencode;

import com.dampcake.bencode.Bencode;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class BencodeOutputStream
extends FilterOutputStream {
    private final Charset charset;

    public BencodeOutputStream(OutputStream out, Charset charset) {
        super(out);
        if (charset == null) {
            throw new NullPointerException("charset cannot be null");
        }
        this.charset = charset;
    }

    public BencodeOutputStream(OutputStream out) {
        this(out, Bencode.DEFAULT_CHARSET);
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void writeString(String s) throws IOException {
        this.write(this.encode(s));
    }

    public void writeString(ByteBuffer buff) throws IOException {
        this.write(this.encode(buff.array()));
    }

    public void writeNumber(Number n) throws IOException {
        this.write(this.encode(n));
    }

    public void writeList(Iterable<?> l) throws IOException {
        this.write(this.encode(l));
    }

    public void writeDictionary(Map<?, ?> m) throws IOException {
        this.write(this.encode(m));
    }

    private byte[] encode(String s) throws IOException {
        if (s == null) {
            throw new NullPointerException("s cannot be null");
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] bytes = s.getBytes(this.charset);
        buffer.write(Integer.toString(bytes.length).getBytes(this.charset));
        buffer.write(58);
        buffer.write(bytes);
        return buffer.toByteArray();
    }

    private byte[] encode(byte[] b) throws IOException {
        if (b == null) {
            throw new NullPointerException("b cannot be null");
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        buffer.write(Integer.toString(b.length).getBytes(this.charset));
        buffer.write(58);
        buffer.write(b);
        return buffer.toByteArray();
    }

    private byte[] encode(Number n) throws IOException {
        if (n == null) {
            throw new NullPointerException("n cannot be null");
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        buffer.write(105);
        buffer.write(Long.toString(n.longValue()).getBytes(this.charset));
        buffer.write(101);
        return buffer.toByteArray();
    }

    private byte[] encode(Iterable<?> l) throws IOException {
        if (l == null) {
            throw new NullPointerException("l cannot be null");
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        buffer.write(108);
        for (Object o : l) {
            buffer.write(this.encodeObject(o));
        }
        buffer.write(101);
        return buffer.toByteArray();
    }

    private byte[] encode(Map<?, ?> m) throws IOException {
        if (m == null) {
            throw new NullPointerException("m cannot be null");
        }
        Map<?, ?> map = !(m instanceof SortedMap) ? new TreeMap(m) : m;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        buffer.write(100);
        for (Map.Entry<?, ?> e : map.entrySet()) {
            buffer.write(this.encode(e.getKey().toString()));
            buffer.write(this.encodeObject(e.getValue()));
        }
        buffer.write(101);
        return buffer.toByteArray();
    }

    private byte[] encodeObject(Object o) throws IOException {
        if (o == null) {
            throw new NullPointerException("Cannot write null objects");
        }
        if (o instanceof Number) {
            return this.encode((Number)o);
        }
        if (o instanceof Iterable) {
            return this.encode((Iterable)o);
        }
        if (o instanceof Map) {
            return this.encode((Map)o);
        }
        if (o instanceof ByteBuffer) {
            return this.encode(((ByteBuffer)o).array());
        }
        return this.encode(o.toString());
    }
}

