/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.api.rule;

import com.google.common.base.Splitter;
import java.beans.ConstructorProperties;
import java.util.List;

public class DataNode {
    private static final String DELIMITER = ".";
    private final String dataSourceName;
    private final String tableName;

    public DataNode(String dataNode) {
        List segments = Splitter.on((String)DELIMITER).splitToList((CharSequence)dataNode);
        this.dataSourceName = (String)segments.get(0);
        this.tableName = (String)segments.get(1);
    }

    public static boolean isValidDataNode(String dataNodeStr) {
        return dataNodeStr.contains(DELIMITER) && 2 == Splitter.on((String)DELIMITER).splitToList((CharSequence)dataNodeStr).size();
    }

    @ConstructorProperties(value={"dataSourceName", "tableName"})
    public DataNode(String dataSourceName, String tableName) {
        this.dataSourceName = dataSourceName;
        this.tableName = tableName;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataNode)) {
            return false;
        }
        DataNode other = (DataNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$dataSourceName = this.getDataSourceName();
        String other$dataSourceName = other.getDataSourceName();
        if (this$dataSourceName == null ? other$dataSourceName != null : !this$dataSourceName.equals(other$dataSourceName)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        return !(this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataNode;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $dataSourceName = this.getDataSourceName();
        result = result * 59 + ($dataSourceName == null ? 0 : $dataSourceName.hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 0 : $tableName.hashCode());
        return result;
    }

    public String toString() {
        return "DataNode(dataSourceName=" + this.getDataSourceName() + ", tableName=" + this.getTableName() + ")";
    }
}

