/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.jdbc;

import com.dangdang.ddframe.rdb.sharding.executor.StatementExecutor;
import com.dangdang.ddframe.rdb.sharding.executor.wrapper.StatementExecutorWrapper;
import com.dangdang.ddframe.rdb.sharding.jdbc.ShardingConnection;
import com.dangdang.ddframe.rdb.sharding.jdbc.adapter.AbstractStatementAdapter;
import com.dangdang.ddframe.rdb.sharding.merger.ResultSetFactory;
import com.dangdang.ddframe.rdb.sharding.parser.result.merger.MergeContext;
import com.dangdang.ddframe.rdb.sharding.router.SQLExecutionUnit;
import com.dangdang.ddframe.rdb.sharding.router.SQLRouteResult;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ShardingStatement
extends AbstractStatementAdapter {
    private final ShardingConnection shardingConnection;
    private final int resultSetType;
    private final int resultSetConcurrency;
    private final int resultSetHoldability;
    private final Deque<List<Statement>> cachedRoutedStatements = Lists.newLinkedList();
    private MergeContext mergeContext;
    private ResultSet currentResultSet;

    ShardingStatement(ShardingConnection shardingConnection) {
        this(shardingConnection, 1003, 1007, 1);
    }

    ShardingStatement(ShardingConnection shardingConnection, int resultSetType, int resultSetConcurrency) {
        this(shardingConnection, resultSetType, resultSetConcurrency, 1);
    }

    public ShardingStatement(ShardingConnection shardingConnection, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        super(Statement.class);
        this.shardingConnection = shardingConnection;
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
        this.resultSetHoldability = resultSetHoldability;
        this.cachedRoutedStatements.add(new LinkedList());
        this.cachedRoutedStatements.add(new LinkedList());
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.shardingConnection;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        ResultSet rs;
        try {
            rs = ResultSetFactory.getResultSet(this.generateExecutor(sql).executeQuery(), this.mergeContext);
        }
        finally {
            this.clearRouteContext();
        }
        this.setCurrentResultSet(rs);
        return rs;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        try {
            int n = this.generateExecutor(sql).executeUpdate();
            return n;
        }
        finally {
            this.clearRouteContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            int n = this.generateExecutor(sql).executeUpdate(autoGeneratedKeys);
            return n;
        }
        finally {
            this.clearRouteContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        try {
            int n = this.generateExecutor(sql).executeUpdate(columnIndexes);
            return n;
        }
        finally {
            this.clearRouteContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        try {
            int n = this.generateExecutor(sql).executeUpdate(columnNames);
            return n;
        }
        finally {
            this.clearRouteContext();
        }
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        try {
            boolean bl = this.generateExecutor(sql).execute();
            return bl;
        }
        finally {
            this.clearRouteContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            boolean bl = this.generateExecutor(sql).execute(autoGeneratedKeys);
            return bl;
        }
        finally {
            this.clearRouteContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        try {
            boolean bl = this.generateExecutor(sql).execute(columnIndexes);
            return bl;
        }
        finally {
            this.clearRouteContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        try {
            boolean bl = this.generateExecutor(sql).execute(columnNames);
            return bl;
        }
        finally {
            this.clearRouteContext();
        }
    }

    protected void clearRouteContext() throws SQLException {
        this.setCurrentResultSet(null);
        List<Statement> firstList = this.cachedRoutedStatements.pollFirst();
        this.cachedRoutedStatements.getFirst().addAll(firstList);
        firstList.clear();
        this.cachedRoutedStatements.addLast(firstList);
    }

    private StatementExecutor generateExecutor(String sql) throws SQLException {
        StatementExecutor result = new StatementExecutor(this.shardingConnection.getShardingContext().getExecutorEngine());
        SQLRouteResult sqlRouteResult = this.shardingConnection.getShardingContext().getSqlRouteEngine().route(sql);
        this.mergeContext = sqlRouteResult.getMergeContext();
        for (SQLExecutionUnit each : sqlRouteResult.getExecutionUnits()) {
            Statement statement = this.getStatement(this.shardingConnection.getConnection(each.getDataSource(), sqlRouteResult.getSqlStatementType()), each.getSql());
            this.replayMethodsInvocation(statement);
            result.addStatement(new StatementExecutorWrapper(statement, each));
        }
        return result;
    }

    protected Statement getStatement(Connection connection, String sql) throws SQLException {
        Statement statement = null;
        Iterator<Statement> iterator = this.cachedRoutedStatements.getFirst().iterator();
        while (iterator.hasNext()) {
            Statement each = iterator.next();
            if (each.getConnection() != connection) continue;
            statement = each;
            iterator.remove();
        }
        if (null == statement) {
            statement = this.generateStatement(connection, sql);
        }
        this.cachedRoutedStatements.getLast().add(statement);
        return statement;
    }

    protected Statement generateStatement(Connection connection, String sql) throws SQLException {
        Statement result = 0 == this.resultSetHoldability ? connection.createStatement(this.resultSetType, this.resultSetConcurrency) : connection.createStatement(this.resultSetType, this.resultSetConcurrency, this.resultSetHoldability);
        return result;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        if (null != this.currentResultSet) {
            return this.currentResultSet;
        }
        ArrayList<ResultSet> resultSets = new ArrayList<ResultSet>(this.getRoutedStatements().size());
        if (this.getRoutedStatements().size() == 1) {
            this.currentResultSet = this.getRoutedStatements().iterator().next().getResultSet();
            return this.currentResultSet;
        }
        for (Statement statement : this.getRoutedStatements()) {
            resultSets.add(statement.getResultSet());
        }
        this.currentResultSet = ResultSetFactory.getResultSet(resultSets, this.mergeContext);
        return this.currentResultSet;
    }

    @Override
    protected void clearRouteStatements() {
        this.cachedRoutedStatements.getFirst().clear();
        this.cachedRoutedStatements.getLast().clear();
    }

    @Override
    public Collection<? extends Statement> getRoutedStatements() {
        return Lists.newArrayList((Iterator)Iterators.concat(this.cachedRoutedStatements.getFirst().iterator(), this.cachedRoutedStatements.getLast().iterator()));
    }

    protected ShardingConnection getShardingConnection() {
        return this.shardingConnection;
    }

    @Override
    public int getResultSetType() {
        return this.resultSetType;
    }

    @Override
    public int getResultSetConcurrency() {
        return this.resultSetConcurrency;
    }

    @Override
    public int getResultSetHoldability() {
        return this.resultSetHoldability;
    }

    protected MergeContext getMergeContext() {
        return this.mergeContext;
    }

    protected void setMergeContext(MergeContext mergeContext) {
        this.mergeContext = mergeContext;
    }

    protected void setCurrentResultSet(ResultSet currentResultSet) {
        this.currentResultSet = currentResultSet;
    }
}

