/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.parser;

import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import com.alibaba.druid.sql.dialect.db2.parser.DB2StatementParser;
import com.alibaba.druid.sql.dialect.mysql.parser.MySqlStatementParser;
import com.alibaba.druid.sql.dialect.oracle.parser.OracleStatementParser;
import com.alibaba.druid.sql.dialect.sqlserver.parser.SQLServerStatementParser;
import com.alibaba.druid.sql.parser.SQLStatementParser;
import com.alibaba.druid.sql.visitor.SQLASTOutputVisitor;
import com.dangdang.ddframe.rdb.sharding.constants.DatabaseType;
import com.dangdang.ddframe.rdb.sharding.exception.SQLParserException;
import com.dangdang.ddframe.rdb.sharding.parser.SQLParseEngine;
import com.dangdang.ddframe.rdb.sharding.parser.SQLVisitorRegistry;
import com.dangdang.ddframe.rdb.sharding.parser.visitor.VisitorLogProxy;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SQLParserFactory {
    private static final Logger log = LoggerFactory.getLogger(SQLParserFactory.class);

    public static SQLParseEngine create(DatabaseType databaseType, String sql, List<Object> parameters, Collection<String> shardingColumns) throws SQLParserException {
        log.debug("Logic SQL: {}, {}", (Object)sql, parameters);
        SQLStatement sqlStatement = SQLParserFactory.getSQLStatementParser(databaseType, sql).parseStatement();
        log.trace("Get {} SQL Statement", (Object)sqlStatement.getClass().getName());
        return new SQLParseEngine(sqlStatement, parameters, SQLParserFactory.getSQLVisitor(databaseType, sqlStatement), shardingColumns);
    }

    private static SQLStatementParser getSQLStatementParser(DatabaseType databaseType, String sql) {
        switch (databaseType) {
            case H2: 
            case MySQL: {
                return new MySqlStatementParser(sql);
            }
            case Oracle: {
                return new OracleStatementParser(sql);
            }
            case SQLServer: {
                return new SQLServerStatementParser(sql);
            }
            case DB2: {
                return new DB2StatementParser(sql);
            }
        }
        throw new UnsupportedOperationException(String.format("Cannot support database type [%s]", new Object[]{databaseType}));
    }

    private static SQLASTOutputVisitor getSQLVisitor(DatabaseType databaseType, SQLStatement sqlStatement) {
        if (sqlStatement instanceof SQLSelectStatement) {
            return VisitorLogProxy.enhance(SQLVisitorRegistry.getSelectVistor(databaseType));
        }
        if (sqlStatement instanceof SQLInsertStatement) {
            return VisitorLogProxy.enhance(SQLVisitorRegistry.getInsertVistor(databaseType));
        }
        if (sqlStatement instanceof SQLUpdateStatement) {
            return VisitorLogProxy.enhance(SQLVisitorRegistry.getUpdateVistor(databaseType));
        }
        if (sqlStatement instanceof SQLDeleteStatement) {
            return VisitorLogProxy.enhance(SQLVisitorRegistry.getDeleteVistor(databaseType));
        }
        throw new SQLParserException("Unsupported SQL statement: [%s]", sqlStatement);
    }

    private SQLParserFactory() {
    }
}

